/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import com.transsion.common.log.CS;
import com.transsion.core.CoreUtil;
import com.transsion.core.pool.TranssionPoolManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class AdbUtil {
    public static Process install(Context context, String filePath) {
        Process process = null;
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                String packageName = context.getPackageName();
                process = Runtime.getRuntime().exec("pm install -r -i " + packageName + " --user 0 " + filePath);
            } else {
                process = Runtime.getRuntime().exec("pm install -r " + filePath);
            }
        }
        catch (IOException e) {
            CS.log.d("download", "apk install exception: " + e.getLocalizedMessage());
        }
        return process;
    }

    public static void getCommandReulst(final Process process, final CommandResultCallback callback) {
        if (Build.VERSION.SDK_INT != 19) {
            TranssionPoolManager.getInstance().addTask(new Runnable(){

                @Override
                public void run() {
                    String successResult = AdbUtil.getStreamContent(process.getInputStream());
                    String errorResult = AdbUtil.getStreamContent(process.getErrorStream());
                    final String[] commandResult = new String[]{successResult, errorResult};
                    new Handler(CoreUtil.getContext().getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onResult(commandResult);
                        }
                    });
                }
            });
        }
    }

    private static String getStreamContent(InputStream inputStream) {
        BufferedReader reader = null;
        String content = null;
        reader = new BufferedReader(new InputStreamReader(inputStream));
        if (reader == null) {
            return content;
        }
        StringBuffer output = new StringBuffer();
        char[] buffer = new char[4096];
        try {
            int read;
            while ((read = reader.read(buffer)) > 0) {
                output.append(buffer, 0, read);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        content = output.toString();
        return content;
    }

    public static interface CommandResultCallback {
        public void onResult(String[] var1);
    }
}

