/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import java.util.List;

public class ContantUtil {
    public static boolean isSdCardAvailable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static Intent createIntent(Context context, String deepLink, String landingUrl, String browserPkg, Class webView) {
        if (!TextUtils.isEmpty((CharSequence)deepLink)) {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            Uri contentUri = Uri.parse((String)deepLink);
            intent.setData(contentUri);
            intent.setFlags(0x10008000);
            PackageManager packageManager = context.getPackageManager();
            List activities = packageManager.queryIntentActivities(intent, 0);
            if (activities.size() > 0) {
                return intent;
            }
            return ContantUtil.createIntent(context, null, landingUrl, browserPkg, webView);
        }
        if (!TextUtils.isEmpty((CharSequence)landingUrl) && (landingUrl.startsWith("http://") || landingUrl.startsWith("https://"))) {
            Intent intent = null;
            if (!TextUtils.isEmpty((CharSequence)browserPkg) && "webView".equalsIgnoreCase(browserPkg)) {
                intent = new Intent(context.getApplicationContext(), webView);
                intent.putExtra("url", landingUrl);
                intent.setFlags(0x10000000);
            } else {
                intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)landingUrl));
                intent.setFlags(0x10000000);
                if (null != browserPkg && browserPkg.length() > 3 && ContantUtil.isBrowserEnable(context, browserPkg)) {
                    intent.setPackage(browserPkg);
                }
            }
            return intent;
        }
        return null;
    }

    private static boolean isBrowserEnable(Context context, String pkgName) {
        int enableSetting;
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(pkgName, 0);
            enableSetting = context.getPackageManager().getApplicationEnabledSetting(pkgName);
        }
        catch (Exception e) {
            packageInfo = null;
            enableSetting = 2;
            e.printStackTrace();
        }
        return packageInfo != null && (0 == enableSetting || 1 == enableSetting);
    }
}

