/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.support.annotation.NonNull;
import com.transsion.appupdate.Tracker;
import com.transsion.athena.data.TrackData;
import com.transsion.ga.AthenaAnalytics;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private static CrashHandler sInstance = new CrashHandler();
    private Context mContext;

    private CrashHandler() {
    }

    public static CrashHandler getInstance() {
        return sInstance;
    }

    public void init(@NonNull Context context) {
        Thread.UncaughtExceptionHandler mDefaultCrashHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.mContext = context.getApplicationContext();
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try {
            this.exportException(e);
            Thread.sleep(10000L);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        e.printStackTrace();
        Process.killProcess((int)Process.myPid());
    }

    private void exportException(@NonNull Throwable e) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            sb.append("\n");
            sb.append(this.appendPhoneInfo());
            sb.append("\n");
            sb.append(CrashHandler.exception(e));
            TrackData trackData = new TrackData();
            trackData.add("data", sb.toString());
            AthenaAnalytics.getInstance((int)1019).track("except", trackData, Tracker.TID.TMS_CRASH.getTid());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (PackageManager.NameNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public static String exception(Throwable t) throws IOException {
        if (t == null) {
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            t.printStackTrace(new PrintStream(baos));
        }
        return baos.toString();
    }

    private String appendPhoneInfo() throws PackageManager.NameNotFoundException {
        PackageManager pm = this.mContext.getPackageManager();
        StringBuilder sb = new StringBuilder();
        PackageInfo pi = null;
        pi = pm.getPackageInfo(this.mContext.getPackageName(), 1);
        sb.append("App Version: ");
        sb.append(pi.versionName);
        sb.append("_");
        sb.append(pi.versionCode + "\n");
        sb.append("OS Version: ");
        sb.append(Build.VERSION.RELEASE);
        sb.append("_");
        sb.append(Build.VERSION.SDK_INT + "\n");
        sb.append("Vendor: ");
        sb.append(Build.MANUFACTURER + "\n");
        sb.append("Model: ");
        sb.append(Build.MODEL + "\n");
        sb.append("CPU: ");
        if (Build.VERSION.SDK_INT >= 21) {
            sb.append(Arrays.toString(Build.SUPPORTED_ABIS));
        } else {
            sb.append(Build.CPU_ABI);
        }
        return sb.toString();
    }
}

