/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.transsion.appupdate.R;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.data.DataRepository;
import com.transsion.appupdate.database.DBManager;
import com.transsion.appupdate.download.AppDownloadTaskManager;
import com.transsion.appupdate.download.CoreDownloadTaskManager;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.download.task.AppSilentDownLoadTask;
import com.transsion.appupdate.download.task.DownloadTask;
import com.transsion.appupdate.download.task.OsLabAppDownLoadTask;
import com.transsion.appupdate.download.task.OsLabAppSilentDownLoadTask;
import com.transsion.appupdate.oslabui.TrackerOsLab;
import com.transsion.appupdate.oslabui.reportBean.OsLabTrackBean;
import com.transsion.appupdate.reportBean.AppDownloadEvent;
import com.transsion.appupdate.utils.AppExecutors;
import com.transsion.appupdate.utils.FileUtil;
import com.transsion.appupdate.utils.NotifyUtils;
import com.transsion.appupdate.utils.PackageUtil;
import com.transsion.common.log.CS;
import com.transsion.newphonerecommend.NewPhoneRecommendManager;

public class InstallReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        int status = intent.getIntExtra("android.content.pm.extra.STATUS", 0);
        String msg = intent.getStringExtra("android.content.pm.extra.STATUS_MESSAGE");
        String pkg = intent.getStringExtra("android.content.pm.extra.PACKAGE_NAME");
        CS.log.d("TMS_DOWNLOAD", "\u5b89\u88c5\u5b8c\u6210\uff0cInstallReceiver status:" + status + " msg:" + msg + " pkg:" + pkg);
        if (TextUtils.isEmpty((CharSequence)pkg)) {
            return;
        }
        DataRepository.getInstance(context).queryByPkgName(AppDownLoadTask.obtain(), pkg, task -> {
            if (task != null && !TextUtils.isEmpty((CharSequence)task.url)) {
                this.handlerInstalled(context, task, "INSTALL_SUCCEEDED".equals(msg), msg);
                CS.log.d("TMS_UPDATE", "\u5217\u8868app\u5b89\u88c5\u5b8c\u6210");
            }
        });
        DataRepository.getInstance(context).queryByPkgName(OsLabAppDownLoadTask.obtain(), pkg, task -> {
            if (task != null && !TextUtils.isEmpty((CharSequence)task.url)) {
                this.handlerInstalled(context, task, "INSTALL_SUCCEEDED".equals(msg), msg);
                CS.log.d("TMS_UPDATE", "install app\u5b89\u88c5\u5b8c\u6210");
            }
        });
        AppExecutors.getInstance().work().execute(() -> {
            AppSilentDownLoadTask task = CoreDownloadTaskManager.getInstance(context).queryByPkgName(new AppSilentDownLoadTask(), pkg);
            if (task != null && !TextUtils.isEmpty((CharSequence)task.url)) {
                this.handlerInstalled(context, task, "INSTALL_SUCCEEDED".equals(msg), msg);
                CS.log.d("TMS_UPDATE", "\u9759\u9ed8\u5b89\u88c5\u5b8c\u6210");
            }
        });
        AppExecutors.getInstance().work().execute(() -> {
            OsLabAppSilentDownLoadTask task = CoreDownloadTaskManager.getInstance(context).queryByPkgName(new OsLabAppSilentDownLoadTask(), pkg);
            if (task != null && !TextUtils.isEmpty((CharSequence)task.url)) {
                this.handlerInstalled(context, task, "INSTALL_SUCCEEDED".equals(msg), msg);
                CS.log.d("TMS_UPDATE", "oslab \u9759\u9ed8\u5b89\u88c5\u5b8c\u6210");
            }
        });
    }

    private <T extends DownloadTask> void handlerInstalled(Context context, T task, boolean success, String msg) {
        CS.log.d("TMS_UPDATE", "\u5b89\u88c5\u5b8c\u6210\uff0csuccess\uff1a" + success);
        this.trackInstallData(task, success, msg);
        boolean deleteSuccess = FileUtil.deleteFile(task.filePath);
        CS.log.d("TMS_UPDATE", "\u5b89\u88c5\u5b8c\u6210\uff0capk\u5220\u9664\uff1a" + deleteSuccess);
        if (success) {
            if (task instanceof OsLabAppDownLoadTask) {
                OsLabAppDownLoadTask osLabAppDownLoadTask = (OsLabAppDownLoadTask)task;
                ContentValues values = new ContentValues();
                values.put("isUsedApk", Integer.valueOf(1));
                values.put("downloadState", DownloadState.INSTALLED.name());
                AppDownloadTaskManager.getInstance(context).updateDownloadTask(osLabAppDownLoadTask, values);
                CS.log.d("TMS_UPDATE", "\u5220\u9664\u7269\u6599");
            } else if (task instanceof OsLabAppSilentDownLoadTask) {
                OsLabAppSilentDownLoadTask oslabAppSilentDownLoadTask = (OsLabAppSilentDownLoadTask)task;
                int count = CoreDownloadTaskManager.getInstance(context).deleteDownload(oslabAppSilentDownLoadTask);
                CS.log.d("TMS_UPDATE", "\u9759\u9ed8\u5b89\u88c5\u5b8c\u6210\uff0c\u5220\u9664\u4e0b\u8f7d\u8bb0\u5f55\uff1a" + count);
                if (count > 0) {
                    DBManager.getInstance().deleteAppDetailByUrl(oslabAppSilentDownLoadTask.url);
                    CS.log.d("TMS_UPDATE", "\u5220\u9664\u7269\u6599");
                }
            } else if (task instanceof AppSilentDownLoadTask) {
                AppSilentDownLoadTask appSilentDownLoadTask = (AppSilentDownLoadTask)task;
                int count = CoreDownloadTaskManager.getInstance(context).deleteDownload(appSilentDownLoadTask);
                CS.log.d("TMS_UPDATE", "\u5b89\u88c5\u5b8c\u6210\uff0c\u5220\u9664\u4e0b\u8f7d\u8bb0\u5f55\uff1a" + count);
                if (count > 0) {
                    DBManager.getInstance().deleteAppDetailByUrl(appSilentDownLoadTask.url);
                    CS.log.d("TMS_UPDATE", "\u5220\u9664\u7269\u6599");
                }
            } else if (task instanceof AppDownLoadTask) {
                AppDownLoadTask appDownLoadTask = (AppDownLoadTask)task;
                PackageManager pm = context.getPackageManager();
                if (pm != null && !TextUtils.isEmpty((CharSequence)appDownLoadTask.pkgName)) {
                    Intent launchIntent = pm.getLaunchIntentForPackage(appDownLoadTask.pkgName);
                    NotifyUtils.sendIntentNotification(context, appDownLoadTask.title, context.getString(R.string.notification_app_installed), 11, launchIntent);
                }
                int count = AppDownloadTaskManager.getInstance(context).deleteDownload(appDownLoadTask);
                CS.log.d("TMS_UPDATE", "\u5b89\u88c5\u5b8c\u6210\uff0c\u5220\u9664\u4e0b\u8f7d\u8bb0\u5f55\uff1a" + count);
                if (count > 0) {
                    DBManager.getInstance().deleteAppDetailByUrl(appDownLoadTask.url);
                    CS.log.d("TMS_UPDATE", "\u5220\u9664\u7269\u6599");
                }
            }
        } else if (task instanceof AppSilentDownLoadTask) {
            AppSilentDownLoadTask appSilentDownLoadTask = (AppSilentDownLoadTask)task;
            CoreDownloadTaskManager.getInstance(context).deleteDownload(appSilentDownLoadTask);
            CS.log.d("TMS_UPDATE", "\u5b89\u88c5\u5931\u8d25 \u5220\u9664\u4efb\u52a1");
        } else if (task instanceof AppDownLoadTask) {
            AppDownLoadTask appDownLoadTask = (AppDownLoadTask)task;
            AppDownloadTaskManager.getInstance(context).deleteDownload(appDownLoadTask);
            CS.log.d("TMS_UPDATE", "\u5b89\u88c5\u5931\u8d25 \u5220\u9664\u4efb\u52a1");
        } else if (task instanceof OsLabAppSilentDownLoadTask) {
            OsLabAppSilentDownLoadTask appSilentDownLoadTask = (OsLabAppSilentDownLoadTask)task;
            CoreDownloadTaskManager.getInstance(context).deleteDownload(appSilentDownLoadTask);
            CS.log.d("TMS_UPDATE", "oslab\u9759\u9ed8\u5b89\u88c5\u5931\u8d25 \u5220\u9664\u4efb\u52a1");
        } else if (task instanceof OsLabAppDownLoadTask) {
            OsLabAppDownLoadTask appDownLoadTask = (OsLabAppDownLoadTask)task;
            AppDownloadTaskManager.getInstance(context).deleteDownload(appDownLoadTask);
            CS.log.d("TMS_UPDATE", "oslab\u5b89\u88c5\u5931\u8d25 \u5220\u9664\u4efb\u52a1");
        }
    }

    private <T extends DownloadTask> void trackInstallData(T task, boolean success, String msg) {
        if (task != null) {
            AppDownloadEvent eventData = new AppDownloadEvent();
            if (task instanceof OsLabAppDownLoadTask) {
                OsLabAppDownLoadTask oslabappDownLoadTask = (OsLabAppDownLoadTask)task;
                OsLabTrackBean osLabTrackBean = new OsLabTrackBean(oslabappDownLoadTask.pkgName, oslabappDownLoadTask.appVersionCode, oslabappDownLoadTask.apkType, success ? 1 : 2, -1, success ? "" : msg);
                TrackerOsLab.trackCommon(TrackerOsLab.TID.TMS_OSLAB_INSTALL_STATUS, osLabTrackBean);
                return;
            }
            if (task instanceof AppDownLoadTask) {
                AppDownLoadTask appDownLoadTask = (AppDownLoadTask)task;
                if (appDownLoadTask.apkType == 5) {
                    NewPhoneRecommendManager.trackInstallEnd((int)appDownLoadTask.appId, (String)appDownLoadTask.pkgName, (int)appDownLoadTask.appVersionCode, (boolean)success);
                    return;
                }
                eventData.setAppId(appDownLoadTask.appId);
                eventData.setAppPkg(appDownLoadTask.pkgName);
                eventData.setAppType(this.convertApkTypeToTrackApkType(appDownLoadTask.apkType));
                eventData.setAppVersion(appDownLoadTask.appVersionCode);
                eventData.setStatus(success ? 2 : -4);
                eventData.setFailReason(success ? -1 : 4);
                eventData.setTimes(appDownLoadTask.reDownloadTimes);
                eventData.setMediaPkgName(TextUtils.isEmpty((CharSequence)appDownLoadTask.mediaPkgName) ? PackageUtil.getSelfPackageName(null) : appDownLoadTask.mediaPkgName);
                eventData.setCreativeId(appDownLoadTask.CID);
            } else if (task instanceof AppSilentDownLoadTask) {
                AppSilentDownLoadTask appSilentDownLoadTask = (AppSilentDownLoadTask)task;
                eventData.setAppId(appSilentDownLoadTask.appId);
                eventData.setAppPkg(appSilentDownLoadTask.pkgName);
                eventData.setAppType(this.convertApkTypeToTrackApkType(0));
                eventData.setAppVersion(appSilentDownLoadTask.appVersionCode);
                eventData.setStatus(success ? 2 : -4);
                eventData.setFailReason(success ? -1 : 4);
                eventData.setTimes(appSilentDownLoadTask.reDownloadTimes);
            } else {
                return;
            }
            Tracker.track(Tracker.TID.TMS_APP_DOWNLOAD_STATUS, eventData.getBundle());
        }
    }

    private int convertApkTypeToTrackApkType(int apkType) {
        int trackApkType = -1;
        switch (apkType) {
            case 0: {
                trackApkType = 1;
                break;
            }
            case 1: {
                trackApkType = 2;
                break;
            }
            case 2: {
                trackApkType = 3;
                break;
            }
        }
        return trackApkType;
    }
}

