/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.content.Context;
import android.graphics.Point;
import android.view.WindowManager;

public class MeasureUtil {
    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int getDisplayHeight(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager == null) {
            return 0;
        }
        Point outPoint = new Point();
        windowManager.getDefaultDisplay().getRealSize(outPoint);
        return outPoint.y;
    }

    public static int getDisplayWidth(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager == null) {
            return 0;
        }
        Point outPoint = new Point();
        windowManager.getDefaultDisplay().getRealSize(outPoint);
        return outPoint.x;
    }

    public static int getDensityDpi(Context context) {
        return context.getResources().getDisplayMetrics().densityDpi;
    }
}

