/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import com.transsion.core.utils.NetUtil;

public class NetworkUtil {
    public static final String TYPE_ALL = "all";
    public static final String TYPE_WIFI = "wifi";
    public static final String TYPE_2G = "2g";
    public static final String TYPE_3G = "3g";
    public static final String TYPE_4G = "4g";
    public static final String TYPE_OTHER = "other";
    public static final String NO_NETWORK = "no";

    @NonNull
    public static String getNetworkType() {
        int type = NetUtil.getNetworkType();
        switch (type) {
            case -1: {
                return NO_NETWORK;
            }
            case -101: {
                return TYPE_WIFI;
            }
            case 1: {
                return TYPE_2G;
            }
            case 2: {
                return TYPE_3G;
            }
            case 3: {
                return TYPE_4G;
            }
        }
        return TYPE_OTHER;
    }

    public static boolean isAllowNetWork(String netWork) {
        boolean isAllow = false;
        String curNetWork = NetworkUtil.getNetworkType();
        if (null != netWork && netWork.contains(curNetWork)) {
            isAllow = true;
        }
        return isAllow;
    }

    public static boolean isConnected(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        if (manager != null) {
            NetworkInfo activeNetworkInfo = manager.getActiveNetworkInfo();
            return null != activeNetworkInfo && activeNetworkInfo.isAvailable();
        }
        return false;
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo ni = cm.getActiveNetworkInfo();
        return ni != null && ni.getType() == 1;
    }

    public static boolean isMobileData(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo ni = cm.getActiveNetworkInfo();
        return null != ni && ni.isAvailable() && ni.getType() == 0;
    }
}

