/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.transsion.common.log.CS;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Locale;

public class StorageUtils {
    public static boolean isAvailableToDownload(int allSize) {
        if (StorageUtils.isExternalStorageMounted()) {
            return (long)allSize < StorageUtils.getAvailableExternalStorage();
        }
        return false;
    }

    public static boolean isExternalStorageMounted() {
        String status = Environment.getExternalStorageState();
        return status.equals("mounted");
    }

    public static long getAvailableExternalStorage() {
        File file = Environment.getExternalStorageDirectory();
        StatFs statFs = new StatFs(file.getPath());
        return statFs.getAvailableBlocksLong() * statFs.getBlockSizeLong();
    }

    public static long getUsagePercent() {
        File file = Environment.getExternalStorageDirectory();
        StatFs statFs = new StatFs(file.getPath());
        return statFs.getAvailableBlocksLong() * 100L / statFs.getBlockCountLong();
    }

    public static String convertFromByte(int length) {
        double value = (double)length / Math.pow(1024.0, 3.0);
        if (value >= 0.1) {
            String valueStr = String.format(Locale.getDefault(), "%.2fGB", value);
            return valueStr;
        }
        value = (double)length / Math.pow(1024.0, 2.0);
        if (value >= 0.1) {
            String valueStr = String.format(Locale.getDefault(), "%.2fMB", value);
            return valueStr;
        }
        value = length / 1024;
        String valueStr = String.format(Locale.getDefault(), "%.2fKB", value);
        return valueStr;
    }

    public static long getAvailableInternalSpace(Context context) {
        File file = context.getFilesDir();
        StatFs statFs = new StatFs(file.getPath());
        if (Build.VERSION.SDK_INT > 17) {
            long availableBlocksLong = statFs.getAvailableBlocksLong();
            long blockSizeLong = statFs.getBlockSizeLong();
            CS.log.d("TMS_DOWNLOAD", "path:" + file.getPath());
            return availableBlocksLong * blockSizeLong / 1024L / 1024L;
        }
        int availableBlocks = statFs.getAvailableBlocks();
        int blockSize = statFs.getBlockSize();
        CS.log.d("TMS_DOWNLOAD", "path:" + file.getPath());
        return availableBlocks * blockSize / 1024 / 1024;
    }

    public static boolean isLessThanUsagePercent(long usagePercent) {
        try {
            long currentUsagePercent = StorageUtils.getUsagePercent();
            CS.log.d("TMS_COMMON", "current usage percent = " + currentUsagePercent);
            return currentUsagePercent < usagePercent;
        }
        catch (Exception e) {
            CS.log.e("TMS_COMMON", "getUsagePercent exception: " + e.getMessage());
            return true;
        }
    }

    public static void fixInputMethodManagerLeak(Context destContext) {
        if (destContext == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)destContext.getSystemService("input_method");
        if (imm == null) {
            return;
        }
        String[] arr = new String[]{"mCurRootView", "mServedView", "mNextServedView"};
        Field f = null;
        Object obj_get = null;
        for (int i = 0; i < arr.length; ++i) {
            String param = arr[i];
            try {
                f = imm.getClass().getDeclaredField(param);
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if ((obj_get = f.get(imm)) == null || !(obj_get instanceof View)) continue;
                View v_get = (View)obj_get;
                if (v_get.getContext() != destContext) break;
                f.set(imm, null);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

