/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.transsion.common.log.CS;

public class DBHelper
extends SQLiteOpenHelper {
    public DBHelper(Context context) {
        super(context, "tms_app.db", null, 4);
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS creative (id integer PRIMARY KEY, version integer, type integer, title varchar, anon_title varchar, sub_title varchar, desc varchar, sub_desc varchar, rating varchar, likes integer, conversion integer, price varchar, sale_price varchar, phone varchar, brand varchar, sponsored varchar, address varchar, show_url varchar, imp_tracker varchar, click_tracker varchar, network varchar, call_to_act varchar, extention varchar, whitelist varchar, blacklist varchar, gray_start_time varchar, gray_end_time varchar, valid_start_time integer, valid_end_time integer, freq_type integer, freq_limit_count integer, weight integer, app_id integer, download_silent integer, install_silent integer, deep_link varchar, click_through_url varchar, open_browser varchar, last_show_time integer default(0), used_freq_count integer default(1))");
        db.execSQL("CREATE TABLE IF NOT EXISTS app_detail (app_id integer PRIMARY KEY, title varchar, desc_version integer, desc varchar, sub_desc varchar, icon varchar, screenshots varchar, images varchar, category integer, website varchar, email varchar, phone varchar, policy varchar, whats_new varchar, download_url varchar, pkg_name varchar, version_name varchar, version_code integer, size integer, md5 varchar, valid_end_time integer)");
        db.execSQL("CREATE TABLE IF NOT EXISTS os_lab_app_detail (app_id integer PRIMARY KEY, title varchar, desc_version integer, desc varchar, sub_desc varchar, icon varchar, screenshots varchar, images varchar, category integer, website varchar, email varchar, phone varchar, policy varchar, whats_new varchar, download_url varchar, pkg_name varchar, version_name varchar, version_code integer, size integer, md5 varchar, valid_end_time integer)");
        db.execSQL("CREATE TABLE IF NOT EXISTS sdk_app_config (pkg_name varchar, sign_sha1 varchar, code_version integer, type integer, permission_list varchar, pid_list varchar, awake_start_time integer, awake_end_time integer, awake_interval integer, awake_last_time integer, fast_download integer default(0), traffic_remind integer default(1), PRIMARY KEY (pkg_name,sign_sha1))");
        db.execSQL("CREATE TABLE IF NOT EXISTS img_info (url varchar, cid integer, id varchar, md5 varchar, type varchar, weight integer, network varchar,cached_path varchar)");
        db.execSQL("CREATE TABLE IF NOT EXISTS del_creative (id integer PRIMARY KEY, version integer, save_time integer)");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        block5: for (int currentVersion = oldVersion + 1; currentVersion <= newVersion; ++currentVersion) {
            switch (currentVersion) {
                case 2: {
                    db.execSQL("CREATE TABLE IF NOT EXISTS os_lab_app_detail (app_id integer PRIMARY KEY, title varchar, desc_version integer, desc varchar, sub_desc varchar, icon varchar, screenshots varchar, images varchar, category integer, website varchar, email varchar, phone varchar, policy varchar, whats_new varchar, download_url varchar, pkg_name varchar, version_name varchar, version_code integer, size integer, md5 varchar, valid_end_time integer)");
                    continue block5;
                }
                case 3: {
                    this.addCallToActionColumn(db);
                    continue block5;
                }
                case 4: {
                    this.addDLConfigToSdkAppConfig(db);
                    continue block5;
                }
            }
        }
    }

    private void addCallToActionColumn(SQLiteDatabase db) {
        try {
            String addColumnSql = "alter table creative add column call_to_act varchar";
            db.execSQL(addColumnSql);
        }
        catch (Exception e) {
            CS.log.e("TMS_COMMON", e.getMessage());
        }
    }

    private void addDLConfigToSdkAppConfig(SQLiteDatabase db) {
        try {
            StringBuilder fastDownloadSQL = new StringBuilder("alter table ");
            fastDownloadSQL.append("sdk_app_config");
            fastDownloadSQL.append(" add column ");
            fastDownloadSQL.append("fast_download");
            fastDownloadSQL.append(" integer default 0");
            db.execSQL(fastDownloadSQL.toString());
        }
        catch (Exception e) {
            CS.log.e("TMS_COMMON", e.getMessage());
        }
        try {
            StringBuilder trafficRemindSQL = new StringBuilder("alter table ");
            trafficRemindSQL.append("sdk_app_config");
            trafficRemindSQL.append(" add column ");
            trafficRemindSQL.append("traffic_remind");
            trafficRemindSQL.append(" integer default 1");
            db.execSQL(trafficRemindSQL.toString());
        }
        catch (Exception e) {
            CS.log.e("TMS_COMMON", e.getMessage());
        }
    }
}

