/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.download;

import android.content.Context;
import android.text.TextUtils;
import com.transsion.appupdate.download.DownloadCallbackInterface;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.task.DownloadTask;
import com.transsion.appupdate.utils.SecurityUtil;
import com.transsion.common.log.CS;
import com.transsion.core.CoreUtil;
import com.transsion.http.DownloadEngineEx;
import com.transsion.http.HttpClient;
import com.transsion.http.RequestCall;
import com.transsion.http.builder.DownloadRequestBuilder;
import com.transsion.http.impl.DownloadCallback;
import java.io.File;

class DownloadOperator {
    private static final int DownloadTaskCount = 1;
    private RequestCall mRequestCall;
    private DownloadTask mDownloadTask;
    private DownloadCallbackInterface mListener;
    private DownloadEngineEx downloadEngine;

    DownloadOperator(DownloadCallbackInterface listener, DownloadTask downloadTask) {
        this.mListener = listener;
        this.mDownloadTask = downloadTask;
        this.mRequestCall = ((DownloadRequestBuilder)((DownloadRequestBuilder)((DownloadRequestBuilder)HttpClient.download((Context)CoreUtil.getContext()).pathname(this.mDownloadTask.filePath).url(this.mDownloadTask.url)).log(false)).tag((Object)this.mDownloadTask.url)).build();
        this.downloadEngine = DownloadEngineEx.getEngine((String)downloadTask.getClass().getSimpleName(), (int)1);
    }

    void pauseDownload() {
        this.downloadEngine.pauseLoad((Object)this.mDownloadTask.url);
    }

    @Deprecated
    void stopDownload() {
        CS.log.i("TMS_DOWNLOAD", "stop download.");
        this.downloadEngine.cancelLoad((Object)this.mDownloadTask.url);
    }

    void continueDownload() {
        this.downloadEngine.continueLoad((Object)this.mDownloadTask.url);
    }

    void startDownload() {
        this.mListener.onWait(this.mDownloadTask);
        this.downloadEngine.execute(this.mRequestCall, new DownloadCallback(){

            public void onFailure(String s, String s1) {
                CS.log.e("TMS_DOWNLOAD", "\u4e0b\u8f7d\u5931\u8d25\uff0cURL\uff1a" + ((DownloadOperator)DownloadOperator.this).mDownloadTask.url);
                ((DownloadOperator)DownloadOperator.this).mDownloadTask.downloadState = DownloadState.FAILED;
                DownloadOperator.this.mListener.onFailed(DownloadOperator.this.mDownloadTask, 0, s + "--" + s1);
            }

            public void onSuccess(String s, File file) {
                boolean isRealSuccess = DownloadOperator.this.checkApkMd5(file);
                if (isRealSuccess) {
                    long size = file.length();
                    CS.log.d("TMS_DOWNLOAD", "\u4e0b\u8f7d\u6210\u529f\uff0c\u6821\u9a8c\u6210\u529f" + size + "/" + size);
                    ((DownloadOperator)DownloadOperator.this).mDownloadTask.downloadState = DownloadState.FINISHED;
                    ((DownloadOperator)DownloadOperator.this).mDownloadTask.finishedSize = size;
                    ((DownloadOperator)DownloadOperator.this).mDownloadTask.totalSize = size;
                    DownloadOperator.this.mListener.onSuccess(DownloadOperator.this.mDownloadTask);
                } else {
                    CS.log.e("TMS_DOWNLOAD", "\u4e0b\u8f7d\u6210\u529f\uff0c\u6821\u9a8c\u5931\u8d25");
                    ((DownloadOperator)DownloadOperator.this).mDownloadTask.downloadState = DownloadState.FAILED;
                    DownloadOperator.this.mListener.onFailed(DownloadOperator.this.mDownloadTask, 3, "ERROR_MD5");
                }
            }

            public void onLoading(String s, long finishedSize, long totalSize) {
                CS.log.d("TMS_DOWNLOAD", "\u4e0b\u8f7d\u8fdb\u5ea6\uff1a" + finishedSize + "/" + totalSize + "  " + ((DownloadOperator)DownloadOperator.this).mDownloadTask.url);
                ((DownloadOperator)DownloadOperator.this).mDownloadTask.finishedSize = finishedSize;
                ((DownloadOperator)DownloadOperator.this).mDownloadTask.totalSize = totalSize;
                ((DownloadOperator)DownloadOperator.this).mDownloadTask.downloadState = DownloadState.DOWNLOADING;
                DownloadOperator.this.mListener.onLoading(DownloadOperator.this.mDownloadTask);
            }

            public void onPause() {
                CS.log.d("TMS_DOWNLOAD", "\u4e0b\u8f7d\u6682\u505c\uff0c" + ((DownloadOperator)DownloadOperator.this).mDownloadTask.url);
                ((DownloadOperator)DownloadOperator.this).mDownloadTask.downloadState = DownloadState.PAUSE;
                DownloadOperator.this.mListener.onPause(DownloadOperator.this.mDownloadTask);
            }

            public void onCancel() {
                CS.log.e("TMS_DOWNLOAD", "\u4e0b\u8f7d\u53d6\u6d88" + ((DownloadOperator)DownloadOperator.this).mDownloadTask.url);
                DownloadOperator.this.mListener.onRemoved(DownloadOperator.this.mDownloadTask);
            }

            public void onStart() {
                CS.log.d("TMS_DOWNLOAD", "\u4e0b\u8f7d\u5f00\u59cb" + ((DownloadOperator)DownloadOperator.this).mDownloadTask.url);
                ((DownloadOperator)DownloadOperator.this).mDownloadTask.downloadState = DownloadState.DOWNLOADING;
                DownloadOperator.this.mListener.onStart(DownloadOperator.this.mDownloadTask);
            }
        });
    }

    private boolean checkApkMd5(File file) {
        boolean isRealSuccess = false;
        if (file.exists() && file.isFile()) {
            isRealSuccess = true;
            CS.log.d("TMS_DOWNLOAD", "file.exists() && file.isFile()");
            String fileMd5 = SecurityUtil.getFileMD5Self(file);
            String fileMd5_new = SecurityUtil.getFileMD5(file);
            if (!(TextUtils.isEmpty((CharSequence)fileMd5) || TextUtils.isEmpty((CharSequence)fileMd5_new) || TextUtils.isEmpty((CharSequence)this.mDownloadTask.md5))) {
                isRealSuccess = fileMd5.equalsIgnoreCase(this.mDownloadTask.md5) || fileMd5_new.equalsIgnoreCase(this.mDownloadTask.md5);
            }
        }
        return isRealSuccess;
    }
}

