/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.oslabui.viewholder;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.oslabui.OsLabAppItemView;
import com.transsion.appupdate.oslabui.OsLabAppUpdateAdapter;
import com.transsion.appupdate.oslabui.detail.OsLabAppUpdateDetailActivity;
import com.transsion.appupdate.oslabui.viewholder.BaseViewHolder;
import com.transsion.appupdate.utils.UpdateConstants;

public class OsLabAppViewHolder
extends BaseViewHolder {
    private OsLabAppItemView mItemView;

    public OsLabAppViewHolder(View itemView) {
        super(itemView);
        this.mItemView = (OsLabAppItemView)itemView;
    }

    @Override
    public void bindView(int pos, AppItem item, OsLabAppUpdateAdapter.OnDownloadListener downListener) {
        this.mItemView.bindView(item);
        this.mItemView.getStateBtn().setOnClickListener(v -> {
            if (downListener != null) {
                downListener.onDownload(pos, item);
            }
            if (UpdateConstants.STATE_INSTALLED.equals(item.state)) {
                this.mItemView.setOpen(item);
            }
        });
        this.mItemView.setOnClickListener(v -> {
            Intent intent = new Intent(this.mItemView.getContext(), OsLabAppUpdateDetailActivity.class);
            Bundle bundle = new Bundle();
            bundle.putParcelable("item_info", (Parcelable)item);
            intent.putExtras(bundle);
            if (this.mItemView.getContext() instanceof Activity) {
                ((Activity)this.mItemView.getContext()).startActivityForResult(intent, 161);
            } else {
                this.mItemView.getContext().startActivity(intent);
            }
        });
    }

    @Override
    public void changeState(AppItem item) {
        this.mItemView.setState(item);
    }
}

