/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.service;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.PersistableBundle;
import android.text.TextUtils;
import com.transsion.appupdate.data.Callback;
import com.transsion.appupdate.download.AppDownloadTaskManager;
import com.transsion.appupdate.download.DownloadHelper;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.utils.AppExecutors;
import com.transsion.appupdate.utils.FileUtil;
import com.transsion.appupdate.utils.NetworkUtil;
import com.transsion.appupdate.utils.PackageUtil;
import com.transsion.appupdate.utils.StorageUtils;
import com.transsion.common.log.CS;
import com.transsion.commonlib.config.CSLib;
import com.transsion.core.CoreUtil;
import com.transsion.json.Tson;
import com.transsion.newphonerecommend.NewPhoneRecommendManager;
import com.transsion.newphonerecommend.bean.AppDetailInfo;
import com.transsion.newphonerecommend.bean.ImgInfo;
import com.transsion.newphonerecommend.bean.RecommendTaskData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NewPhoneRecommendJobService
extends JobService {
    public static final int ENFORCE_JOB_ID = 369;
    private static long INTERVAL = CSLib.TEST_MODE ? 300000L : 1800000L;

    public static void startJob(Context context) {
        INTERVAL = CSLib.TEST_MODE ? 300000L : 1800000L;
        JobScheduler js = (JobScheduler)context.getSystemService("jobscheduler");
        if (js != null) {
            CS.log.d("TMS_APP", " ---> call startJob  NewPhoneRecommendJobService ...");
            js.schedule(new JobInfo.Builder(369, new ComponentName(context, NewPhoneRecommendJobService.class)).setRequiredNetworkType(1).setOverrideDeadline(INTERVAL * 2L).build());
        }
    }

    public boolean onStopJob(JobParameters params) {
        CS.log.d("TMS_UPDATE", "onStopJob Id: " + params.getJobId());
        return false;
    }

    public boolean onStartJob(JobParameters params) {
        CS.log.d("TMS_APP", "===== onStartJob  NewPhoneRecommendJobService DEFAULT_INTERVAL->" + INTERVAL + " / " + CSLib.TEST_MODE);
        this.newPhoneRecommendJob(params);
        JobScheduler js = (JobScheduler)this.getSystemService("jobscheduler");
        if (js != null) {
            js.schedule(new JobInfo.Builder(369, new ComponentName((Context)this, NewPhoneRecommendJobService.class)).setRequiredNetworkType(1).setOverrideDeadline(INTERVAL * 2L).setPersisted(true).setMinimumLatency(INTERVAL).build());
        }
        return false;
    }

    void newPhoneRecommendJob(JobParameters params) {
        PersistableBundle extras = params.getExtras();
        String jsonData = extras.getString("recommend_data");
        if (!TextUtils.isEmpty((CharSequence)jsonData)) {
            try {
                RecommendTaskData data = (RecommendTaskData)Tson.fromJson((String)jsonData, RecommendTaskData.class);
                List appDetailInfoList = data.getAppDetailInfoList();
                if (appDetailInfoList != null) {
                    for (AppDetailInfo appDetailInfo : appDetailInfoList) {
                        AppDownLoadTask task = new AppDownLoadTask(appDetailInfo.getDownloadUrl(), appDetailInfo.getMd5(), appDetailInfo.getSize(), FileUtil.createApkDownloadPath(CoreUtil.getContext(), appDetailInfo.getDownloadUrl()), DownloadState.INITIAL, appDetailInfo.getPkgName(), appDetailInfo.getIcon().getUrl(), appDetailInfo.getTitle(), appDetailInfo.getAppId(), true, appDetailInfo.getVersionName(), appDetailInfo.getVersionCode(), 5, appDetailInfo.getDescription(), this.getImgUrl(appDetailInfo));
                        DownloadHelper.getInstance().addAppDownload(task);
                    }
                }
            }
            catch (Exception e) {
                CS.log.e("TMS_UPDATE", e.getMessage());
            }
        }
        this.loadRecommendList(taskList -> {
            CS.log.d("TMS_UPDATE", "newPhoneRecommendJob\uff0cneed recommend apps \uff1a" + taskList);
            if (taskList.size() > 0) {
                this.download((List<AppDownLoadTask>)taskList);
            } else {
                this.stopSelf();
            }
        });
    }

    private String getImgUrl(AppDetailInfo info) {
        if (info == null || info.getImages() == null || info.getImages().size() <= 0) {
            return null;
        }
        return ((ImgInfo)info.getImages().get(0)).getUrl();
    }

    public void loadRecommendList(Callback<List<AppDownLoadTask>> callback) {
        AppExecutors.getInstance().work().execute(() -> {
            List<AppDownLoadTask> appTaskList = AppDownloadTaskManager.getInstance(this.getApplicationContext()).getAllDownloadTask(AppDownLoadTask.obtain());
            if (appTaskList != null && appTaskList.size() > 0) {
                Iterator<AppDownLoadTask> iterator = appTaskList.iterator();
                while (iterator.hasNext()) {
                    AppDownLoadTask task = iterator.next();
                    if (task.apkType != 5) {
                        CS.log.d("TMS_UPDATE", "[newPhoneRecommendJob filter]not recommend type apk: " + task.appId + ", " + task.pkgName);
                        iterator.remove();
                        continue;
                    }
                    if (task.downloadState != DownloadState.PAUSE) continue;
                    CS.log.d("TMS_UPDATE", "[newPhoneRecommendJob filter]task download state pause: " + task.appId + ", " + task.pkgName);
                    iterator.remove();
                }
                this.checkRecommendApk(appTaskList);
                AppExecutors.getInstance().ui().execute(() -> {
                    if (callback != null) {
                        callback.onCallback(appTaskList);
                    }
                });
            }
        });
    }

    private void checkRecommendApk(List<AppDownLoadTask> recommendTasks) {
        ArrayList<AppDownLoadTask> removeRecommendTasks = new ArrayList<AppDownLoadTask>();
        for (AppDownLoadTask task : recommendTasks) {
            PackageInfo packageInfo = PackageUtil.getPackageInfo(this.getApplicationContext(), task.pkgName);
            if (packageInfo == null || packageInfo.versionCode < task.appVersionCode) continue;
            removeRecommendTasks.add(task);
        }
        recommendTasks.removeAll(removeRecommendTasks);
    }

    private void download(List<AppDownLoadTask> list) {
        CS.log.d("TMS_UPDATE", "\u5f00\u59cb\u4e0b\u8f7d, list:" + list);
        if (list == null) {
            return;
        }
        if (StorageUtils.getAvailableInternalSpace(this.getApplicationContext()) <= 200L) {
            CS.log.d("TMS_UPDATE", "\u88c5\u673a\u63a8\u8350\u4e0b\u8f7d\uff0c\u7a7a\u95f4\u4e0d\u8db3");
            return;
        }
        if (NetworkUtil.isConnected(this.getApplicationContext())) {
            if (!NewPhoneRecommendManager.isNetworkAllowed((Context)this.getApplicationContext())) {
                return;
            }
            CS.log.d("TMS_UPDATE", "\u5f00\u59cb\u4e0b\u8f7d\u88c5\u673a\u63a8\u8350\u5e94\u7528");
            AppDownloadTaskManager appDownloadTaskManager = AppDownloadTaskManager.getInstance(this.getApplicationContext());
            for (AppDownLoadTask task : list) {
                task.downloadState = DownloadState.WAITING;
                appDownloadTaskManager.startDownload(task);
            }
        } else {
            CS.log.e("TMS_UPDATE", "\u88c5\u673a\u63a8\u8350\uff0c\u65e0\u7f51\u7edc");
            this.scheduleRecommendJob();
        }
    }

    private void scheduleRecommendJob() {
        CS.log.d("TMS_UPDATE", "scheduleRecommendJob");
        JobScheduler js = (JobScheduler)this.getSystemService("jobscheduler");
        if (js != null) {
            js.schedule(new JobInfo.Builder(369, new ComponentName((Context)this, NewPhoneRecommendJobService.class)).setRequiredNetworkType(1).setMinimumLatency(3600000L).setOverrideDeadline(3660000L).build());
        }
    }
}

