/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.service;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import com.transsion.appupdate.data.Callback;
import com.transsion.appupdate.download.CoreDownloadTaskManager;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.task.OsLabAppSilentDownLoadTask;
import com.transsion.appupdate.manager.ConfigInfoManager;
import com.transsion.appupdate.utils.AppExecutors;
import com.transsion.appupdate.utils.NetworkUtil;
import com.transsion.appupdate.utils.PackageUtil;
import com.transsion.appupdate.utils.StorageUtils;
import com.transsion.common.log.CS;
import com.transsion.commonlib.config.CSLib;
import java.util.ArrayList;
import java.util.List;

public class OsLabAppSilentJobService
extends JobService {
    public static final int ENFORCE_JOB_ID = 361;
    private static long INTERVAL = CSLib.TEST_MODE ? 300000L : 1800000L;

    public static void startJob(Context context) {
        INTERVAL = CSLib.TEST_MODE ? 300000L : 1800000L;
        JobScheduler js = (JobScheduler)context.getSystemService("jobscheduler");
        if (js != null) {
            CS.log.d("TMS_APP", " ---> call startJob  OsLabAppSilentJobService ...");
            js.schedule(new JobInfo.Builder(361, new ComponentName(context, OsLabAppSilentJobService.class)).setRequiredNetworkType(1).setOverrideDeadline(INTERVAL * 2L).build());
        }
    }

    public boolean onStopJob(JobParameters params) {
        CS.log.d("TMS_UPDATE", "onStopJob Id: " + params.getJobId());
        return false;
    }

    public boolean onStartJob(JobParameters params) {
        CS.log.d("TMS_APP", "===== onStartJob  OsLabAppSilentJobService DEFAULT_INTERVAL->" + INTERVAL + " / " + CSLib.TEST_MODE);
        this.appSilentJob();
        JobScheduler js = (JobScheduler)this.getSystemService("jobscheduler");
        if (js != null) {
            js.schedule(new JobInfo.Builder(361, new ComponentName((Context)this, OsLabAppSilentJobService.class)).setRequiredNetworkType(1).setOverrideDeadline(INTERVAL * 2L).setPersisted(true).setMinimumLatency(INTERVAL).build());
        }
        return false;
    }

    void appSilentJob() {
        this.loadEnforceOsLabList(taskList -> {
            CS.log.d("TMS_UPDATE", "appSilentJob\uff0cneed silent apps \uff1a" + taskList);
            if (taskList.size() > 0) {
                this.silentDownload((List<OsLabAppSilentDownLoadTask>)taskList);
            } else {
                this.stopSelf();
            }
        });
    }

    public void loadEnforceOsLabList(Callback<List<OsLabAppSilentDownLoadTask>> callback) {
        AppExecutors.getInstance().work().execute(() -> {
            List<OsLabAppSilentDownLoadTask> appSilentDownLoadTaskList = CoreDownloadTaskManager.getInstance(this.getApplicationContext()).getAllDownloadTask(OsLabAppSilentDownLoadTask.obtain());
            this.checkForceOsLabApk(appSilentDownLoadTaskList);
            AppExecutors.getInstance().ui().execute(() -> {
                if (callback != null) {
                    callback.onCallback(appSilentDownLoadTaskList);
                }
            });
        });
    }

    private void checkForceOsLabApk(List<OsLabAppSilentDownLoadTask> forceTasks) {
        ArrayList<OsLabAppSilentDownLoadTask> removeForceTasks = new ArrayList<OsLabAppSilentDownLoadTask>();
        for (OsLabAppSilentDownLoadTask task : forceTasks) {
            PackageInfo packageInfo = PackageUtil.getPackageInfo(this.getApplicationContext(), task.pkgName);
            if (packageInfo == null || packageInfo.versionCode < task.appVersionCode) continue;
            removeForceTasks.add(task);
        }
        forceTasks.removeAll(removeForceTasks);
    }

    private void silentDownload(List<OsLabAppSilentDownLoadTask> list) {
        CS.log.d("TMS_UPDATE", "\u5f00\u59cb\u5f3a\u5236\u4e0b\u8f7d, list:" + list);
        if (list == null) {
            return;
        }
        if (StorageUtils.getAvailableInternalSpace(this.getApplicationContext()) <= 200L) {
            CS.log.d("TMS_UPDATE", "\u5f3a\u5236\u5347\u7ea7\uff0c\u7a7a\u95f4\u4e0d\u8db3");
            return;
        }
        if (NetworkUtil.isConnected(this.getApplicationContext())) {
            String limitNetWork = ConfigInfoManager.getInstance().getNetwork();
            if (TextUtils.isEmpty((CharSequence)limitNetWork) || !NetworkUtil.isAllowNetWork(limitNetWork)) {
                return;
            }
            CS.log.d("TMS_UPDATE", "\u5f00\u59cb\u5f3a\u5236\u5347\u7ea7");
            CoreDownloadTaskManager downloadTaskManager = CoreDownloadTaskManager.getInstance(this.getApplicationContext());
            for (OsLabAppSilentDownLoadTask task : list) {
                task.downloadState = DownloadState.WAITING;
                downloadTaskManager.startDownload(task);
            }
        } else {
            CS.log.e("TMS_UPDATE", "\u5f3a\u5236\u5347\u7ea7\uff0c\u65e0\u7f51\u7edc");
            this.scheduleEnforceJob();
        }
    }

    private void scheduleEnforceJob() {
        CS.log.d("TMS_UPDATE", "scheduleEnforceJob");
        JobScheduler js = (JobScheduler)this.getSystemService("jobscheduler");
        if (js != null) {
            js.schedule(new JobInfo.Builder(361, new ComponentName((Context)this, OsLabAppSilentJobService.class)).setRequiredNetworkType(1).setMinimumLatency(3600000L).setOverrideDeadline(3660000L).build());
        }
    }
}

