/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.service;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.Nullable;
import com.transsion.appupdate.R;
import com.transsion.appupdate.download.AppDownloadTaskManager;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.ui.main.AppUpdateActivity;
import java.util.List;

public class UiService
extends Service {
    public static final String PARAM_KEY_TASK_ACTION = "TASK_ACTION";
    public static final int PARAM_VALUE_TASK_ADD = 0;
    public static final int PARAM_VALUE_TASK_FINISH = 1;
    public static final int PARAM_VALUE_TASK_PAUSE = 2;
    public static final String PARAM_KEY_TASK_APK_TYPE = "TASK_APK_TYPE";
    private static Handler handler = new Handler();
    private int mTotalCount = 0;
    private int mCompleteCount = 0;

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (null != intent) {
            int action = intent.getIntExtra(PARAM_KEY_TASK_ACTION, -1);
            int taskApkType = intent.getIntExtra(PARAM_KEY_TASK_APK_TYPE, -1);
            if (action == 0) {
                handler.removeCallbacksAndMessages(null);
                ++this.mTotalCount;
                String title = this.getString(R.string.notification_dl_title);
                String text = this.getString(R.string.notification_dl_detail, new Object[]{this.mTotalCount, this.mCompleteCount});
                this.sendNormalNotification((Context)this, title, text, 12, taskApkType);
            } else if (action == 1) {
                handler.removeCallbacksAndMessages(null);
                ++this.mCompleteCount;
                String title = this.getString(R.string.notification_dl_title);
                String text = this.getString(R.string.notification_dl_detail, new Object[]{this.mTotalCount, this.mCompleteCount});
                this.sendNormalNotification((Context)this, title, text, 12, taskApkType);
                handler.postDelayed(this::stopForegroundIfNoTask, 15000L);
            } else if (action == 2) {
                handler.removeCallbacksAndMessages(null);
                --this.mTotalCount;
                String title = this.getString(R.string.notification_dl_title);
                String text = this.getString(R.string.notification_dl_detail, new Object[]{this.mTotalCount, this.mCompleteCount});
                this.sendNormalNotification((Context)this, title, text, 12, taskApkType);
                handler.postDelayed(this::stopForegroundIfNoTask, 15000L);
            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    private void stopForegroundIfNoTask() {
        List<AppDownLoadTask> waitList = AppDownloadTaskManager.getInstance(this.getApplicationContext()).getAllDownloadTaskByState(new AppDownLoadTask(), DownloadState.WAITING);
        if (waitList != null && !waitList.isEmpty()) {
            return;
        }
        List<AppDownLoadTask> downloadingList = AppDownloadTaskManager.getInstance(this.getApplicationContext()).getAllDownloadTaskByState(new AppDownLoadTask(), DownloadState.DOWNLOADING);
        if (downloadingList != null && !downloadingList.isEmpty()) {
            return;
        }
        this.stopForeground(true);
        this.mTotalCount = 0;
        this.mCompleteCount = 0;
    }

    private void sendNormalNotification(Context context, String title, String text, int notificationId, int taskApkType) {
        Notification.Builder builder;
        if (context == null) {
            return;
        }
        Intent intent = new Intent(context, AppUpdateActivity.class);
        intent.putExtra("enterType", "notification");
        if (taskApkType == 5) {
            intent.putExtra("notificationApkType", taskApkType);
        }
        intent.addFlags(0x10000000);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        if (nm == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            String channelId = "appUpdate";
            String channelName = "appUpdate";
            NotificationChannel notificationChannel = new NotificationChannel(channelId, (CharSequence)channelName, 2);
            notificationChannel.enableVibration(false);
            nm.createNotificationChannel(notificationChannel);
            builder = new Notification.Builder(context, channelId).setSmallIcon(17301589).setContentIntent(pendingIntent).setChannelId(channelId).setGroup("appUpdate").setAutoCancel(true).setContentTitle((CharSequence)title).setContentText((CharSequence)text);
        } else {
            builder = new Notification.Builder(context).setSmallIcon(17301589).setContentIntent(pendingIntent).setGroup("appUpdate").setAutoCancel(true).setContentTitle((CharSequence)title).setContentText((CharSequence)text);
        }
        this.startForeground(notificationId, builder.build());
    }
}

