/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.ui.edit;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.widget.CheckBox;
import android.widget.TextView;
import com.transsion.appupdate.R;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.data.DataRepository;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.reportBean.UserActionData;
import com.transsion.appupdate.ui.edit.AppEditAdapter;
import com.transsion.appupdate.ui.edit.DeleteFragment;
import com.transsion.appupdate.utils.PhoneUtil;
import com.transsion.widgetslibs.widgets.FootOptBar;
import java.util.ArrayList;

public class AppEditActivity
extends Activity {
    private TextView mCountView;
    private CheckBox mCheckSelect;
    private RecyclerView mRecyclerEdit;
    private AppEditAdapter mAdapter;
    private FootOptBar mFootOptBar;
    private DeleteFragment mDeleteFragment;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        PhoneUtil.setStatusBarAndNavigation(this, false);
        super.onCreate(savedInstanceState);
        this.setLightNavBar();
        this.setContentView(R.layout.activity_app_edit);
        this.mCountView = (TextView)this.findViewById(R.id.text_count);
        this.findViewById(R.id.btn_back).setOnClickListener(v -> {
            this.setResult(0);
            this.finish();
        });
        this.mCheckSelect = (CheckBox)this.findViewById(R.id.check_select);
        this.mCheckSelect.setOnClickListener(v -> {
            if (this.mAdapter != null) {
                int size;
                int checkedCount = this.mAdapter.checkedCount();
                this.mAdapter.checkAll(checkedCount < (size = this.mAdapter.getItemCount()));
                this.updateView();
            }
        });
        this.mRecyclerEdit = (RecyclerView)this.findViewById(R.id.recycler_edit);
        this.mRecyclerEdit.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.mFootOptBar = (FootOptBar)this.findViewById(R.id.foot_opt_bar);
        this.mFootOptBar.addItemViews(new int[]{R.drawable.ic_delete_icon_vector}, new int[]{R.string.delete});
        this.mFootOptBar.changeItemEnable(0, false);
        this.mFootOptBar.setOnFootItemClickListener(index -> this.showDeleteDialog());
        DataRepository.getInstance((Context)this).loadPausedAppItems(this::updateData);
    }

    private void setLightNavBar() {
        if (Build.VERSION.SDK_INT >= 26) {
            this.getWindow().getDecorView().setSystemUiVisibility(this.getWindow().getDecorView().getSystemUiVisibility() | 0x10);
        }
    }

    private void updateData(ArrayList<AppItem> list) {
        this.mAdapter = new AppEditAdapter(this.getLayoutInflater(), list);
        this.mRecyclerEdit.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.setOnItemCheckListener(this::updateView);
        this.updateView();
    }

    private void updateView() {
        int checkedCount = this.mAdapter.checkedCount();
        int size = this.mAdapter.getItemCount();
        String title = checkedCount + "/" + size;
        this.mCountView.setText((CharSequence)title);
        this.mCheckSelect.setChecked(size > 0 && checkedCount == size);
        this.mFootOptBar.changeItemEnable(0, checkedCount > 0);
    }

    private void showDeleteDialog() {
        if (this.mDeleteFragment == null) {
            this.mDeleteFragment = new DeleteFragment();
            this.mDeleteFragment.setOnDeleteListener(this::deleteFiles);
        }
        if (!this.mDeleteFragment.isAdded()) {
            this.mDeleteFragment.show(this.getFragmentManager(), "DeleteFragment");
        }
    }

    private void deleteFiles() {
        this.mFootOptBar.changeItemEnable(0, false);
        ArrayList<Boolean> checkList = this.mAdapter.getCheckList();
        ArrayList<AppItem> list = this.mAdapter.getList();
        ArrayList<String> urls = new ArrayList<String>();
        ArrayList<String> appIds = new ArrayList<String>();
        for (int i = checkList.size() - 1; i >= 0; --i) {
            if (!checkList.get(i).booleanValue()) continue;
            UserActionData data = new UserActionData();
            data.setAppId(list.get((int)i).appId);
            data.setAppVersion(list.get((int)i).appVersionCode);
            Tracker.track(Tracker.TID.TMS_APP_LIST_CLICK_DELETE, data.getBundle());
            urls.add(list.get((int)i).apkUrl);
            appIds.add(String.valueOf(list.get((int)i).appId));
            list.remove(i);
            checkList.remove(i);
        }
        DataRepository.getInstance((Context)this).deleteDownloadTasks(urls, isOk -> {
            if (list.size() == 0) {
                this.setResult(0);
                this.finish();
            }
        });
        this.mAdapter.notifyDataSetChanged();
        this.updateView();
    }

    protected void onDestroy() {
        this.mDeleteFragment = null;
        super.onDestroy();
    }
}

