/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.ui.main;

import android.app.Activity;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupMenu;
import android.widget.TextView;
import android.widget.Toast;
import com.transsion.appupdate.R;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.entity.ListItem;
import com.transsion.appupdate.reportBean.TrafficDialogClickData;
import com.transsion.appupdate.reportBean.TrafficDialogShowData;
import com.transsion.appupdate.reportBean.UserActionDLTaskData;
import com.transsion.appupdate.ui.edit.AppEditActivity;
import com.transsion.appupdate.ui.main.AlertMobileFragment;
import com.transsion.appupdate.ui.main.AppUpdateAdapter;
import com.transsion.appupdate.ui.main.AppUpdateContract;
import com.transsion.appupdate.ui.main.AppUpdatePresenter;
import com.transsion.appupdate.utils.ButtonUtil;
import com.transsion.appupdate.utils.NetworkUtil;
import com.transsion.appupdate.utils.PhoneUtil;
import com.transsion.appupdate.utils.PrivacyPolicyUtil;
import com.transsion.appupdate.utils.StorageUtils;
import com.transsion.appupdate.utils.TimeUtil;
import com.transsion.appupdate.utils.UpdateConstants;
import com.transsion.common.log.CS;
import com.transsion.commonlib.util.SpUtil;
import com.transsion.core.utils.ToastUtil;
import com.transsion.transsion_gdpr.GdprUtil;
import com.transsion.widgetslibs.dialog.PromptDialog;
import java.util.ArrayList;

public class AppUpdateActivity
extends Activity
implements AppUpdateContract.View {
    public static final String INTENT_PARAM_ENTER_TYPE = "enterType";
    public static final String INTENT_PARAM_ENTER_TYPE_NOTIFICATION = "notification";
    public static final String INTENT_PARAM_NOTIFICATION_APK_TYPE = "notificationApkType";
    private LinearLayout mContainerView;
    private View mLoadingView;
    private View mBlankView;
    private RecyclerView mRecyclerView;
    private TextView mTextBlank;
    private ImageView mImgBlank;
    private ImageButton mBtnOverflow;
    private PopupMenu mPopupMenu;
    private AppUpdateAdapter mAdapter;
    private AppUpdateContract.Presenter mPresenter;
    private PromptDialog mPrivacyPolicyDialog;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        PhoneUtil.setStatusBarAndNavigation(this, false);
        super.onCreate(savedInstanceState);
        this.checkLeftStorage();
        this.setContentView(R.layout.activity_app_update);
        this.initView();
        this.initData();
        this.checkPrivacyPolicy();
        this.recordEnterTime();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.checkPrivacyPolicy();
    }

    private void checkLeftStorage() {
        if (StorageUtils.isLessThanUsagePercent(5L)) {
            CS.log.d("TMS_APP", "checkLeftStorage() -> lack of space");
            Toast.makeText((Context)this, (int)R.string.lack_space, (int)1).show();
            this.finish();
        }
    }

    private void setLightNavBar() {
        if (Build.VERSION.SDK_INT >= 26) {
            this.getWindow().getDecorView().setSystemUiVisibility(this.getWindow().getDecorView().getSystemUiVisibility() | 0x10);
        }
    }

    private void initView() {
        this.initToolbar();
        this.mContainerView = (LinearLayout)this.findViewById(R.id.linear_container);
        this.mLoadingView = this.findViewById(R.id.frame_loading);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.recycler_list);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
    }

    private void initToolbar() {
        TextView textTitle = (TextView)this.findViewById(R.id.text_title);
        textTitle.setSingleLine(true);
        textTitle.setEllipsize(TextUtils.TruncateAt.END);
        textTitle.setText(R.string.app_name);
        this.findViewById(R.id.btn_back).setOnClickListener(v -> this.finish());
        this.mBtnOverflow = (ImageButton)this.findViewById(R.id.btn_overflow);
        this.mBtnOverflow.setOnClickListener(v -> this.popupMenu());
    }

    private void initData() {
        this.mPresenter = new AppUpdatePresenter(this);
        this.mPresenter.loadData();
        Intent intent = this.getIntent();
        if (intent != null) {
            String enterType = intent.getStringExtra(INTENT_PARAM_ENTER_TYPE);
            if (TextUtils.equals((CharSequence)enterType, (CharSequence)INTENT_PARAM_ENTER_TYPE_NOTIFICATION)) {
                int notificationApkType = intent.getIntExtra(INTENT_PARAM_NOTIFICATION_APK_TYPE, -1);
                if (notificationApkType == 5) {
                    this.mPresenter.trackNewPhoneRecommendNotification(notificationApkType);
                } else {
                    this.mPresenter.trackAppListEvent(Tracker.TID.TMS_NOTIFICATION_ENTER, null);
                }
            } else {
                this.mPresenter.trackAppListEvent(Tracker.TID.TMS_SETTING_ENTER, null);
            }
        }
    }

    private void checkPrivacyPolicy() {
        if (!PrivacyPolicyUtil.isUserPrivacyPolicyAgreed()) {
            this.showOSPrivacyPolicyDialog();
        }
    }

    private void showPrivacyPolicyDialog() {
        if (this.mPrivacyPolicyDialog == null) {
            this.mPrivacyPolicyDialog = new PromptDialog.Builder((Context)this).setView(R.layout.dialog_privacy_policy).create();
            this.mPrivacyPolicyDialog.show();
            Window dialogWindow = this.mPrivacyPolicyDialog.getWindow();
            if (dialogWindow != null) {
                TextView tvContent;
                View ivClose;
                View btnAccept = dialogWindow.findViewById(R.id.btn_privacy_policy_accept);
                if (btnAccept != null) {
                    btnAccept.setOnClickListener(v -> {
                        PrivacyPolicyUtil.userAgreePrivacyPolicy();
                        if (this.mPrivacyPolicyDialog != null) {
                            this.mPrivacyPolicyDialog.dismiss();
                        }
                        CS.log.d("TMS_APP", "dialog press accept");
                    });
                }
                if ((ivClose = dialogWindow.findViewById(R.id.iv_privacy_policy_close)) != null) {
                    ivClose.setOnClickListener(v -> {
                        if (this.mPrivacyPolicyDialog != null) {
                            this.mPrivacyPolicyDialog.dismiss();
                        }
                    });
                }
                if ((tvContent = (TextView)dialogWindow.findViewById(R.id.tv_privacy_policy_content)) != null) {
                    tvContent.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.dialog_privacy_policy_content)));
                    tvContent.setMovementMethod(LinkMovementMethod.getInstance());
                }
            }
        } else {
            this.mPrivacyPolicyDialog.show();
        }
    }

    private void showOSPrivacyPolicyDialog() {
        GdprUtil.wantToShowGdpr((FragmentManager)this.getFragmentManager(), (GdprUtil.DialogCallback)new GdprUtil.DialogCallback(){

            public void onNegativeCallback() {
                CS.log.d("TMS_APP", "showOSPrivacyPolicyDialog() -> cancel");
            }

            public void onPossitiveCallback() {
                PrivacyPolicyUtil.userAgreePrivacyPolicy();
                CS.log.d("TMS_APP", "showOSPrivacyPolicyDialog() -> accept");
            }
        });
    }

    private void recordEnterTime() {
        SpUtil.getSP().putLong("LAST_ENTER_APP_UPDATE_TIME", System.currentTimeMillis());
    }

    private void popupMenu() {
        if (this.mPopupMenu == null) {
            this.mPopupMenu = new PopupMenu((Context)this, (View)this.mBtnOverflow, 0, 0, R.style.PopupMenuStyle);
            this.mPopupMenu.inflate(R.menu.menu);
            this.mPopupMenu.setOnMenuItemClickListener(item -> {
                if (item.getItemId() == R.id.menu_edit) {
                    this.mPresenter.pauseAll();
                    this.startActivityForResult(new Intent((Context)this, AppEditActivity.class), 161);
                    this.mPresenter.trackAppListEvent(Tracker.TID.TMS_APP_LIST_CLICK_EDIT, null);
                    return true;
                }
                return false;
            });
        }
        if (this.mPresenter.isEditable()) {
            this.mPopupMenu.getMenu().findItem(R.id.menu_edit).setEnabled(true);
            ForegroundColorSpan span = new ForegroundColorSpan(ContextCompat.getColor((Context)this, (int)R.color.menu_text_color_enable));
            SpannableString spannableString = new SpannableString((CharSequence)this.getResources().getString(R.string.menu_edit));
            spannableString.setSpan((Object)span, 0, spannableString.length(), 33);
            this.mPopupMenu.getMenu().findItem(R.id.menu_edit).setTitle((CharSequence)spannableString);
        } else {
            this.mPopupMenu.getMenu().findItem(R.id.menu_edit).setEnabled(false);
            ForegroundColorSpan span = new ForegroundColorSpan(ContextCompat.getColor((Context)this, (int)R.color.menu_text_color_grey));
            SpannableString spannableString = new SpannableString((CharSequence)this.getResources().getString(R.string.menu_edit));
            spannableString.setSpan((Object)span, 0, spannableString.length(), 33);
            this.mPopupMenu.getMenu().findItem(R.id.menu_edit).setTitle((CharSequence)spannableString);
        }
        this.mPopupMenu.show();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 161) {
            this.mPresenter.loadData();
        }
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public void showLoadingView() {
        if (this.mLoadingView.getVisibility() == 8) {
            this.mLoadingView.setVisibility(0);
        }
        if (this.mRecyclerView != null) {
            this.mRecyclerView.setVisibility(8);
        }
        if (this.mBlankView != null) {
            this.mBlankView.setVisibility(8);
        }
        this.mBtnOverflow.setEnabled(false);
    }

    @Override
    public void showBlankView(boolean isError) {
        this.mBtnOverflow.setEnabled(true);
        if (this.mLoadingView.getVisibility() == 0) {
            this.mLoadingView.setVisibility(8);
        }
        if (this.mRecyclerView.getVisibility() == 0) {
            this.mRecyclerView.setVisibility(8);
        }
        if (this.mBlankView == null) {
            this.mBlankView = this.getLayoutInflater().inflate(R.layout.blank_view_layout, (ViewGroup)this.mContainerView, false);
            this.mContainerView.addView(this.mBlankView);
            this.mTextBlank = (TextView)this.findViewById(R.id.text_blank);
            this.mImgBlank = (ImageView)this.findViewById(R.id.img_blank);
        } else {
            this.mBlankView.setVisibility(0);
        }
        if (isError) {
            if (StorageUtils.isExternalStorageMounted() && StorageUtils.getUsagePercent() < 10L) {
                this.mTextBlank.setText(R.string.lack_space);
                this.mImgBlank.setImageResource(R.drawable.ic_no_storage_vector);
            } else {
                this.mTextBlank.setText(R.string.network_error);
                this.mImgBlank.setImageResource(R.drawable.ic_no_network_vector);
            }
        } else if (NetworkUtil.isConnected(this.getApplicationContext())) {
            this.mTextBlank.setText(R.string.no_update);
            this.mImgBlank.setImageResource(R.drawable.ic_no_update_vector);
        } else {
            this.mTextBlank.setText(R.string.no_network);
            this.mImgBlank.setImageResource(R.drawable.ic_no_network_vector);
        }
    }

    @Override
    public void showListView(ArrayList<ListItem> list) {
        this.mBtnOverflow.setEnabled(true);
        if (this.mLoadingView.getVisibility() == 0) {
            this.mLoadingView.setVisibility(8);
        }
        if (this.mBlankView != null && this.mBlankView.getVisibility() == 0) {
            this.mBlankView.setVisibility(8);
        }
        this.mRecyclerView.setVisibility(0);
        if (this.mAdapter == null) {
            this.mAdapter = new AppUpdateAdapter(list, this.getLayoutInflater(), this::itemDownloadClick, isUpdate -> this.updateAllAfterCheckNet());
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        } else {
            this.mAdapter.updateList(list);
        }
    }

    private void itemDownloadClick(int pos, AppItem item) {
        if (ButtonUtil.isFastDoubleClick()) {
            return;
        }
        if (NetworkUtil.isConnected(this.getApplicationContext())) {
            if (UpdateConstants.STATE_INITIAL.equals(item.state) || UpdateConstants.STATE_PAUSED.equals(item.state) || UpdateConstants.STATE_FAILED.equals(item.state)) {
                this.trackAppListDLTaskBtnClickEvent(Tracker.TID.TMS_APP_LIST_CLICK_DOWNLOAD, item, 1);
                if (NetworkUtil.isMobileData(this.getApplicationContext())) {
                    this.showAlertMobileDialogByItem(() -> {
                        if (TimeUtil.isToday()) {
                            this.trackTrafficRemindClick(item, 0);
                        } else {
                            this.trackTrafficRemindClick(item, 1);
                        }
                        this.mPresenter.requestDownload(item);
                    }, item);
                } else {
                    this.trackTrafficRemindShow(item, 1);
                    this.mPresenter.requestDownload(item);
                }
            } else {
                this.trackAppListDLTaskBtnClickEvent(Tracker.TID.TMS_APP_LIST_CLICK_DOWNLOAD, item, 2);
                this.mPresenter.requestDownload(item);
            }
        } else {
            ToastUtil.showToast((int)R.string.no_network);
        }
    }

    private void updateAllAfterCheckNet() {
        if (ButtonUtil.isFastDoubleClick()) {
            return;
        }
        if (NetworkUtil.isConnected(this.getApplicationContext())) {
            if (NetworkUtil.isMobileData(this.getApplicationContext())) {
                if (this.mPresenter.canUpdateAll()) {
                    this.showAlertMobileDialog(() -> this.mPresenter.requestAllDownload());
                }
            } else {
                this.mPresenter.requestAllDownload();
            }
        } else {
            ToastUtil.showToast((int)R.string.no_network);
        }
    }

    private void showAlertMobileDialog(AlertMobileFragment.OnPositiveBtnListener listener) {
        if (TimeUtil.isToday()) {
            if (listener != null) {
                listener.onOnPositiveBtnClick();
            }
        } else {
            AlertMobileFragment amf = new AlertMobileFragment();
            amf.setOnPositiveBtnListener(listener);
            amf.show(this.getFragmentManager(), "AlertMobileFragment");
        }
    }

    private void showAlertMobileDialogByItem(AlertMobileFragment.OnPositiveBtnListener listener, AppItem appItem) {
        if (TimeUtil.isToday()) {
            this.trackTrafficRemindShow(appItem, 3);
            if (listener != null) {
                listener.onOnPositiveBtnClick();
            }
        } else {
            this.trackTrafficRemindShow(appItem, 0);
            AlertMobileFragment amf = new AlertMobileFragment();
            amf.setOnPositiveBtnListener(listener);
            amf.setOnNegativeBtnListener(() -> this.trackTrafficRemindClick(appItem, 2));
            amf.setOnCancelListener(() -> this.trackTrafficRemindClick(appItem, 2));
            amf.show(this.getFragmentManager(), "AlertMobileFragment");
        }
    }

    private void trackTrafficRemindShow(AppItem item, int showState) {
        TrafficDialogShowData data = new TrafficDialogShowData();
        data.setAppId(item.appId);
        data.setMediaPkgName(item.mediaPkgName);
        data.setCreativeId(item.creativeID);
        data.setPage(0);
        data.setShowState(showState);
        Tracker.track(Tracker.TID.TMS_TRAFFIC_REMIND_SHOW, data.getBundle());
    }

    private void trackTrafficRemindClick(AppItem item, int clickState) {
        TrafficDialogClickData data = new TrafficDialogClickData();
        data.setAppId(item.appId);
        data.setMediaPkgName(item.mediaPkgName);
        data.setCreativeId(item.creativeID);
        data.setPage(0);
        data.setClickState(clickState);
        Tracker.track(Tracker.TID.TMS_TRAFFIC_REMIND_CLICK, data.getBundle());
    }

    private void trackAppListDLTaskBtnClickEvent(Tracker.TID tid, AppItem item, int downloadStatus) {
        if (tid != null && item != null) {
            UserActionDLTaskData data = new UserActionDLTaskData();
            data.setAppId(item.appId);
            data.setAppVersion(item.appVersionCode);
            data.setMediaPkgName(item.mediaPkgName);
            data.setCreativeId(item.creativeID);
            data.setDownloadStatus(downloadStatus);
            Tracker.track(tid, data.getBundle());
        }
    }

    @Override
    public void notifyItemChanged(int position, int type) {
        this.mAdapter.notifyItemChanged(position, type);
    }

    @Override
    public void updateList(ArrayList<ListItem> list) {
        this.mAdapter.updateList(list);
    }

    protected void onDestroy() {
        this.mPresenter.onDestroy();
        super.onDestroy();
        if (this.mPrivacyPolicyDialog != null) {
            this.mPrivacyPolicyDialog.dismiss();
            this.mPrivacyPolicyDialog = null;
        }
        StorageUtils.fixInputMethodManagerLeak((Context)this);
    }
}

