/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.ui.main;

import android.app.Activity;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.transsion.appupdate.R;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.reportBean.UserActionData;
import com.transsion.appupdate.utils.ContantUtil;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.ScreenUtil;
import java.util.Arrays;
import java.util.List;

public class SelfWebViewActivity
extends Activity
implements View.OnClickListener {
    public static final String INTENT_PARAM_CREATIVE_ID = "cid";
    public static final String INTENT_PARAM_CREATIVE_VERSION = "cv";
    private WebView webView;
    private ProgressBar bar;
    private boolean isRedirected = false;
    private ImageView more;
    private String[] datas = new String[]{"Open in Chrome", "Share Link"};
    private TextView tvTitle;
    private TextView tvUrl;
    private View line;
    private ClipboardManager clipboard = null;
    private static final String DEFAULT_BROWSER_PACKAGE = "com.android.chrome";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.tad_exposure_activity);
        this.initView();
        this.initWebView();
        this.trackEvent();
    }

    private void trackEvent() {
        Intent intent = this.getIntent();
        if (intent != null) {
            int cid = intent.getIntExtra(INTENT_PARAM_CREATIVE_ID, 0);
            long cv = intent.getLongExtra(INTENT_PARAM_CREATIVE_VERSION, 0L);
            UserActionData data = new UserActionData();
            data.setCreativeId(cid);
            data.setCreativeVersion(cv);
            Tracker.track(Tracker.TID.TMS_OPEN_WEBVIEW, data.getBundle());
        }
    }

    private void initView() {
        ImageView refresh = (ImageView)this.findViewById(R.id.ib_refresh);
        ImageView close = (ImageView)this.findViewById(R.id.ib_close);
        this.more = (ImageView)this.findViewById(R.id.ib_more);
        this.bar = (ProgressBar)this.findViewById(R.id.pb_progress);
        this.tvTitle = (TextView)this.findViewById(R.id.tv_title);
        this.tvUrl = (TextView)this.findViewById(R.id.tv_url);
        this.line = this.findViewById(R.id.vw_line);
        refresh.setOnClickListener((View.OnClickListener)this);
        close.setOnClickListener((View.OnClickListener)this);
        this.more.setOnClickListener((View.OnClickListener)this);
    }

    private void initWebView() {
        String url = this.getIntent().getStringExtra("url");
        this.webView = (WebView)this.findViewById(R.id.wv_webview);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setUseWideViewPort(true);
        this.webView.getSettings().setLoadWithOverviewMode(true);
        this.webView.getSettings().setDisplayZoomControls(true);
        this.webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                if (newProgress == 100) {
                    SelfWebViewActivity.this.bar.setVisibility(8);
                } else {
                    if (8 == SelfWebViewActivity.this.bar.getVisibility()) {
                        SelfWebViewActivity.this.bar.setVisibility(0);
                    }
                    SelfWebViewActivity.this.bar.setProgress(newProgress);
                }
            }
        });
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return SelfWebViewActivity.this.goToNext(view, url);
            }

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                if (Build.VERSION.SDK_INT >= 21 && request != null && !TextUtils.isEmpty((CharSequence)request.getUrl().toString())) {
                    return SelfWebViewActivity.this.goToNext(view, request.getUrl().toString());
                }
                return true;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (!SelfWebViewActivity.this.isRedirected) {
                    String title;
                    if (SelfWebViewActivity.this.bar != null && SelfWebViewActivity.this.bar.getVisibility() != 8) {
                        SelfWebViewActivity.this.bar.setVisibility(8);
                    }
                    if (!TextUtils.isEmpty((CharSequence)(title = view.getTitle()))) {
                        SelfWebViewActivity.this.tvTitle.setText((CharSequence)title);
                    }
                    if (!TextUtils.isEmpty((CharSequence)view.getUrl())) {
                        SelfWebViewActivity.this.tvUrl.setText((CharSequence)view.getUrl());
                    }
                }
                SelfWebViewActivity.this.isRedirected = false;
            }

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                handler.proceed();
                super.onReceivedSslError(view, handler, error);
            }
        });
        this.webView.loadUrl(url);
        if (this.webView != null && this.tvTitle != null && this.tvUrl != null) {
            if (!TextUtils.isEmpty((CharSequence)this.webView.getTitle())) {
                this.tvTitle.setText((CharSequence)this.webView.getTitle());
            } else {
                this.tvTitle.setText((CharSequence)this.webView.getUrl());
            }
            this.tvUrl.setText((CharSequence)this.webView.getUrl());
        }
    }

    public boolean goToNext(WebView view, String url) {
        block7: {
            if (url != null && !url.startsWith("http:") && !url.startsWith("https:")) {
                try {
                    if (url.startsWith("intent://")) {
                        List resolves;
                        Intent intent = Intent.parseUri((String)url, (int)1);
                        intent.addCategory("android.intent.category.BROWSABLE");
                        intent.setFlags(0x10000000);
                        intent.setComponent(null);
                        if (Build.VERSION.SDK_INT >= 15) {
                            intent.setSelector(null);
                        }
                        if ((resolves = CoreUtil.getContext().getPackageManager().queryIntentActivities(intent, 0)).size() > 0) {
                            CoreUtil.getContext().startActivity(intent);
                        }
                        break block7;
                    }
                    Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                    intent.setFlags(0x30000000);
                    this.startActivity(intent);
                }
                catch (Exception exception) {}
            } else {
                view.loadUrl(url);
            }
        }
        return true;
    }

    protected void onDestroy() {
        if (this.webView != null) {
            this.webView.destroy();
        }
        super.onDestroy();
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.ib_refresh) {
            this.bar.setVisibility(0);
            this.webView.reload();
        }
        if (i == R.id.ib_close) {
            this.finish();
        } else if (i == R.id.ib_more) {
            View popupView = this.getLayoutInflater().inflate(R.layout.popup_window, null);
            ListView lsvMore = (ListView)popupView.findViewById(R.id.lsvMore);
            lsvMore.setAdapter((ListAdapter)new MyAdapter((Context)this, Arrays.asList(this.datas)));
            lsvMore.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    switch (position) {
                        case 0: {
                            if (SelfWebViewActivity.this.webView == null || TextUtils.isEmpty((CharSequence)SelfWebViewActivity.this.webView.getUrl())) break;
                            Intent intent = ContantUtil.createIntent(SelfWebViewActivity.this.getApplicationContext(), null, SelfWebViewActivity.this.webView.getUrl(), SelfWebViewActivity.DEFAULT_BROWSER_PACKAGE, SelfWebViewActivity.class);
                            SelfWebViewActivity.this.startActivity(intent);
                            break;
                        }
                        case 1: {
                            if (SelfWebViewActivity.this.webView == null || TextUtils.isEmpty((CharSequence)SelfWebViewActivity.this.webView.getUrl())) break;
                            Intent intent = new Intent("android.intent.action.SEND");
                            intent.setType("text/plain");
                            intent.setFlags(0x10000000);
                            intent.putExtra("android.intent.extra.TEXT", SelfWebViewActivity.this.webView.getUrl());
                            SelfWebViewActivity.this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Share link"));
                            break;
                        }
                    }
                }
            });
            PopupWindow window = new PopupWindow(popupView, ScreenUtil.dip2px((float)160.0f), -2);
            window.setAnimationStyle(R.style.popup_window_anim);
            window.setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)"#F8F8F8")));
            window.setFocusable(true);
            window.setOutsideTouchable(true);
            window.update();
            window.showAsDropDown(this.line, ScreenUtil.getWinWidth() - ScreenUtil.dip2px((float)160.0f), 0);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.webView != null && this.webView.canGoBack()) {
            this.webView.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public class MyAdapter
    extends BaseAdapter {
        private LayoutInflater inflater;
        private List<String> testData;

        public MyAdapter(Context context, List<String> testData) {
            this.testData = testData;
            this.inflater = LayoutInflater.from((Context)context);
        }

        public int getCount() {
            return this.testData.size();
        }

        public Object getItem(int position) {
            return this.testData.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder = null;
            if (convertView == null) {
                holder = new ViewHolder();
                convertView = this.inflater.inflate(R.layout.popup_window_item, null);
                holder.text = (TextView)convertView.findViewById(R.id.tv_content);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            holder.text.setText((CharSequence)this.testData.get(position));
            return convertView;
        }

        private class ViewHolder {
            TextView text;

            private ViewHolder() {
            }
        }
    }
}

