/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ResolveInfo;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.view.accessibility.AccessibilityManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Deprecated
public class AccessibilityUtil {
    public static final String FLOAT_SCREEN_SERVICE = "com.android.core.internal/com.android.core.coo.CooService";
    private static final char ENABLED_ACCESSIBILITY_SERVICES_SEPARATOR = ':';
    static final TextUtils.SimpleStringSplitter sStringColonSplitter = new TextUtils.SimpleStringSplitter(':');
    private static final Set<ComponentName> sInstalledServices = new HashSet<ComponentName>();

    private static Set<ComponentName> getEnabledServicesFromSettings(Context context) {
        String enabledServicesSetting = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"enabled_accessibility_services");
        if (enabledServicesSetting == null) {
            return Collections.emptySet();
        }
        HashSet<ComponentName> enabledServices = new HashSet<ComponentName>();
        TextUtils.SimpleStringSplitter colonSplitter = sStringColonSplitter;
        colonSplitter.setString(enabledServicesSetting);
        while (colonSplitter.hasNext()) {
            String componentNameString = colonSplitter.next();
            ComponentName enabledService = ComponentName.unflattenFromString((String)componentNameString);
            if (enabledService == null) continue;
            enabledServices.add(enabledService);
        }
        return enabledServices;
    }

    private static void loadInstalledServices(Context context) {
        Set<ComponentName> installedServices = sInstalledServices;
        installedServices.clear();
        AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        List installedServiceInfos = accessibilityManager.getInstalledAccessibilityServiceList();
        if (installedServiceInfos == null) {
            return;
        }
        int installedServiceInfoCount = installedServiceInfos.size();
        for (int i = 0; i < installedServiceInfoCount; ++i) {
            ResolveInfo resolveInfo = ((AccessibilityServiceInfo)installedServiceInfos.get(i)).getResolveInfo();
            ComponentName installedService = new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name);
            installedServices.add(installedService);
        }
    }

    private static void updateAccessibility(Context context, boolean enabled, String preferenceKey) {
        if (TextUtils.isEmpty((CharSequence)preferenceKey)) {
            return;
        }
        Set<ComponentName> enabledServices = AccessibilityUtil.getEnabledServicesFromSettings(context);
        if (enabledServices == Collections.emptySet()) {
            enabledServices = new HashSet<ComponentName>();
        }
        ComponentName toggledService = ComponentName.unflattenFromString((String)preferenceKey);
        boolean accessibilityEnabled = false;
        if (enabled) {
            enabledServices.add(toggledService);
            accessibilityEnabled = true;
        } else {
            enabledServices.remove(toggledService);
            Set<ComponentName> installedServices = sInstalledServices;
            for (ComponentName enabledService : enabledServices) {
                if (!installedServices.contains(enabledService)) continue;
                accessibilityEnabled = true;
                break;
            }
        }
        StringBuilder enabledServicesBuilder = new StringBuilder();
        for (ComponentName enabledService : enabledServices) {
            enabledServicesBuilder.append(enabledService.flattenToString());
            enabledServicesBuilder.append(':');
        }
        int enabledServicesBuilderLength = enabledServicesBuilder.length();
        if (enabledServicesBuilderLength > 0) {
            enabledServicesBuilder.deleteCharAt(enabledServicesBuilderLength - 1);
        }
        Settings.Secure.putString((ContentResolver)context.getContentResolver(), (String)"enabled_accessibility_services", (String)enabledServicesBuilder.toString());
        Settings.Secure.putInt((ContentResolver)context.getContentResolver(), (String)"accessibility_enabled", (int)(accessibilityEnabled ? 1 : 0));
    }

    public static void setAccessibility(Context context, String serviceName) {
        if (!AccessibilityUtil.isAccessibilitySettingsOn(context)) {
            AccessibilityUtil.setAccessibility(context, true, serviceName);
        }
    }

    public static void setAccessibility(Context context, boolean enabled, String serviceName) {
        AccessibilityUtil.loadInstalledServices(context);
        AccessibilityUtil.updateAccessibility(context, enabled, serviceName);
    }

    public static boolean isAccessibilitySettingsOn(Context context) {
        String services;
        int accessibilityEnabled = 0;
        try {
            accessibilityEnabled = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"accessibility_enabled");
        }
        catch (Settings.SettingNotFoundException e) {
            Log.d((String)"book", (String)e.getMessage());
        }
        if (accessibilityEnabled == 1 && (services = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"enabled_accessibility_services")) != null) {
            return services.toLowerCase().contains(context.getPackageName().toLowerCase());
        }
        return false;
    }
}

