/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.transsion.appupdate.service.CoreService;
import com.transsion.appupdate.service.ICoreAidl;
import com.transsion.core.CoreUtil;
import java.util.ArrayList;
import java.util.List;

public class CoreServiceTools {
    private static CoreServiceTools sInstance = null;
    private ICoreAidl mCoreAidl = null;
    private List<ICoreOpenCallback> mOpenCallbackList = new ArrayList<ICoreOpenCallback>();
    private ServiceConnection mConn = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            CoreServiceTools.this.mCoreAidl = ICoreAidl.Stub.asInterface(service);
            for (ICoreOpenCallback callback : CoreServiceTools.this.mOpenCallbackList) {
                callback.onSuccess();
            }
            CoreServiceTools.this.mOpenCallbackList.clear();
        }

        public void onServiceDisconnected(ComponentName name) {
            CoreServiceTools.this.mCoreAidl = null;
        }
    };

    private CoreServiceTools() {
    }

    public static CoreServiceTools getTools() {
        if (sInstance == null) {
            sInstance = new CoreServiceTools();
        }
        return sInstance;
    }

    public void open() {
        Context context = CoreUtil.getContext();
        Intent intent = new Intent(context, CoreService.class);
        context.bindService(intent, this.mConn, 1);
    }

    public void close() {
        Context context = CoreUtil.getContext();
        context.unbindService(this.mConn);
    }

    public boolean isBind() {
        return this.mCoreAidl != null && this.mCoreAidl.asBinder() != null && this.mCoreAidl.asBinder().isBinderAlive();
    }

    public ICoreAidl getCoreAidl() {
        return this.mCoreAidl;
    }

    public void addOpenCallback(ICoreOpenCallback callback) {
        this.mOpenCallbackList.add(callback);
    }

    public static interface ICoreOpenCallback {
        public void onSuccess();

        public void onFailed();
    }
}

