/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.text.TextUtils;
import com.transsion.commonlib.util.SpUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    public static boolean isSameDay(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        String lastTime = SpUtil.getSP().getString(key + "stormui_same_day", "2018-10-01");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String todayTime = df.format(new Date());
        if (todayTime.equals(lastTime)) {
            return true;
        }
        SpUtil.getSP().putString(key + "stormui_same_day", todayTime);
        return false;
    }

    public static boolean isInvalidTime(String startTime, String endTime) {
        boolean isInvalid = false;
        if (!TextUtils.isEmpty((CharSequence)startTime) && !TextUtils.isEmpty((CharSequence)endTime)) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
                String currentTine = dateFormat.format(new Date(System.currentTimeMillis()));
                Date currentData = dateFormat.parse(currentTine);
                Date startData = dateFormat.parse(startTime);
                Date endData = dateFormat.parse(endTime);
                if (startData.before(endData)) {
                    if (currentData.after(startData) && currentData.before(endData)) {
                        isInvalid = true;
                    }
                } else if (currentData.after(endData) && currentData.after(startData) || currentData.before(endData) && currentData.before(startData)) {
                    isInvalid = true;
                }
            }
            catch (Exception e) {
                isInvalid = false;
            }
        }
        return isInvalid;
    }

    public static boolean isInvalidTime(String time) {
        boolean isInvalid = false;
        if (!TextUtils.isEmpty((CharSequence)time) && time.contains("-")) {
            String[] dds = time.split("-");
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
            Date curDate = new Date(System.currentTimeMillis());
            String current = dateFormat.format(curDate);
            Date currentData = null;
            Date startData = null;
            Date endData = null;
            try {
                currentData = dateFormat.parse(current);
                startData = dateFormat.parse(dds[0]);
                endData = dateFormat.parse(dds[1]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (startData != null && endData != null && currentData.after(startData) && currentData.before(endData)) {
                isInvalid = true;
            }
        }
        return isInvalid;
    }

    public static String getToday() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String todayTime = df.format(new Date());
        return todayTime;
    }

    public static String getCurrentTime() {
        TimeZone timeZone = TimeZone.getDefault();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(timeZone);
        String time = sdf.format(new Date());
        return time;
    }
}

