/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import com.transsion.appupdate.reportBean.RecordStateData;
import com.transsion.appupdate.utils.SecurityUtil;
import com.transsion.common.log.CS;
import com.transsion.http.util.MD5;
import com.transsion.json.Tson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtil {
    public static final String STOP_FILE_NAME = MD5.MD5Encode((String)"stop");
    public static final String DEFAULT_FILE_PATH = "/Android/.qssland/";

    public static void saveFile(String filename, String msg) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            FileUtil.deleteFile(filename);
        } else {
            try {
                File file = new File(filename);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileOutputStream outStream = new FileOutputStream(file);
                outStream.write(msg.getBytes());
                outStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveStop() {
        String fileName = FileUtil.getSdCard() + DEFAULT_FILE_PATH + STOP_FILE_NAME;
        CS.log.d("file", "fileName:" + fileName);
        FileUtil.saveFile(fileName, "test");
    }

    public static void deleteStop() {
        String fileName = FileUtil.getSdCard() + DEFAULT_FILE_PATH + STOP_FILE_NAME;
        FileUtil.deleteFile(fileName);
    }

    public static boolean deleteFile(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return false;
    }

    public static String getSdCard() {
        String sdDir = null;
        boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
        if (sdCardExist) {
            sdDir = Environment.getExternalStorageDirectory().getPath();
        }
        return sdDir;
    }

    public static boolean isMD5Fit(File file, String serverMD5) {
        String fileMd5 = SecurityUtil.getFileMD5Self(file);
        if (!TextUtils.isEmpty((CharSequence)fileMd5) && serverMD5 != null) {
            return fileMd5.equalsIgnoreCase(serverMD5);
        }
        return false;
    }

    public static String createApkDownloadPath(Context context, String apkUrl) {
        File dir = new File(context.getFilesDir(), "download");
        String fileName = apkUrl.substring(apkUrl.lastIndexOf("/") + 1);
        return new File(dir, fileName).getPath();
    }

    public static String createImgDownloadPath(Context context, String imgUrl) {
        File dir = new File(context.getFilesDir(), "download");
        String fileName = imgUrl.substring(imgUrl.lastIndexOf("/") + 1);
        return new File(dir, fileName).getPath();
    }

    public static void saveRecordStateData(Context context, RecordStateData recordStateData) {
        String stateStr;
        if (recordStateData != null && !TextUtils.isEmpty((CharSequence)(stateStr = Tson.toJson((Object)recordStateData)))) {
            FileUtil.saveRecordData("state", stateStr, context);
        }
    }

    public static RecordStateData readRecordStateData(Context context) {
        RecordStateData data = null;
        String stateStr = FileUtil.readRecordData("state", context);
        try {
            if (!TextUtils.isEmpty((CharSequence)stateStr)) {
                data = (RecordStateData)Tson.fromJson((String)stateStr, RecordStateData.class);
            }
        }
        catch (Exception e) {
            CS.log.e("TMS_COMMON", e.getMessage());
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveRecordData(String filename, String msg, Context context) {
        if (TextUtils.isEmpty((CharSequence)filename) || TextUtils.isEmpty((CharSequence)msg) || context == null) {
            return;
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(new File(context.getFilesDir(), filename));
            outStream.write(msg.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                outStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readRecordData(String filename, Context context) {
        if (TextUtils.isEmpty((CharSequence)filename) || context == null) {
            return null;
        }
        File file = new File(context.getFilesDir(), filename);
        if (!file.exists()) {
            return null;
        }
        FileInputStream inputStream = null;
        try {
            String rst;
            inputStream = new FileInputStream(file);
            int length = inputStream.available();
            byte[] buffer = new byte[length];
            inputStream.read(buffer);
            String string2 = rst = new String(buffer);
            return string2;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string3 = null;
            return string3;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

