/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.content.Context;
import android.os.SystemProperties;
import android.text.TextUtils;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.reportBean.RecordStateData;
import com.transsion.appupdate.utils.FileUtil;
import com.transsion.common.log.CS;
import com.transsion.commonlib.config.CSLib;
import com.transsion.core.CoreUtil;
import com.transsion.newphonerecommend.NewPhoneRecommendManager;

public class PrivacyPolicyUtil {
    public static boolean isPrivacyPolicyAgreed() {
        boolean isAgreed = false;
        if (!PrivacyPolicyUtil.isUserPrivacyPolicyAgreed()) {
            RecordStateData recordStateData = FileUtil.readRecordStateData(CoreUtil.getContext());
            long effectiveTime = 8640000000L;
            if (recordStateData != null && recordStateData.getInvalidInterval() > 0) {
                CS.log.d("TMS_COMMON", "privacy policy invalid = " + recordStateData.getInvalidInterval());
                effectiveTime = (long)(recordStateData.getInvalidInterval() * 24 * 60 * 60) * 1000L;
            }
            long privacyPolicyInitTime = 0L;
            if (recordStateData != null && recordStateData.getInitTime() > 0L) {
                privacyPolicyInitTime = recordStateData.getInitTime();
            }
            if (privacyPolicyInitTime <= 0L || System.currentTimeMillis() - privacyPolicyInitTime < effectiveTime) {
                CS.log.d("TMS_COMMON", "all privacy policy disagreed");
            } else {
                CS.log.d("TMS_COMMON", "privacy policy not effective");
                isAgreed = true;
            }
        } else {
            isAgreed = true;
        }
        return isAgreed;
    }

    public static boolean isUserPrivacyPolicyAgreed() {
        boolean isAgreed = false;
        if (!CSLib.GDPR_OPEN) {
            return true;
        }
        String sysUserExperience = SystemProperties.get((String)"persist.sys.user_experience");
        if (TextUtils.equals((CharSequence)sysUserExperience, (CharSequence)"true")) {
            CS.log.d("TMS_COMMON", "settings privacy policy agreed");
            isAgreed = true;
        } else {
            RecordStateData recordStateData = FileUtil.readRecordStateData(CoreUtil.getContext());
            if (recordStateData != null && recordStateData.isUserAgreed()) {
                CS.log.d("TMS_COMMON", "app update privacy policy agreed");
                isAgreed = true;
            }
        }
        return isAgreed;
    }

    public static void userAgreePrivacyPolicy() {
        RecordStateData recordStateData = FileUtil.readRecordStateData(CoreUtil.getContext());
        if (recordStateData == null) {
            recordStateData = new RecordStateData();
        }
        recordStateData.setUserAgreed(true);
        FileUtil.saveRecordStateData(CoreUtil.getContext(), recordStateData);
    }

    public static void resetReportStateByPrivacyPolicy() {
        if (PrivacyPolicyUtil.isPrivacyPolicyAgreed()) {
            Tracker.enableTrackData();
        } else if (NewPhoneRecommendManager.isNewPhoneRecommendOver((Context)CoreUtil.getContext())) {
            Tracker.disableTrackData();
        }
    }
}

