/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.text.TextUtils;
import com.transsion.commonlib.util.SpUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtil {
    public static String getCurrentDate() {
        TimeZone timeZone = TimeZone.getDefault();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
        sdf.setTimeZone(timeZone);
        String time = sdf.format(new Date());
        return time;
    }

    public static String getCurrentTime() {
        TimeZone timeZone = TimeZone.getDefault();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        sdf.setTimeZone(timeZone);
        String time = sdf.format(new Date());
        return time;
    }

    public static String getTimeByMillis(long timeMillis) {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        return dateformat.format(new Date(timeMillis));
    }

    public static long getTimeInterval(String startTime, String endTime) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        long minutes = 0L;
        if (startTime == null || "".equals(startTime)) {
            startTime = "2000-01-01 00:00:00";
        }
        Date start = df.parse(startTime);
        Date end = df.parse(endTime);
        long diff = Math.abs(end.getTime() - start.getTime());
        long day = diff / 86400000L;
        long hour = diff / 3600000L - day * 24L;
        long min = diff / 60000L - day * 24L * 60L - hour * 60L;
        minutes = day * 24L * 60L + hour * 60L + min;
        return minutes;
    }

    public static boolean isInvalidTime(String time) {
        boolean isInvalid = false;
        if (!TextUtils.isEmpty((CharSequence)time)) {
            String[] dds = time.split("-");
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm", Locale.CHINA);
            Date curDate = new Date(System.currentTimeMillis());
            String current = dateFormat.format(curDate);
            Date currentData = null;
            Date startData = null;
            Date endData = null;
            try {
                currentData = dateFormat.parse(current);
                startData = dateFormat.parse(dds[0]);
                endData = dateFormat.parse(dds[1]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (startData != null && endData != null && currentData.after(startData) && currentData.before(endData)) {
                isInvalid = true;
            }
        }
        return isInvalid;
    }

    public static boolean isToday() {
        long timeMillis = SpUtil.getSP().getLong("time_millis", 0L);
        Calendar oldCalendar = Calendar.getInstance();
        oldCalendar.setTimeInMillis(timeMillis);
        Calendar newCalendar = Calendar.getInstance();
        return oldCalendar.get(1) == newCalendar.get(1) && oldCalendar.get(2) == newCalendar.get(2) && oldCalendar.get(5) == newCalendar.get(5);
    }
}

