/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.newphonerecommend;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.text.format.DateFormat;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.transsion.core.CoreUtil;
import com.transsion.newphonerecommend.bean.AppDetailInfo;
import com.transsion.newphonerecommend.bean.ConfigInfo;
import com.transsion.newphonerecommend.database.DBManager;
import com.transsion.newphonerecommend.log.CS;
import com.transsion.newphonerecommend.media.NewPhoneRecommendMedia;
import com.transsion.newphonerecommend.report.Tracker;
import com.transsion.newphonerecommend.ui.NewPhoneRecommendActivity;
import com.transsion.newphonerecommend.utils.AppExecutors;
import com.transsion.newphonerecommend.utils.ConfigInfoUtil;
import com.transsion.newphonerecommend.utils.NetworkUtil;
import com.transsion.newphonerecommend.utils.ProcessUtil;
import java.util.List;

public class NewPhoneRecommendManager {
    public static final String JOB_SERVICE_PARAM_KEY_DATA = "recommend_data";

    public static void initialize(boolean isTestMode, boolean debugServer, boolean debugLog) {
        CS.log.d("Recommend", "isTestMode=" + isTestMode + ", debugServer=" + debugServer + ", debugLog=" + debugLog);
        CS.setTestMode(isTestMode);
        CS.setDebugServer(debugServer);
        CS.setDebugLog(debugLog);
        CS.log.d("Recommend", "NewPhoneRecommendOpen=" + CS.NEW_PHONE_RECOMMEND_OPEN);
    }

    public static boolean shouldShowNewPhoneRecommend(Context context) {
        if (!CS.NEW_PHONE_RECOMMEND_OPEN) {
            return false;
        }
        boolean isNetworkConnected = NetworkUtil.isConnected(context);
        boolean isLauncher = ProcessUtil.isLauncher();
        ConfigInfo configInfo = ConfigInfoUtil.loadConfigInfo(context);
        boolean hasRequested = configInfo != null && configInfo.isHasRequested();
        boolean hasShowed = configInfo != null && configInfo.isHasShowed();
        StringBuilder builder = new StringBuilder("isNetworkConnected=");
        builder.append(isNetworkConnected);
        builder.append(", isLauncher=");
        builder.append(isLauncher);
        builder.append(", hasRequested=");
        builder.append(hasRequested);
        builder.append(", hasShowed=");
        builder.append(hasShowed);
        CS.log.d("Recommend", builder.toString());
        return isNetworkConnected && isLauncher && hasRequested && !hasShowed;
    }

    public static boolean isNewPhoneRecommendOver(Context context) {
        if (!CS.NEW_PHONE_RECOMMEND_OPEN) {
            return true;
        }
        ConfigInfo configInfo = ConfigInfoUtil.loadConfigInfo(context);
        if (configInfo == null) {
            CS.log.d("Recommend", "config info is null");
            return false;
        }
        long requestTime = configInfo.getInitTime();
        long activeDays = configInfo.getActiveDays();
        if (requestTime <= 0L || activeDays <= 0L) {
            CS.log.d("Recommend", "requestTime or activeDays abnormal");
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long overTime = requestTime + activeDays * 24L * 60L * 60L * 1000L;
        CS.log.d("Recommend", "currentTime = " + currentTime);
        CS.log.d("Recommend", "initTime = " + requestTime);
        CS.log.d("Recommend", "overTime = " + overTime);
        return currentTime > overTime;
    }

    public static void showNewPhoneRecommend(Context context) {
        if (!CS.NEW_PHONE_RECOMMEND_OPEN) {
            return;
        }
        if (context == null) {
            return;
        }
        ConfigInfo configInfo = ConfigInfoUtil.loadConfigInfo(context);
        if (configInfo == null) {
            configInfo = new ConfigInfo();
        }
        if (configInfo.getShowCount() >= 5) {
            configInfo.setHasRequested(true);
            configInfo.setHasShowed(true);
            ConfigInfoUtil.saveConfigInfo(context, configInfo);
            CS.log.d("Recommend", "NewPhoneRecommend show more than max show count, stop");
            return;
        }
        int showCount = configInfo.getShowCount() + 1;
        configInfo.setShowCount(showCount);
        ConfigInfoUtil.saveConfigInfo(context, configInfo);
        CS.log.d("Recommend", "begin to show NewPhoneRecommend by activity");
        Intent recommendIntent = new Intent(context, NewPhoneRecommendActivity.class);
        recommendIntent.setFlags(0x10000000);
        context.startActivity(recommendIntent);
        CS.log.d("Recommend", "finish to show NewPhoneRecommend");
    }

    public static void backgroundWork() {
        if (!CS.NEW_PHONE_RECOMMEND_OPEN) {
            CS.log.d("Recommend", "NewPhoneRecommend function closed!");
            return;
        }
        Context context = CoreUtil.getContext();
        if (context == null) {
            return;
        }
        ConfigInfo configInfo = ConfigInfoUtil.loadConfigInfo(context);
        if (configInfo == null) {
            configInfo = new ConfigInfo();
        }
        long initTime = configInfo.getInitTime();
        long activeDays = configInfo.getActiveDays();
        if (initTime > 0L) {
            long currentTime = System.currentTimeMillis();
            CS.log.d("Recommend", "current time = " + currentTime);
            if (currentTime > initTime + activeDays * 24L * 60L * 60L * 1000L) {
                CS.log.d("Recommend", "current time beyond active days, delete app details");
                DBManager.getInstance().deleteAllAppDetails();
                configInfo.setHasRequested(true);
                configInfo.setHasShowed(true);
                ConfigInfoUtil.saveConfigInfo(context, configInfo);
                return;
            }
        } else {
            configInfo.setInitTime(System.currentTimeMillis());
            ConfigInfoUtil.saveConfigInfo(CoreUtil.getContext(), configInfo);
        }
        CS.log.d("Recommend", "NewPhoneRecommendHasRequested: " + configInfo.isHasRequested());
        if (NetworkUtil.isConnected(CoreUtil.getContext())) {
            if (configInfo.isHasRequested()) {
                List<AppDetailInfo> appDetailInfoList;
                if (!configInfo.isHasShowed() && (appDetailInfoList = DBManager.getInstance().getAllAppDetails()) != null && appDetailInfoList.size() > 0) {
                    CS.log.d("Recommend", "background work to preload icon");
                    NewPhoneRecommendManager.loadAppIcon(appDetailInfoList);
                }
            } else {
                NewPhoneRecommendMedia.getInstance().syncData(null);
            }
        }
    }

    public static boolean isNetworkAllowed(Context context) {
        if (!CS.NEW_PHONE_RECOMMEND_OPEN) {
            return false;
        }
        ConfigInfo configInfo = ConfigInfoUtil.loadConfigInfo(context);
        int allowNetwork = configInfo != null ? configInfo.getAllowNetwork() : 0;
        boolean allowed = false;
        if (allowNetwork == 1) {
            allowed = NetworkUtil.isWifiConnected(context);
        } else if (allowNetwork == 2) {
            allowed = NetworkUtil.isConnected(context);
        }
        return allowed;
    }

    public static void trackDownloadBegin(int appId, String pkgName, int versionCode) {
        if (!CS.NEW_PHONE_RECOMMEND_OPEN) {
            return;
        }
        AppDetailInfo appDetailInfo = DBManager.getInstance().getAppDetailByAppId(appId);
        int planId = -1;
        if (appDetailInfo != null) {
            planId = appDetailInfo.getPlanId();
        }
        Bundle trackData = new Bundle();
        trackData.putString("qg", pkgName);
        trackData.putInt("ve", versionCode);
        trackData.putString("te", DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", (long)System.currentTimeMillis()) + "");
        trackData.putInt("plid", planId);
        trackData.putInt("net", NetworkUtil.getNetworkTrackType());
        Tracker.trackBundle(Tracker.Event.DOWNLOAD_BEGIN, trackData);
    }

    public static void trackDownloadEnd(int appId, String pkgName, int versionCode, boolean downloadSuccess, int reason) {
        if (!CS.NEW_PHONE_RECOMMEND_OPEN) {
            return;
        }
        AppDetailInfo appDetailInfo = DBManager.getInstance().getAppDetailByAppId(appId);
        int planId = -1;
        if (appDetailInfo != null) {
            planId = appDetailInfo.getPlanId();
        }
        Bundle trackData = new Bundle();
        trackData.putString("qg", pkgName);
        trackData.putInt("ve", versionCode);
        trackData.putString("te", DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", (long)System.currentTimeMillis()) + "");
        trackData.putInt("plid", planId);
        trackData.putInt("dr", downloadSuccess ? 0 : 1);
        trackData.putInt("fr", reason);
        Tracker.trackBundle(Tracker.Event.DOWNLOAD_END, trackData);
    }

    public static void trackInstallBegin(int appId, String pkgName, int versionCode) {
        if (!CS.NEW_PHONE_RECOMMEND_OPEN) {
            return;
        }
        AppDetailInfo appDetailInfo = DBManager.getInstance().getAppDetailByAppId(appId);
        int planId = -1;
        if (appDetailInfo != null) {
            planId = appDetailInfo.getPlanId();
        }
        Bundle trackData = new Bundle();
        trackData.putString("qg", pkgName);
        trackData.putInt("ve", versionCode);
        trackData.putString("te", DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", (long)System.currentTimeMillis()) + "");
        trackData.putInt("plid", planId);
        Tracker.trackBundle(Tracker.Event.INSTALL_BEGIN, trackData);
    }

    public static void trackInstallEnd(int appId, String pkgName, int versionCode, boolean installSuccess) {
        if (!CS.NEW_PHONE_RECOMMEND_OPEN) {
            return;
        }
        AppDetailInfo appDetailInfo = DBManager.getInstance().getAppDetailByAppId(appId);
        int planId = -1;
        if (appDetailInfo != null) {
            planId = appDetailInfo.getPlanId();
        }
        Bundle trackData = new Bundle();
        trackData.putString("qg", pkgName);
        trackData.putInt("ve", versionCode);
        trackData.putString("te", DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", (long)System.currentTimeMillis()) + "");
        trackData.putInt("plid", planId);
        trackData.putInt("ir", installSuccess ? 0 : 1);
        trackData.putInt("fr", 0);
        Tracker.trackBundle(Tracker.Event.INSTALL_END, trackData);
    }

    public static void trackNotificationClick(int apkType) {
        Bundle trackData = new Bundle();
        trackData.putInt("type", apkType);
        trackData.putString("te", DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", (long)System.currentTimeMillis()) + "");
        Tracker.trackBundle(Tracker.Event.NOTIFICATION_CLICK, trackData);
    }

    public static void loadAppIcon(List<AppDetailInfo> appList) {
        if (!CS.NEW_PHONE_RECOMMEND_OPEN) {
            return;
        }
        if (appList == null) {
            return;
        }
        for (final AppDetailInfo appDetailInfo : appList) {
            if (appDetailInfo == null || appDetailInfo.getIcon() == null || TextUtils.isEmpty((CharSequence)appDetailInfo.getIcon().getUrl())) continue;
            AppExecutors.getInstance().ui().execute(() -> {
                Context context = CoreUtil.getContext();
                if (context != null) {
                    Glide.with((Context)context).load(appDetailInfo.getIcon().getUrl()).addListener((RequestListener)new RequestListener<Drawable>(){

                        public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                            CS.log.d("Recommend", "PRELOAD icon FAILED: " + appDetailInfo.getIcon().getUrl());
                            return false;
                        }

                        public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                            CS.log.d("Recommend", "PRELOAD icon READY:" + appDetailInfo.getIcon().getUrl());
                            return false;
                        }
                    }).preload();
                }
            });
        }
    }
}

