/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.newphonerecommend.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.transsion.newphonerecommend.R;
import com.transsion.newphonerecommend.dialog.PromptButtonHelper;
import java.lang.ref.WeakReference;

public final class PromptController {
    private final Context mContext;
    private final DialogInterface mDialogInterface;
    private final Window mWindow;
    private final LayoutInflater mInflater;
    private Handler mHandler;
    private LinearLayout mContainer;
    private LinearLayout mTitleView;
    private ScrollView mScrollMessageView;
    private FrameLayout mFrameContainer;
    private boolean mIsButtonVertical = true;
    private boolean mIsAlert;
    private boolean mHasPositiveButton;
    private Button mButtonPositive;
    private CharSequence mButtonPositiveText;
    private Message mButtonPositiveMessage;
    private boolean mHasNegativeButton;
    private Button mButtonNegative;
    private CharSequence mButtonNegativeText;
    private Message mButtonNegativeMessage;
    private boolean mHasNeutralButton;
    private Button mButtonNeutral;
    private CharSequence mButtonNeutralText;
    private Message mButtonNeutralMessage;
    private final View.OnClickListener mButtonListener = new View.OnClickListener(){

        public void onClick(View v) {
            Object m = v == PromptController.this.mButtonPositive && PromptController.this.mButtonPositiveMessage != null ? Message.obtain((Message)PromptController.this.mButtonPositiveMessage) : (v == PromptController.this.mButtonNegative && PromptController.this.mButtonNegativeMessage != null ? Message.obtain((Message)PromptController.this.mButtonNegativeMessage) : (v == PromptController.this.mButtonNeutral && PromptController.this.mButtonNeutralMessage != null ? Message.obtain((Message)PromptController.this.mButtonNeutralMessage) : null));
            if (m != null) {
                m.sendToTarget();
            }
            PromptController.this.mHandler.obtainMessage(1, (Object)PromptController.this.mDialogInterface).sendToTarget();
        }
    };

    public PromptController(Context context, DialogInterface di, Window window) {
        this.mContext = context;
        this.mDialogInterface = di;
        this.mWindow = window;
        this.mHandler = new ButtonHandler(di);
        this.mInflater = LayoutInflater.from((Context)context);
        window.requestFeature(1);
        window.setGravity(17);
        window.setWindowAnimations(R.style.NrPromptDialogAnimStyle);
        this.mContainer = (LinearLayout)this.mInflater.inflate(R.layout.nr_prompt_dialog_container, null);
    }

    public void installContent() {
        this.mWindow.setContentView((View)this.mContainer);
        this.setupView();
    }

    public void setTitleView(CharSequence title) {
        if (!TextUtils.isEmpty((CharSequence)title)) {
            this.mTitleView = (LinearLayout)this.mInflater.inflate(R.layout.nr_prompt_dialog_title, (ViewGroup)this.mContainer, false);
            TextView textTitle = (TextView)this.mTitleView.findViewById(R.id.text_title);
            textTitle.setText(title);
        }
    }

    public void setMessageView(CharSequence message) {
        if (!TextUtils.isEmpty((CharSequence)message)) {
            this.mScrollMessageView = (ScrollView)this.mInflater.inflate(R.layout.nr_prompt_dialog_message, (ViewGroup)this.mContainer, false);
            TextView messageView = (TextView)this.mScrollMessageView.findViewById(R.id.text_message);
            messageView.setText(message);
        }
    }

    public void setView(int resId, View view) {
        if (resId != 0 || view != null) {
            this.mFrameContainer = (FrameLayout)this.mInflater.inflate(R.layout.nr_prompt_dialog_view, (ViewGroup)this.mContainer, false);
            if (resId != 0) {
                this.mFrameContainer.addView(this.mInflater.inflate(resId, (ViewGroup)this.mFrameContainer, false));
            } else {
                this.mFrameContainer.addView(view);
            }
        }
    }

    public void setButton(int whichButton, CharSequence text, DialogInterface.OnClickListener listener, Message msg) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        if (msg == null && listener != null) {
            msg = this.mHandler.obtainMessage(whichButton, (Object)listener);
        }
        switch (whichButton) {
            case -1: {
                this.mButtonPositiveText = text;
                this.mButtonPositiveMessage = msg;
                this.mHasPositiveButton = true;
                break;
            }
            case -2: {
                this.mButtonNegativeText = text;
                this.mButtonNegativeMessage = msg;
                this.mHasNegativeButton = true;
                break;
            }
            case -3: {
                this.mButtonNeutralText = text;
                this.mButtonNeutralMessage = msg;
                this.mHasNeutralButton = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Button does not exist");
            }
        }
    }

    private void setupView() {
        boolean hasCustomView;
        this.mContainer.removeAllViews();
        boolean hasTitle = this.mTitleView != null;
        boolean hasMessage = this.mScrollMessageView != null;
        boolean bl = hasCustomView = this.mFrameContainer != null;
        if (hasTitle) {
            this.mContainer.addView((View)this.mTitleView);
        }
        if (hasMessage) {
            if (hasTitle) {
                this.mScrollMessageView.setPadding(0, 0, 0, this.mScrollMessageView.getPaddingBottom());
            }
            this.mContainer.addView((View)this.mScrollMessageView);
        }
        if (hasCustomView) {
            if (hasMessage) {
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mScrollMessageView.getLayoutParams();
                lp.height = -2;
                lp.weight = 0.0f;
                this.mScrollMessageView.setLayoutParams((ViewGroup.LayoutParams)lp);
                this.mScrollMessageView.setPadding(0, this.mScrollMessageView.getPaddingTop(), 0, 0);
            }
            this.mContainer.addView((View)this.mFrameContainer);
        }
        this.setupButtons(hasCustomView);
    }

    private void setupButtons(boolean hasCustomView) {
        if (!(this.mHasPositiveButton || this.mHasNegativeButton || this.mHasNeutralButton)) {
            return;
        }
        if (hasCustomView && PromptController.canTextInput((View)this.mFrameContainer)) {
            this.mWindow.setGravity(17);
            this.mIsButtonVertical = false;
        } else {
            this.mWindow.setFlags(131072, 131072);
        }
        View buttonsView = PromptButtonHelper.createButtonView(this.mInflater, (ViewGroup)this.mContainer, this.mIsButtonVertical, new boolean[]{this.mHasPositiveButton, this.mHasNeutralButton});
        this.mButtonPositive = (Button)buttonsView.findViewById(R.id.btn_positive);
        if (this.mHasPositiveButton) {
            this.mButtonPositive.setText(this.mButtonPositiveText);
            this.mButtonPositive.setOnClickListener(this.mButtonListener);
            if (this.mIsAlert) {
                this.mButtonPositive.setTextColor(this.mContext.getColor(R.color.nr_prompt_positive_btn_alert_color));
            }
        } else {
            this.mButtonPositive.setVisibility(8);
        }
        this.mButtonNegative = (Button)buttonsView.findViewById(R.id.btn_negative);
        if (this.mHasNegativeButton) {
            this.mButtonNegative.setText(this.mButtonNegativeText);
            this.mButtonNegative.setOnClickListener(this.mButtonListener);
        } else {
            this.mButtonNegative.setVisibility(8);
        }
        this.mButtonNeutral = (Button)buttonsView.findViewById(R.id.btn_neutral);
        if (this.mHasNeutralButton) {
            this.mButtonNeutral.setText(this.mButtonNeutralText);
            this.mButtonNeutral.setOnClickListener(this.mButtonListener);
        } else {
            this.mButtonNeutral.setVisibility(8);
        }
        this.mContainer.addView(buttonsView);
    }

    private static boolean canTextInput(View v) {
        if (v.onCheckIsTextEditor()) {
            return true;
        }
        if (!(v instanceof ViewGroup)) {
            return false;
        }
        ViewGroup vg = (ViewGroup)v;
        int i = vg.getChildCount();
        while (i > 0) {
            if (!PromptController.canTextInput(v = vg.getChildAt(--i))) continue;
            return true;
        }
        return false;
    }

    public Button getButton(int whichButton) {
        switch (whichButton) {
            case -1: {
                return this.mButtonPositive;
            }
            case -2: {
                return this.mButtonNegative;
            }
            case -3: {
                return this.mButtonNeutral;
            }
        }
        return null;
    }

    public void setIsAlert(boolean isAlert) {
        this.mIsAlert = isAlert;
    }

    public void setTitle(CharSequence title) {
        if (this.mTitleView != null) {
            TextView textTitle = (TextView)this.mTitleView.findViewById(R.id.text_title);
            textTitle.setText(title);
        } else {
            this.setTitleView(title);
        }
    }

    public void setMessage(CharSequence message) {
        if (this.mScrollMessageView != null) {
            TextView messageView = (TextView)this.mScrollMessageView.findViewById(R.id.text_message);
            messageView.setText(message);
        } else {
            this.setMessageView(message);
        }
    }

    private static final class ButtonHandler
    extends Handler {
        private static final int MSG_DISMISS_DIALOG = 1;
        private WeakReference<DialogInterface> mDialog;

        ButtonHandler(DialogInterface dialog) {
            this.mDialog = new WeakReference<DialogInterface>(dialog);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case -3: 
                case -2: 
                case -1: {
                    ((DialogInterface.OnClickListener)msg.obj).onClick((DialogInterface)this.mDialog.get(), msg.what);
                    break;
                }
                case 1: {
                    ((DialogInterface)msg.obj).dismiss();
                }
            }
        }
    }
}

