/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.newphonerecommend.media;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.format.DateFormat;
import com.transsion.core.CoreUtil;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.http.impl.HttpCallbackImpl;
import com.transsion.http.impl.StringCallback;
import com.transsion.json.Tson;
import com.transsion.newphonerecommend.NewPhoneRecommendManager;
import com.transsion.newphonerecommend.bean.AppDetailInfo;
import com.transsion.newphonerecommend.bean.AppInfo;
import com.transsion.newphonerecommend.bean.ConfigInfo;
import com.transsion.newphonerecommend.bean.NewPhoneRecommendPlan;
import com.transsion.newphonerecommend.bean.NewPhoneRecommendReqBean;
import com.transsion.newphonerecommend.bean.NewPhoneRecommendResBean;
import com.transsion.newphonerecommend.bean.PhoneInfo;
import com.transsion.newphonerecommend.database.DBManager;
import com.transsion.newphonerecommend.http.HttpTool;
import com.transsion.newphonerecommend.log.CS;
import com.transsion.newphonerecommend.manager.PhoneInfoManager;
import com.transsion.newphonerecommend.media.IMediaCallback;
import com.transsion.newphonerecommend.report.Tracker;
import com.transsion.newphonerecommend.utils.ConfigInfoUtil;
import com.transsion.newphonerecommend.utils.PackageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NewPhoneRecommendMedia {
    private static final int CODE_SUCCESS = 200;
    private static final int CODE_OUT_ACTIVE_RANGE = 201;
    private static NewPhoneRecommendMedia sMedia = null;

    public static NewPhoneRecommendMedia getInstance() {
        if (null == sMedia) {
            sMedia = new NewPhoneRecommendMedia();
        }
        return sMedia;
    }

    public void syncData(IMediaCallback mediaCallback) {
        CS.log.d("Recommend", "\u5f00\u59cb\u540c\u6b65NewPhoneRecommend\u6570\u636e\uff0cNewPhoneRecommendMedia -> updateTime: " + Math.abs(System.currentTimeMillis()));
        new AppSyncTask(mediaCallback).execute(new String[0]);
    }

    private void syncDataInternal(PhoneInfo phoneInfo, List<Integer> planIdList, List<AppInfo> appInfoList, int checkStep, final IMediaCallback mediaCallback) {
        NewPhoneRecommendReqBean newPhoneRecommendReqBean = new NewPhoneRecommendReqBean(phoneInfo, planIdList, appInfoList, checkStep);
        String data = Tson.toJson((Object)newPhoneRecommendReqBean);
        CS.log.d("Recommend", "NewPhoneRecommendMedia req JSON ->" + data);
        this.trackRequest();
        HttpTool.getTool().getNewPhoneRecommend(data, (HttpCallbackImpl)new StringCallback(){

            public void onFailure(int i, String s, Throwable throwable) {
                CS.log.d("Recommend", "NewPhoneRecommendMedia : onFailure->" + s);
                NewPhoneRecommendMedia.this.trackResponse(null, 1, -1);
                if (null != mediaCallback) {
                    mediaCallback.onRequestFailed(s);
                }
            }

            public void onSuccess(int i, String s) {
                CS.log.d("Recommend", "NewPhoneRecommendMedia : onCallbackSuccess->" + (s.length() > 2048 ? Integer.valueOf(2048) : s));
                if (!TextUtils.isEmpty((CharSequence)s)) {
                    try {
                        NewPhoneRecommendMedia.this.parseDataByTask(s, mediaCallback);
                    }
                    catch (Exception e) {
                        CS.log.d("Recommend", "NewPhoneRecommendMedia : syncDataInternal Exception->" + s);
                        NewPhoneRecommendMedia.this.trackResponse(null, 1, -3);
                        if (null != mediaCallback) {
                            mediaCallback.onRequestFailed(e.toString());
                        }
                    }
                } else if (null != mediaCallback) {
                    mediaCallback.onRequestFailed("DATA IS NULL");
                }
            }
        });
    }

    private void trackRequest() {
        Context context = CoreUtil.getContext();
        if (context != null) {
            Bundle trackData = new Bundle();
            trackData.putString("qg", context.getPackageName());
            trackData.putInt("ve", PackageUtil.getVersionCode(context));
            trackData.putString("te", DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", (long)System.currentTimeMillis()) + "");
            Tracker.trackBundle(Tracker.Event.RECOMMEND_REQUEST, trackData);
        }
    }

    private void trackResponse(ArrayList<Integer> planIdList, int result, int reason) {
        Context context = CoreUtil.getContext();
        if (context != null) {
            Bundle trackData = new Bundle();
            trackData.putString("qg", context.getPackageName());
            trackData.putInt("ve", PackageUtil.getVersionCode(context));
            trackData.putString("te", DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", (long)System.currentTimeMillis()) + "");
            trackData.putIntegerArrayList("plid", planIdList);
            trackData.putInt("pr", result);
            trackData.putInt("fr", reason);
            Tracker.trackBundle(Tracker.Event.RECOMMEND_RESPONSE, trackData);
        }
    }

    private void handleRunnable(Runnable r) {
        if (r == null) {
            return;
        }
        TranssionPoolManager.getInstance().addTask(r);
    }

    private void parseDataByTask(final String jsonData, final IMediaCallback iMediaCallback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    NewPhoneRecommendMedia.this.parseData(jsonData, iMediaCallback);
                }
                catch (Exception e) {
                    if (null != iMediaCallback) {
                        iMediaCallback.onRequestFailed(e.toString());
                    }
                    CS.log.d("Recommend", "Exception -> " + e.toString());
                }
            }
        };
        this.handleRunnable(runnable);
    }

    private void parseData(String jsonData, IMediaCallback mediaCallback) {
        CS.log.d("Recommend", "jsonData=" + jsonData);
        try {
            ConfigInfo configInfo;
            NewPhoneRecommendResBean data = (NewPhoneRecommendResBean)Tson.fromJson((String)jsonData, NewPhoneRecommendResBean.class);
            boolean hasEffectivePlan = false;
            if (data == null) {
                this.trackResponse(null, 1, -3);
                return;
            }
            if (data.getCode() != 200) {
                Context context;
                if (data.getActivatedTime() > 0L && data.getMaxActiveTime() > 0L && System.currentTimeMillis() - data.getActivatedTime() > data.getMaxActiveTime() * 24L * 60L * 60L * 1000L && (context = CoreUtil.getContext()) != null) {
                    ConfigInfo configInfo2 = ConfigInfoUtil.loadConfigInfo(context);
                    if (configInfo2 == null) {
                        configInfo2 = new ConfigInfo();
                    }
                    configInfo2.setInitTime(data.getActivatedTime());
                    configInfo2.setActiveDays(data.getMaxActiveTime());
                    configInfo2.setHasShowed(true);
                    configInfo2.setHasRequested(true);
                    ConfigInfoUtil.saveConfigInfo(context, configInfo2);
                }
                this.trackResponse(null, 1, -2);
                return;
            }
            List<NewPhoneRecommendPlan> plans = data.getPlans();
            if (plans != null) {
                ArrayList<Integer> planIdList = new ArrayList<Integer>();
                HashMap<String, AppDetailInfo> planPkgMap = new HashMap<String, AppDetailInfo>();
                for (NewPhoneRecommendPlan plan : plans) {
                    if (plan == null) continue;
                    List<AppDetailInfo> planAppList = plan.getRecommendAppList();
                    if (planAppList != null) {
                        for (AppDetailInfo appDetailInfo : planAppList) {
                            if (appDetailInfo == null || TextUtils.isEmpty((CharSequence)appDetailInfo.getPkgName())) {
                                CS.log.d("Recommend", "RECOMMEND APP FILTER: invalid appDetailInfo(null OR empty pkgName)");
                                continue;
                            }
                            AppDetailInfo existPkgAppDetailInfo = (AppDetailInfo)planPkgMap.get(appDetailInfo.getPkgName());
                            if (existPkgAppDetailInfo != null) {
                                if (existPkgAppDetailInfo.getVersionCode() > appDetailInfo.getVersionCode()) {
                                    CS.log.d("Recommend", "RECOMMEND APP FILTER: exist same pkg appDetailInfo(pkg=" + appDetailInfo.getPkgName() + ", existVersion=" + existPkgAppDetailInfo.getVersionCode() + ", thisVersion=" + appDetailInfo.getVersionCode() + ")");
                                    continue;
                                }
                                CS.log.d("Recommend", "exist same pkg, but previous app is not high than this app(pkg=" + appDetailInfo.getPkgName() + ", existVersion=" + existPkgAppDetailInfo.getVersionCode() + ", thisVersion=" + appDetailInfo.getVersionCode() + ")");
                            }
                            if (PackageUtil.checkApkExist(CoreUtil.getContext(), appDetailInfo.getPkgName(), appDetailInfo.getVersionCode())) {
                                CS.log.d("Recommend", "RECOMMEND APP FILTER: local installed app(pkg=" + appDetailInfo.getPkgName() + ", version=" + appDetailInfo.getVersionCode() + ")");
                                continue;
                            }
                            appDetailInfo.setPlanId(plan.getPlanId());
                            planPkgMap.put(appDetailInfo.getPkgName(), appDetailInfo);
                        }
                    }
                    planIdList.add(plan.getPlanId());
                }
                ArrayList<AppDetailInfo> appList = new ArrayList<AppDetailInfo>(planPkgMap.values());
                if (appList.size() > 0) {
                    DBManager.getInstance().saveOrUpdateAppDetailList(appList);
                    NewPhoneRecommendManager.loadAppIcon(appList);
                    hasEffectivePlan = true;
                    this.trackResponse(planIdList, 0, 0);
                } else {
                    this.trackResponse(planIdList, 1, -4);
                }
            }
            if ((configInfo = ConfigInfoUtil.loadConfigInfo(CoreUtil.getContext())) == null) {
                configInfo = new ConfigInfo();
            }
            if (data.getActivatedTime() > 0L) {
                configInfo.setInitTime(data.getActivatedTime());
            }
            if (data.getMaxActiveTime() <= 30L && data.getMaxActiveTime() > 0L) {
                configInfo.setActiveDays(data.getMaxActiveTime());
            } else {
                configInfo.setActiveDays(30L);
            }
            if (hasEffectivePlan) {
                configInfo.setHasRequested(true);
            }
            ConfigInfoUtil.saveConfigInfo(CoreUtil.getContext(), configInfo);
        }
        catch (Exception e) {
            CS.log.e("Recommend", e.getMessage());
            this.trackResponse(null, 1, -3);
        }
    }

    private static class AppSyncTask
    extends AsyncTask<String, Integer, List<AppInfo>> {
        IMediaCallback iMediaCallback;

        AppSyncTask(IMediaCallback callback) {
            this.iMediaCallback = callback;
        }

        protected List<AppInfo> doInBackground(String ... params) {
            List<AppInfo> appInfoList = PackageUtil.initAppList(CoreUtil.getContext());
            if (null != appInfoList && appInfoList.size() > 0) {
                return appInfoList;
            }
            return null;
        }

        protected void onPostExecute(List<AppInfo> appInfoList) {
            if (null != sMedia) {
                List planIDList = null;
                PhoneInfo phoneInfo = PhoneInfoManager.getInstance().getPhoneInfo();
                sMedia.syncDataInternal(phoneInfo, planIDList, appInfoList, 0, this.iMediaCallback);
            }
        }
    }
}

