/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.newphonerecommend.ui;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PersistableBundle;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.transsion.core.utils.ToastUtil;
import com.transsion.json.Tson;
import com.transsion.newphonerecommend.R;
import com.transsion.newphonerecommend.bean.AppDetailInfo;
import com.transsion.newphonerecommend.bean.ConfigInfo;
import com.transsion.newphonerecommend.bean.RecommendTaskData;
import com.transsion.newphonerecommend.log.CS;
import com.transsion.newphonerecommend.receiver.NetworkReceiver;
import com.transsion.newphonerecommend.report.Tracker;
import com.transsion.newphonerecommend.service.NewPhoneRecommendService;
import com.transsion.newphonerecommend.ui.BaseDialog;
import com.transsion.newphonerecommend.ui.NewPhoneRecommendContract;
import com.transsion.newphonerecommend.ui.NewPhoneRecommendPresenter;
import com.transsion.newphonerecommend.ui.RecommendListAdapter;
import com.transsion.newphonerecommend.ui.TopPromptDialog;
import com.transsion.newphonerecommend.utils.ConfigInfoUtil;
import com.transsion.newphonerecommend.utils.NetworkUtil;
import java.util.ArrayList;
import java.util.List;

public class NewPhoneRecommendDialog
extends BaseDialog
implements NewPhoneRecommendContract.View {
    private RelativeLayout mRlRecommendContent;
    private TextView mTvRecommendSkip;
    private RecyclerView mRvRecommendList;
    private CheckBox mCbRecommendAllowUseData;
    private TextView mTvRecommendNetworkStatus;
    private Button mBtnRecommendDownload;
    private NewPhoneRecommendContract.Presenter mPresenter;
    private List<AppDetailInfo> mData = new ArrayList<AppDetailInfo>();
    private RecommendListAdapter mAdapter;
    private TopPromptDialog mSkipDialog;
    private NetworkReceiver mNetworkReceiver;
    private boolean mIsWifiConnected;

    public NewPhoneRecommendDialog(@NonNull Context context) {
        super(context);
    }

    @Override
    public void onCreate() {
        this.initData();
    }

    private void initData() {
        if (this.mPresenter == null) {
            this.mPresenter = new NewPhoneRecommendPresenter(this);
        }
        this.mPresenter.loadData();
    }

    @Override
    public void showData(List<AppDetailInfo> appDetailInfoList) {
        if (appDetailInfoList != null) {
            this.mData.clear();
            this.mData.addAll(appDetailInfoList);
            this.setContentView(R.layout.layout_new_phone_recommend);
            this.assignView();
            this.initWindow();
            this.initView();
            this.registerReceiver();
        } else {
            this.dismiss();
        }
    }

    private void assignView() {
        this.mRlRecommendContent = (RelativeLayout)this.findViewById(R.id.rl_recommend_content);
        this.mTvRecommendSkip = (TextView)this.findViewById(R.id.tv_recommend_skip);
        this.mRvRecommendList = (RecyclerView)this.findViewById(R.id.rv_recommend_list);
        this.mCbRecommendAllowUseData = (CheckBox)this.findViewById(R.id.cb_recommend_agree_use_data);
        this.mTvRecommendNetworkStatus = (TextView)this.findViewById(R.id.tv_recommend_network_status);
        this.mBtnRecommendDownload = (Button)this.findViewById(R.id.btn_recommend_download);
    }

    private void initWindow() {
        if (this.mData.size() < 4) {
            ViewGroup.LayoutParams layoutParams = this.mRlRecommendContent.getLayoutParams();
            int itemHeight = this.mContext.getResources().getDimensionPixelSize(R.dimen.new_phone_recommend_item_height);
            layoutParams.height -= itemHeight * (4 - this.mData.size());
            this.mRlRecommendContent.setLayoutParams(layoutParams);
        }
    }

    private void initView() {
        this.mRvRecommendList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.mAdapter = new RecommendListAdapter(this.mContext, this, this.mData);
        this.mRvRecommendList.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.updateNetworkStatusText();
        this.mBtnRecommendDownload.setText((CharSequence)this.mContext.getResources().getString(R.string.btn_download_text, new Object[]{this.mData.size()}));
        this.mTvRecommendSkip.setOnClickListener((View.OnClickListener)this);
        this.mBtnRecommendDownload.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void onDismiss() {
        this.mAdapter = null;
        if (this.mSkipDialog != null) {
            this.mSkipDialog.dismiss();
            this.mSkipDialog = null;
        }
        if (this.mPresenter != null) {
            this.mPresenter.onDestroy();
            this.mPresenter = null;
        }
        this.unregisterReceiver();
        if (this.mContext != null) {
            Intent intent = new Intent(this.mContext, NewPhoneRecommendService.class);
            this.mContext.stopService(intent);
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.tv_recommend_skip) {
            this.showSkipDialog();
        } else if (view.getId() == R.id.btn_recommend_download) {
            CS.log.d("Recommend", "begin to download");
            if (!NetworkUtil.isConnected(this.mContext)) {
                ToastUtil.showLongToast((int)R.string.network_error);
            } else {
                ToastUtil.showLongToast((int)R.string.notification_app_update_dl_start);
            }
            this.mPresenter.trackAppList(Tracker.Event.UPDATE_BTN_CLICK, this.mData);
            this.sendToDownload();
        }
    }

    @Override
    public void updateNetworkStatusText() {
        if (NetworkUtil.isWifiConnected(this.mContext)) {
            this.mIsWifiConnected = true;
            this.mTvRecommendNetworkStatus.setText(R.string.network_status_wifi_connected);
            this.mCbRecommendAllowUseData.setVisibility(8);
        } else if (NetworkUtil.isMobileData(this.mContext)) {
            this.mIsWifiConnected = false;
            this.mTvRecommendNetworkStatus.setText(R.string.network_status_allow_use_data);
            this.mCbRecommendAllowUseData.setChecked(true);
            this.mCbRecommendAllowUseData.setVisibility(0);
        }
    }

    private void sendToDownload() {
        ArrayList<AppDetailInfo> downloadAppDetailInfoList = new ArrayList<AppDetailInfo>();
        for (AppDetailInfo appDetailInfo : this.mData) {
            if (appDetailInfo == null || !appDetailInfo.isChecked()) continue;
            downloadAppDetailInfoList.add(appDetailInfo);
        }
        if (downloadAppDetailInfoList.size() > 0) {
            RecommendTaskData data = new RecommendTaskData();
            data.setAppDetailInfoList(downloadAppDetailInfoList);
            String jsonData = Tson.toJson((Object)data);
            JobScheduler js = (JobScheduler)this.mContext.getSystemService("jobscheduler");
            if (js != null) {
                CS.log.d("Recommend", " ---> call startJob  NewPhoneRecommendJobService ...");
                long interval = CS.TEST_MODE ? 300000L : 1800000L;
                PersistableBundle bundle = new PersistableBundle();
                bundle.putString("recommend_data", jsonData);
                js.schedule(new JobInfo.Builder(369, new ComponentName("com.transsion.plat.appupdate", "com.transsion.appupdate.service.NewPhoneRecommendJobService")).setRequiredNetworkType(1).setOverrideDeadline(interval * 2L).setExtras(bundle).build());
            }
            this.saveConfigInfo(false);
        }
        this.dismiss();
    }

    private void showSkipDialog() {
        if (this.mSkipDialog == null) {
            this.mSkipDialog = new TopPromptDialog.Builder(this.mContext).setMessage(R.string.dialog_confirm_skip_text).setPositiveButton(R.string.dialog_btn_text_cancel, (dialog, witch) -> dialog.dismiss()).setNegativeButton(R.string.dialog_btn_text_confirm, (dialog, witch) -> {
                dialog.dismiss();
                if (this.mPresenter != null) {
                    this.mPresenter.trackAppList(Tracker.Event.SKIP_BTN_CLICK, this.mData);
                }
                this.saveConfigInfo(true);
                this.dismiss();
            }).create();
        }
        this.mSkipDialog.show();
    }

    @Override
    public void updateDownloadButton() {
        int checkedAppCount = 0;
        for (AppDetailInfo appDetailInfo : this.mData) {
            if (!appDetailInfo.isChecked()) continue;
            ++checkedAppCount;
        }
        if (checkedAppCount > 0) {
            this.mBtnRecommendDownload.setEnabled(true);
            this.mBtnRecommendDownload.setBackground(this.mContext.getDrawable(R.drawable.nr_btn_dialog_arc_edge_background));
        } else {
            this.mBtnRecommendDownload.setEnabled(false);
            this.mBtnRecommendDownload.setBackground(this.mContext.getDrawable(R.drawable.nr_btn_dialog_arc_edge_background_disable));
        }
        this.mBtnRecommendDownload.setText((CharSequence)this.mContext.getResources().getString(R.string.btn_download_text, new Object[]{checkedAppCount}));
    }

    private void saveConfigInfo(boolean isSkipped) {
        ConfigInfo configInfo = ConfigInfoUtil.loadConfigInfo(this.mContext);
        if (configInfo == null) {
            configInfo = new ConfigInfo();
        }
        if (isSkipped) {
            configInfo.setAllowNetwork(0);
        } else {
            int allowNetwork = 1;
            if (!this.mIsWifiConnected && this.mCbRecommendAllowUseData != null) {
                allowNetwork = this.mCbRecommendAllowUseData.isChecked() ? 2 : 1;
            }
            configInfo.setAllowNetwork(allowNetwork);
        }
        configInfo.setHasShowed(true);
        ConfigInfoUtil.saveConfigInfo(this.mContext, configInfo);
    }

    private void registerReceiver() {
        if (this.mNetworkReceiver == null) {
            this.mNetworkReceiver = new NetworkReceiver(this);
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            this.mContext.registerReceiver((BroadcastReceiver)this.mNetworkReceiver, intentFilter);
        }
    }

    private void unregisterReceiver() {
        if (this.mNetworkReceiver != null) {
            try {
                this.mContext.unregisterReceiver((BroadcastReceiver)this.mNetworkReceiver);
                this.mNetworkReceiver = null;
            }
            catch (Exception e) {
                CS.log.d("Recommend", "network receiver unregister exception");
            }
        }
    }
}

