/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.newphonerecommend.utils;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.transsion.core.pool.TranssionPoolManager;
import java.util.concurrent.Executor;

public class AppExecutors {
    private final Executor workThread;
    private final Executor uiThread = new MainThreadExecutor();
    private static volatile AppExecutors INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppExecutors getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<AppExecutors> clazz = AppExecutors.class;
        synchronized (AppExecutors.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new AppExecutors();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private AppExecutors() {
        this.workThread = new WorkThreadExecutor();
    }

    public Executor work() {
        return this.workThread;
    }

    public Executor ui() {
        return this.uiThread;
    }

    private class WorkThreadExecutor
    implements Executor {
        private WorkThreadExecutor() {
        }

        @Override
        public void execute(@NonNull Runnable command) {
            TranssionPoolManager.getInstance().addTask(command);
        }
    }

    private class MainThreadExecutor
    implements Executor {
        private Handler mMainHandler = new Handler(Looper.getMainLooper());

        private MainThreadExecutor() {
        }

        @Override
        public void execute(@NonNull Runnable command) {
            this.mMainHandler.post(command);
        }
    }
}

