/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.newphonerecommend.utils;

import android.content.Context;
import android.text.TextUtils;
import com.transsion.json.Tson;
import com.transsion.newphonerecommend.bean.ConfigInfo;
import com.transsion.newphonerecommend.log.CS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ConfigInfoUtil {
    private static final String CONFIG_INFO_FILE_NAME = "recommend.cfg";

    public static void saveConfigInfo(Context context, ConfigInfo configInfo) {
        if (context == null) {
            return;
        }
        if (configInfo == null) {
            configInfo = new ConfigInfo();
        }
        try {
            String configInfoJson = Tson.toJson((Object)configInfo);
            ConfigInfoUtil.saveDataToFile(CONFIG_INFO_FILE_NAME, configInfoJson, context);
        }
        catch (Exception e) {
            CS.log.e("Recommend", e.getMessage());
        }
    }

    public static ConfigInfo loadConfigInfo(Context context) {
        if (context == null) {
            return null;
        }
        String configInfoJson = ConfigInfoUtil.loadDataFromFile(CONFIG_INFO_FILE_NAME, context);
        try {
            ConfigInfo configInfo = (ConfigInfo)Tson.fromJson((String)configInfoJson, ConfigInfo.class);
            return configInfo;
        }
        catch (Exception e) {
            CS.log.e("Recommend", e.getMessage());
            return new ConfigInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveDataToFile(String filename, String msg, Context context) {
        if (TextUtils.isEmpty((CharSequence)filename) || TextUtils.isEmpty((CharSequence)msg) || context == null) {
            return;
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(new File(context.getFilesDir(), filename));
            outStream.write(msg.getBytes());
        }
        catch (IOException e) {
            CS.log.e("Recommend", e.getMessage());
        }
        finally {
            try {
                outStream.close();
            }
            catch (IOException e) {
                CS.log.e("Recommend", e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadDataFromFile(String filename, Context context) {
        if (TextUtils.isEmpty((CharSequence)filename) || context == null) {
            return null;
        }
        File file = new File(context.getFilesDir(), filename);
        if (!file.exists()) {
            return null;
        }
        FileInputStream inputStream = null;
        try {
            String rst;
            inputStream = new FileInputStream(file);
            int length = inputStream.available();
            byte[] buffer = new byte[length];
            inputStream.read(buffer);
            String string2 = rst = new String(buffer);
            return string2;
        }
        catch (IOException e) {
            CS.log.e("Recommend", e.getMessage());
            String string3 = null;
            return string3;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                CS.log.e("Recommend", e.getMessage());
            }
        }
    }
}

