/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.athena.entry.config;

import android.text.TextUtils;
import android.util.Log;
import com.transsion.athena.data.Config;
import com.transsion.athena.data.logobj.AppConfigCallBack;
import com.transsion.athena.entry.config.TidConfig;
import com.transsion.athena.entry.config.TidConfigBean;
import com.transsion.athena.upload.DataUtils;
import com.transsion.athena.utils.AthenaUtils;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.json.Tson;
import com.transsion.json.annotations.TserializedName;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.json.JSONObject;

public class AppConfig {
    @TserializedName(include=false)
    public static final String TAG = AppConfig.class.getName();
    @TserializedName(include=false)
    public static final int PUSH_TIME_ERROR = -1;
    @TserializedName(include=false)
    public static final int PUSH_TIME_OUT = 1;
    @TserializedName(include=false)
    public static final int PUSH_TIME_NORMAL = 2;
    @TserializedName
    public List<TidConfigBean> tidConfigs = new ArrayList<TidConfigBean>();
    private static AppConfig a;

    private static String a() {
        return Config.getPath() + File.separator + "app.config";
    }

    public static AppConfig getInstance() {
        if (a == null) {
            String string = DataUtils.readFile(new File(AppConfig.a()));
            if (!TextUtils.isEmpty((CharSequence)string)) {
                try {
                    a = (AppConfig)Tson.fromJson((String)string, AppConfig.class);
                    if (AppConfig.a.tidConfigs.size() > 0) {
                        Config.setSessionInterval(AppConfig.a.tidConfigs.get(AppConfig.a.tidConfigs.size() - 1).getTidConfig().getSessionExpired());
                    }
                }
                catch (Exception exception) {
                    AthenaUtils.LOG.e((Object)Log.getStackTraceString((Throwable)exception));
                }
            }
            if (a == null) {
                a = new AppConfig();
                a.a(0L);
            }
        }
        return a;
    }

    private AppConfig() {
    }

    public int checkTimeMode(int n) {
        long l = this.queryOrGenConfigByTid(n).getTidConfig().getPushTime();
        long l2 = this.queryOrGenConfigByTid(n).getTidConfig().getPushDuration();
        AthenaUtils.LOG.i((Object)("tid config tid:" + n + " " + this.queryOrGenConfigByTid(n).getTidConfig().toString()));
        AthenaUtils.LOG.i((Object)("currentTime:" + System.currentTimeMillis() + " pushTime:" + l + " pushDuration:" + l2 + " should to post data, out of Time is " + (System.currentTimeMillis() - l >= l2)));
        if (l == -1L || l2 == -1L) {
            return -1;
        }
        if (System.currentTimeMillis() - l >= l2) {
            return 1;
        }
        return 2;
    }

    public boolean checkCachedItems(int n) {
        TidConfig tidConfig = this.queryOrGenConfigByTid(n).getTidConfig();
        return tidConfig.getMaxCachedItems() != 0 && tidConfig.getMaxCachedItems() <= tidConfig.getCachedItems();
    }

    public synchronized boolean checkConfig(AppConfigCallBack appConfigCallBack) {
        for (TidConfigBean tidConfigBean : this.tidConfigs) {
            appConfigCallBack.call(tidConfigBean);
        }
        return true;
    }

    public long getPushDuring(int n) {
        TidConfigBean tidConfigBean = this.queryOrGenConfigByTid(n);
        long l = tidConfigBean.getTidConfig().getPushDuration();
        int n2 = tidConfigBean.getTidConfig().getUrHash();
        long l2 = AthenaUtils.getHashCode();
        int n3 = Math.abs(DeviceInfo.getGAId().hashCode()) % 100;
        AthenaUtils.LOG.i((Object)("local Hash: " + l2 + "  config urHash: " + n2));
        AthenaUtils.LOG.i((Object)String.format(Locale.ENGLISH, "Local gaidHash = %s config gHash (%d, %d)", n3, tidConfigBean.getTidConfig().getGmin(), tidConfigBean.getTidConfig().getGmax()));
        if (l2 > (long)n2 || n3 < tidConfigBean.getTidConfig().getGmin() || n3 > tidConfigBean.getTidConfig().getGmax()) {
            l = -1L;
            AthenaUtils.LOG.i((Object)"Because of the hash, Ignore this point true");
        }
        return l;
    }

    public int queryNetWorkFlag(int n) {
        TidConfigBean tidConfigBean = this.queryOrGenConfigByTid(n);
        return tidConfigBean.getTidConfig().getNetWorkFlag();
    }

    public void changeDataFlag(int n, int n2) {
        TidConfigBean tidConfigBean = this.findConfigByTid(n);
        if (tidConfigBean != null) {
            tidConfigBean.getTidConfig().setDataFlag(n2);
            tidConfigBean.getTidConfig().addOneCachedItem();
        }
        this.b();
    }

    public void resetDataFlag(int n) {
        TidConfigBean tidConfigBean = this.findConfigByTid(n);
        if (tidConfigBean != null) {
            tidConfigBean.getTidConfig().setDataFlag(-1);
            tidConfigBean.getTidConfig().setPushTime(System.currentTimeMillis());
            tidConfigBean.getTidConfig().setCachedItems(0);
        }
        this.b();
    }

    public synchronized TidConfigBean findConfigByTid(long l) {
        for (TidConfigBean tidConfigBean : this.tidConfigs) {
            if ((long)tidConfigBean.getTid() != l) continue;
            return tidConfigBean;
        }
        return null;
    }

    public synchronized TidConfigBean findConfigByAppId(long l) {
        String string = "" + l;
        string = string.substring(0, 4);
        for (TidConfigBean tidConfigBean : this.tidConfigs) {
            if (!(tidConfigBean.getTid() + "").startsWith(string)) continue;
            return tidConfigBean;
        }
        return null;
    }

    public TidConfigBean queryOrGenConfigByTid(int n) {
        TidConfigBean tidConfigBean = this.findConfigByTid(n);
        if (tidConfigBean == null) {
            TidConfig tidConfig = new TidConfig();
            tidConfig.setPushDuration(600000L);
            tidConfig.setUrHash(100);
            tidConfig.setStreamFlag(1);
            tidConfig.setNetWorkFlag(0);
            tidConfigBean = new TidConfigBean(n, tidConfig);
        }
        return tidConfigBean;
    }

    private void b() {
        try {
            DataUtils.bufferSave(AppConfig.a(), Tson.toJson((Object)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void setServerData(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        try {
            boolean bl = true;
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                int n;
                int n2;
                String string2 = (String)iterator.next();
                int n3 = Integer.parseInt(string2);
                TidConfigBean tidConfigBean = this.findConfigByTid(n3);
                if (tidConfigBean == null) {
                    tidConfigBean = new TidConfigBean();
                    this.tidConfigs.add(tidConfigBean);
                }
                tidConfigBean.setTid(n3);
                JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                int n4 = jSONObject2.getInt("cv");
                int n5 = jSONObject2.getInt("ur");
                if (jSONObject2.has("gmin")) {
                    n2 = jSONObject2.getInt("gmin");
                    tidConfigBean.getTidConfig().setGmin(n2);
                }
                if (jSONObject2.has("gmax")) {
                    n2 = jSONObject2.getInt("gmax");
                    tidConfigBean.getTidConfig().setGmax(n2);
                }
                n2 = jSONObject2.getInt("iw");
                int n6 = jSONObject2.getInt("ct");
                if (jSONObject2.has("num")) {
                    n = jSONObject2.getInt("num");
                    tidConfigBean.getTidConfig().setMaxCachedItems(n);
                }
                if (jSONObject2.has("s")) {
                    n = jSONObject2.getInt("s");
                    tidConfigBean.getTidConfig().setSessionExpired((long)n * 60000L);
                    Config.setSessionInterval((long)n * 60000L);
                }
                tidConfigBean.getTidConfig().setPushDuration((long)n4 * 60000L);
                tidConfigBean.getTidConfig().setUrHash(n5);
                tidConfigBean.getTidConfig().setStreamFlag(n6);
                tidConfigBean.getTidConfig().setNetWorkFlag(n2);
                if (n4 == -1) continue;
                bl = false;
            }
            if (bl) {
                this.a(-1L);
            }
        }
        catch (Exception exception) {
            AthenaUtils.LOG.e((Object)Log.getStackTraceString((Throwable)exception));
        }
        this.b();
    }

    private synchronized void a(long l) {
        for (int i = 0; i <= 10; ++i) {
            TidConfigBean tidConfigBean = this.findConfigByTid(i);
            if (tidConfigBean == null) {
                TidConfig tidConfig = new TidConfig();
                tidConfig.setPushDuration(l);
                tidConfig.setUrHash(100);
                tidConfig.setStreamFlag(1);
                tidConfig.setNetWorkFlag(0);
                this.tidConfigs.add(new TidConfigBean(i, tidConfig));
                continue;
            }
            tidConfigBean.getTidConfig().setPushDuration(l);
        }
        this.b();
    }
}

