/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.athena.upload;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.athena.data.Config;
import com.transsion.athena.entry.config.GlobalConfig;
import com.transsion.athena.utils.AthenaUtils;
import com.transsion.core.CoreUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class DataUtils {
    private static Pattern a = Pattern.compile("\\d+");
    private static HashMap<String, String> b = new HashMap();

    static synchronized boolean a(String string, String string2) {
        String string3 = string2.replace("\r\n", "").trim();
        String string4 = b.get(string);
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            string3 = string4 + "\n" + string3;
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, true));
            if (new File(string).length() > 10L) {
                bufferedWriter.newLine();
            }
            bufferedWriter.append(string3);
            bufferedWriter.flush();
            bufferedWriter.close();
            b.put(string, "");
            return true;
        }
        catch (Exception exception) {
            AthenaUtils.LOG.e((Object)Log.getStackTraceString((Throwable)exception));
            AthenaUtils.LOG.e((Object)("buffer append save failed! " + string3));
            b.put(string, string3);
            return false;
        }
    }

    public static void bufferSave(String string, String string2) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, false));
            bufferedWriter.append(string2);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            AthenaUtils.LOG.e((Object)Log.getStackTraceString((Throwable)exception));
        }
    }

    public static void deleteDir(String string) {
        File file = new File(string);
        DataUtils.a(file);
    }

    private static void a(File file) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return;
        }
        for (File file2 : file.listFiles()) {
            if (file2.isFile()) {
                DataUtils.deleteFileSafely(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            DataUtils.a(file2);
        }
    }

    static long a(String string) {
        if (string == null) {
            return 0L;
        }
        File file = new File(string);
        return DataUtils.b(file);
    }

    private static long b(File file) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return 0L;
        }
        long l = 0L;
        for (File file2 : file.listFiles()) {
            if (file2.isFile()) {
                l += file2.length();
                continue;
            }
            if (!file2.isDirectory()) continue;
            l += DataUtils.b(file2);
        }
        return l;
    }

    public static void deleteOldFiles(String string, long l) {
        List<File> list = DataUtils.listFileSortByModifyTime(string);
        for (File file : list) {
            if (!file.isFile()) continue;
            Matcher matcher = a.matcher(file.getName());
            int n = -1;
            if (matcher.find()) {
                n = Integer.valueOf(matcher.group());
            }
            if (l <= 0L || n <= 10) continue;
            l -= file.length();
            DataUtils.deleteFileSafely(file);
        }
    }

    public static boolean deleteFileSafely(File file) {
        if (file != null) {
            String string = file.getParent() + File.separator + System.currentTimeMillis();
            File file2 = new File(string);
            file.renameTo(file2);
            return file2.delete();
        }
        return false;
    }

    public static List<File> listFileSortByModifyTime(String string) {
        List<File> list = DataUtils.a(string, new ArrayList<File>());
        if (list != null && list.size() > 0) {
            try {
                Collections.sort(list, new Comparator<File>(){

                    public int a(File file, File file2) {
                        if (file.lastModified() < file2.lastModified()) {
                            return -1;
                        }
                        if (file.lastModified() == file2.lastModified()) {
                            return 0;
                        }
                        return 1;
                    }

                    @Override
                    public /* synthetic */ int compare(Object object, Object object2) {
                        return this.a((File)object, (File)object2);
                    }
                });
            }
            catch (Exception exception) {
                AthenaUtils.LOG.e((Object)Log.getStackTraceString((Throwable)exception));
            }
        }
        return list;
    }

    private static List<File> a(String string, List<File> list) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isDirectory()) {
                    DataUtils.a(file2.getAbsolutePath(), list);
                    continue;
                }
                list.add(file2);
            }
        }
        return list;
    }

    public static String readFile(File file) {
        if (!file.exists()) {
            return "";
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = fileInputStream.available();
            byte[] byArray = new byte[n];
            fileInputStream.read(byArray);
            fileInputStream.close();
            return new String(byArray);
        }
        catch (Exception exception) {
            AthenaUtils.LOG.e((Object)Log.getStackTraceString((Throwable)exception));
            return "";
        }
    }

    public static boolean requestByPost(boolean bl, String string, String string2, int n) {
        if (string2.lastIndexOf(125) != string2.length() - 1) {
            string2 = string2.substring(0, string2.lastIndexOf(125) + 1);
        }
        try {
            Object object;
            boolean bl2;
            AthenaUtils.LOG.i((Object)String.format(Locale.ENGLISH, "post tid: %s data: %s", string, string2));
            AthenaUtils.LOG.json(string2);
            byte[] byArray = string2.getBytes();
            URL uRL = new URL(Config.getUploadUrl());
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(15000);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setInstanceFollowRedirects(true);
            boolean bl3 = bl2 = GlobalConfig.getInstance().getThreshold() * 1024L <= (long)byArray.length;
            if (bl2) {
                httpURLConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
                AthenaUtils.LOG.i((Object)"Upload zip data");
            } else {
                httpURLConnection.setRequestProperty("Accept-Encoding", "text/example");
                AthenaUtils.LOG.i((Object)"Upload normal data");
            }
            if (bl) {
                httpURLConnection.setRequestProperty("fixed", "1");
            } else {
                httpURLConnection.setRequestProperty("fixed", "0");
            }
            httpURLConnection.setRequestProperty("record-id", string);
            httpURLConnection.setRequestProperty("count", n + "");
            httpURLConnection.setRequestProperty("md5", DataUtils.getMD5(string2));
            httpURLConnection.connect();
            if (bl2) {
                object = new GZIPOutputStream(httpURLConnection.getOutputStream());
                ((FilterOutputStream)object).write(byArray);
                ((DeflaterOutputStream)object).flush();
                ((DeflaterOutputStream)object).close();
            } else {
                object = new DataOutputStream(httpURLConnection.getOutputStream());
                ((FilterOutputStream)object).write(byArray);
                ((DataOutputStream)object).flush();
                ((FilterOutputStream)object).close();
            }
            Config.getStepCallBack().step(Integer.parseInt(string), 107, "ResponseCode:" + httpURLConnection.getResponseCode());
            if (httpURLConnection.getResponseCode() == 200) {
                object = DataUtils.a(httpURLConnection.getInputStream());
                if (object != null && !TextUtils.isEmpty((CharSequence)object)) {
                    JSONObject jSONObject = new JSONObject((String)object);
                    int n2 = jSONObject.optInt("code");
                    if (n2 == 0) {
                        AthenaUtils.LOG.i((Object)String.format(Locale.ENGLISH, "post tid: %s success!", string));
                        Config.getStepCallBack().step(Integer.parseInt(string), 108, "success");
                        return true;
                    }
                    AthenaUtils.LOG.i(object);
                }
                return false;
            }
            AthenaUtils.LOG.i((Object)String.format(Locale.ENGLISH, "tid: %s response code: %d", string, httpURLConnection.getResponseCode()));
        }
        catch (Exception exception) {
            AthenaUtils.LOG.e((Object)Log.getStackTraceString((Throwable)exception));
            Config.getStepCallBack().step(Integer.parseInt(string), 110, "UploadError:" + exception.getMessage() + " DNS:" + DataUtils.getDNS() + " IP:" + DataUtils.getPublicIPAddress());
            DataUtils.isNetworkAvailable();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void isNetworkAvailable() {
        URL uRL = null;
        try {
            uRL = new URL("http://www.google.com");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(6000);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.connect();
            Config.getStepCallBack().step(0, 166, "google code:" + httpURLConnection.getResponseCode());
            if (httpURLConnection.getResponseCode() != 200) return;
        }
        catch (Exception exception) {
            AthenaUtils.LOG.e((Object)Log.getStackTraceString((Throwable)exception));
            Config.getStepCallBack().step(0, 166, "google error:" + exception.getMessage());
        }
    }

    public static String getPublicIPAddress() {
        try {
            Context context = CoreUtil.getContext();
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
                StringBuilder stringBuilder = new StringBuilder();
                HttpURLConnection httpURLConnection = (HttpURLConnection)new URL("http://checkip.amazonaws.com/").openConnection();
                httpURLConnection.setRequestProperty("User-Agent", "Android-device");
                httpURLConnection.setReadTimeout(15000);
                httpURLConnection.setConnectTimeout(15000);
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setRequestProperty("Content-type", "application/json");
                httpURLConnection.connect();
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    String string;
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string);
                    }
                }
                httpURLConnection.disconnect();
                return stringBuilder.toString();
            }
            return "";
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static String getDNS() {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)CoreUtil.getContext().getSystemService("connectivity");
            if (Build.VERSION.SDK_INT >= 21) {
                for (Network network : connectivityManager.getAllNetworks()) {
                    NetworkInfo networkInfo = connectivityManager.getNetworkInfo(network);
                    if (!networkInfo.isConnected()) continue;
                    LinkProperties linkProperties = connectivityManager.getLinkProperties(network);
                    Log.d((String)"DnsInfo", (String)("iface = " + linkProperties.getInterfaceName()));
                    Log.d((String)"DnsInfo", (String)("dns = " + linkProperties.getDnsServers()));
                    return linkProperties.getDnsServers().toString();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private static String a(InputStream inputStream) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            bufferedReader.close();
            bufferedReader = null;
            inputStream.close();
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static int readLineNumber(File file) {
        try {
            if (file.exists()) {
                FileReader fileReader = new FileReader(file);
                LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
                int n = 0;
                while (lineNumberReader.readLine() != null) {
                    ++n;
                }
                lineNumberReader.close();
                return n;
            }
        }
        catch (Exception exception) {
            AthenaUtils.LOG.e((Object)Log.getStackTraceString((Throwable)exception));
        }
        return 0;
    }

    public static String getMD5(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes("UTF-8"));
            byte[] byArray = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                if (Integer.toHexString(0xFF & byArray[i]).length() == 1) {
                    stringBuffer.append("0").append(Integer.toHexString(0xFF & byArray[i]));
                    continue;
                }
                stringBuffer.append(Integer.toHexString(0xFF & byArray[i]));
            }
            return stringBuffer.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static void validateData(int n, File file) {
        String string = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            string = bufferedReader.readLine();
            while (string != null) {
                new JSONObject(string);
                string = bufferedReader.readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            Config.getStepCallBack().step(n, 200, string);
        }
    }
}

