/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.athena.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Log;
import com.transsion.athena.data.Config;
import com.transsion.athena.upload.DataUtils;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.core.log.ObjectLogUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.TimeZone;
import java.util.UUID;

public class AthenaUtils {
    public static ObjectLogUtils LOG = new ObjectLogUtils.Builder().setGlobalTag("Athena").setLogHeadSwitch(true).setBorderSwitch(false).create();

    public static String genUUid() {
        String string;
        try {
            string = UUID.randomUUID().toString();
        }
        catch (Exception exception) {
            LOG.e((Object)Log.getStackTraceString((Throwable)exception));
            return String.valueOf((DeviceInfo.getGAId() + DeviceInfo.getAndroidID() + System.currentTimeMillis()).hashCode());
        }
        return string;
    }

    public static String getCurrentTimeZone() {
        String string = "";
        try {
            TimeZone timeZone = TimeZone.getDefault();
            return AthenaUtils.createGmtOffsetString(true, true, timeZone.getRawOffset());
        }
        catch (Throwable throwable) {
            LOG.e((Object)Log.getStackTraceString((Throwable)throwable));
            return string;
        }
    }

    public static String createGmtOffsetString(boolean bl, boolean bl2, int n) {
        int n2 = n / 60000;
        char c = '+';
        if (n2 < 0) {
            c = '-';
            n2 = -n2;
        }
        StringBuilder stringBuilder = new StringBuilder(9);
        if (bl) {
            stringBuilder.append("GMT");
        }
        stringBuilder.append(c);
        AthenaUtils.a(stringBuilder, 2, n2 / 60);
        if (bl2) {
            stringBuilder.append(':');
        }
        AthenaUtils.a(stringBuilder, 2, n2 % 60);
        return stringBuilder.toString();
    }

    private static void a(StringBuilder stringBuilder, int n, int n2) {
        String string = Integer.toString(n2);
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String string, String string2) {
        String string3 = "";
        if (string2 != null) {
            string3 = string2;
        }
        Config.getStepCallBack().step(0, 160, "url:" + string);
        HttpURLConnection httpURLConnection = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            URL uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("accept", "*/*");
            httpURLConnection.setRequestProperty("connection", "Keep-Alive");
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(string3.length()));
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setConnectTimeout(15000);
            httpURLConnection.setReadTimeout(10000);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            PrintWriter printWriter = new PrintWriter(httpURLConnection.getOutputStream());
            printWriter.write(string3);
            printWriter.flush();
            printWriter.close();
            int n = httpURLConnection.getResponseCode();
            LOG.i((Object)("url:" + string + " code:" + n + " Post Data:" + string2));
            Config.getStepCallBack().step(0, 161, "url:" + string + " code:" + n);
            if (n == 200) {
                String string4;
                InputStream inputStream = httpURLConnection.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while ((string4 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string4);
                }
                LOG.i((Object)("config:" + stringBuilder));
                Config.getStepCallBack().step(0, 164, "url:config:" + stringBuilder);
                bufferedReader.close();
                inputStream.close();
            }
        }
        catch (Throwable throwable) {
            LOG.i((Object)("url:" + string + " exception:" + throwable.getMessage()));
            LOG.e((Object)Log.getStackTraceString((Throwable)throwable));
            Config.getStepCallBack().step(0, 162, "Config Error:" + throwable.getMessage() + " DNS:" + DataUtils.getDNS() + " IP:" + DataUtils.getPublicIPAddress());
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return stringBuilder.toString();
    }

    public static long getHashCode() {
        return System.currentTimeMillis() % 100L;
    }

    public static boolean isWifi(Context context) {
        ConnectivityManager connectivityManager = null;
        try {
            connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }
        catch (Exception exception) {
            LOG.e((Object)Log.getStackTraceString((Throwable)exception));
        }
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
        if (networkInfo == null) {
            return false;
        }
        return networkInfo.isConnected();
    }

    public static boolean isDataConnected(Context context) {
        boolean bl;
        block20: {
            bl = true;
            if (Build.VERSION.SDK_INT < 21) {
                LOG.i((Object)"API level \u5c0f\u4e8e21");
                ConnectivityManager connectivityManager = null;
                try {
                    connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                    if (connectivityManager == null) break block20;
                    NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
                    NetworkInfo networkInfo2 = connectivityManager.getNetworkInfo(0);
                    if (networkInfo != null && networkInfo2 != null && networkInfo.isConnected() && networkInfo2.isConnected()) {
                        LOG.i((Object)"WIFI\u5df2\u8fde\u63a5,\u79fb\u52a8\u6570\u636e\u5df2\u8fde\u63a5");
                        break block20;
                    }
                    if (networkInfo != null && networkInfo2 != null && networkInfo.isConnected() && !networkInfo2.isConnected()) {
                        LOG.i((Object)"WIFI\u5df2\u8fde\u63a5,\u79fb\u52a8\u6570\u636e\u5df2\u65ad\u5f00");
                        break block20;
                    }
                    if (networkInfo != null && networkInfo2 != null && !networkInfo.isConnected() && networkInfo2.isConnected()) {
                        LOG.i((Object)"WIFI\u5df2\u65ad\u5f00,\u79fb\u52a8\u6570\u636e\u5df2\u8fde\u63a5");
                        break block20;
                    }
                    LOG.i((Object)"WIFI\u5df2\u65ad\u5f00,\u79fb\u52a8\u6570\u636e\u5df2\u65ad\u5f00");
                    bl = false;
                }
                catch (Exception exception) {
                    LOG.e((Object)Log.getStackTraceString((Throwable)exception));
                }
            } else {
                LOG.i((Object)"API level \u5927\u4e8e21");
                ConnectivityManager connectivityManager = null;
                Network[] networkArray = null;
                try {
                    connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                    if (connectivityManager != null) {
                        networkArray = connectivityManager.getAllNetworks();
                    }
                    if (connectivityManager == null || networkArray == null) {
                        return false;
                    }
                    int n = 0;
                    for (Network network : networkArray) {
                        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(network);
                        if (networkInfo == null) continue;
                        if (networkInfo.getType() == 0 && !networkInfo.isConnected()) {
                            ++n;
                        }
                        if (networkInfo.getType() == 0 && networkInfo.isConnected()) {
                            n += 2;
                        }
                        if (networkInfo.getType() != 1) continue;
                        n += 4;
                    }
                    switch (n) {
                        case 0: {
                            LOG.i((Object)"WIFI\u5df2\u65ad\u5f00,\u79fb\u52a8\u6570\u636e\u5df2\u65ad\u5f00");
                            bl = false;
                            break;
                        }
                        case 2: {
                            LOG.i((Object)"WIFI\u5df2\u65ad\u5f00,\u79fb\u52a8\u6570\u636e\u5df2\u8fde\u63a5");
                            break;
                        }
                        case 4: {
                            LOG.i((Object)"WIFI\u5df2\u8fde\u63a5,\u79fb\u52a8\u6570\u636e\u5df2\u65ad\u5f00");
                            break;
                        }
                        case 5: {
                            LOG.i((Object)"WIFI\u5df2\u8fde\u63a5,\u79fb\u52a8\u6570\u636e\u5df2\u8fde\u63a5");
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    LOG.e((Object)Log.getStackTraceString((Throwable)exception));
                }
            }
        }
        return bl;
    }
}

