/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.ContentObserver;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.text.TextUtils;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.transsion.dataservice.DCSReceiver;
import com.transsion.dataservice.DailyJobService;
import com.transsion.dataservice.DailyJobService2;
import com.transsion.dataservice.SubJob;
import com.transsion.dataservice.track.CrashInfoSubJob;
import com.transsion.dataservice.track.DataUsageSubJob;
import com.transsion.dataservice.track.FirstBootInfoSubJob;
import com.transsion.dataservice.track.GeneralSheetSubJob;
import com.transsion.dataservice.track.IAppListSubJob;
import com.transsion.dataservice.track.NAppListSubJob;
import com.transsion.dataservice.track.NetDurationSubJob;
import com.transsion.dataservice.util.DCSUtils;
import com.transsion.dataservice.util.ThreadUtils;
import com.transsion.ga.AthenaAnalytics;
import java.util.ArrayList;
import org.json.JSONObject;

public class DCSModule {
    private static DCSModule sDCSModule;
    private Context mContext;
    private boolean isTestMode;
    private boolean mIsUserExperienceOn = false;
    private String mCompatDataPath;
    private boolean isMainProcess = false;
    private final ContentObserver mUserExperienceObserver = new ContentObserver(new Handler(Looper.getMainLooper())){

        public void onChange(boolean selfChange) {
            DCSModule.this.mIsUserExperienceOn = Settings.System.getInt((ContentResolver)DCSModule.this.mContext.getContentResolver(), (String)"user_experience", (int)0) == 1 || Settings.Global.getInt((ContentResolver)DCSModule.this.mContext.getContentResolver(), (String)"os_supreme_user_experience", (int)0) == 1;
            DCSUtils.LOG.d((Object)("user_experience : " + DCSModule.this.mIsUserExperienceOn));
            try {
                SharedPreferences setting;
                AthenaAnalytics.enable((boolean)DCSModule.this.mIsUserExperienceOn);
                if (!DCSModule.this.mIsUserExperienceOn && !(setting = DCSModule.this.mContext.getSharedPreferences("tcrypto", 0)).contains("gdpr_close")) {
                    JSONObject trackData = new JSONObject().put("event", (Object)"gdpr_close").put("ts", System.currentTimeMillis()).put("tid", 999961000019L).put("net", DCSUtils.getNetworkType(DCSModule.this.mContext).ordinal()).put("eparam", (Object)"{}");
                    setting.edit().putString("gdpr_close", trackData.toString()).apply();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private DCSModule() {
    }

    public static DCSModule getInstance() {
        if (sDCSModule == null) {
            sDCSModule = new DCSModule();
        }
        return sDCSModule;
    }

    public boolean isTestMode() {
        return this.isTestMode;
    }

    public SharedPreferences getSharedPreferences() {
        if (this.isMainProcess) {
            return this.mContext.getSharedPreferences("shared_preference_of_dcs", 0);
        }
        return this.mContext.getSharedPreferences("shared_preference_of_dcs2", 0);
    }

    public void init(Context context, boolean isTest) {
        this.isTestMode = isTest;
        this.isMainProcess = true;
        this.mContext = context.getApplicationContext();
        AthenaAnalytics.setWorkMode((int)3);
        AthenaAnalytics.init((Context)context, (String)"transsion", (int)9999, (boolean)isTest, (boolean)false);
        AthenaAnalytics.setMaxCacheFileSize((int)0x3200000);
        DCSUtils.LOG.getBuilder().setLogSwitch(isTest);
        DCSUtils.LOG.d((Object)"DCS module version 2.0.0.3");
        DCSReceiver dcsReceiver = new DCSReceiver(context);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
        intentFilter.addAction("android.intent.action.HEADSET_PLUG");
        intentFilter.addAction("android.intent.action.ACTION_SHUTDOWN");
        LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)dcsReceiver, intentFilter);
        context.getContentResolver().registerContentObserver(Settings.System.getUriFor((String)"user_experience"), true, this.mUserExperienceObserver);
        context.getContentResolver().registerContentObserver(Settings.Global.getUriFor((String)"os_supreme_user_experience"), true, this.mUserExperienceObserver);
        this.mUserExperienceObserver.onChange(true);
        this.trackWhenBooted(context);
        this.cancelOldJobService(context, -9999);
        this.ensureJobServiceScheduled(context, -1024);
    }

    public void init2(Context context) {
        this.mContext = context.getApplicationContext();
        DCSReceiver dcsReceiver = new DCSReceiver(context);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_FULLY_REMOVED");
        intentFilter.addAction("android.intent.action.PACKAGE_REPLACED");
        intentFilter.addDataScheme("package");
        LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)dcsReceiver, intentFilter);
        intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SIM_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        context.registerReceiver((BroadcastReceiver)dcsReceiver, intentFilter);
        context.getContentResolver().registerContentObserver(Settings.System.getUriFor((String)"user_experience"), true, this.mUserExperienceObserver);
        context.getContentResolver().registerContentObserver(Settings.Global.getUriFor((String)"os_supreme_user_experience"), true, this.mUserExperienceObserver);
        this.mUserExperienceObserver.onChange(true);
        this.trackWhenBooted(context);
        this.ensureJobServiceScheduled(context, -1025);
    }

    public String getCompatDataPath() {
        return this.mCompatDataPath;
    }

    public void setCompatDataPath(String dataPath) {
        this.mCompatDataPath = dataPath;
    }

    public Context getContext() {
        return this.mContext;
    }

    public boolean isUserExperienceEnable() {
        return this.mIsUserExperienceOn;
    }

    private void trackWhenBooted(Context context) {
        ArrayList<SubJob> trackSubJobList = new ArrayList<SubJob>();
        if (this.isUserExperienceEnable()) {
            if (this.isMainProcess) {
                trackSubJobList.add(new GeneralSheetSubJob(null, context));
            } else {
                trackSubJobList.add(new FirstBootInfoSubJob(null, context));
                trackSubJobList.add(new IAppListSubJob(null, context));
                trackSubJobList.add(new NAppListSubJob(null, context));
                trackSubJobList.add(new NetDurationSubJob(null, context));
                trackSubJobList.add(new DataUsageSubJob(null, context));
                trackSubJobList.add(new CrashInfoSubJob(null, context));
            }
        }
        for (final SubJob s : trackSubJobList) {
            ThreadUtils.postOnBackgroundThread(new Runnable(){

                @Override
                public void run() {
                    s.startIfNeeded();
                }
            });
        }
    }

    private void ensureJobServiceScheduled(Context context, int jobId) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        JobInfo dailyJob = jobScheduler.getPendingJob(jobId);
        long intervalMillis = 3600000L;
        if (dailyJob != null && dailyJob.getIntervalMillis() == intervalMillis && dailyJob.getNetworkType() == 0) {
            DCSUtils.LOG.i((Object)(dailyJob.getId() + " have scheduled"));
            if (jobId == -1025 && !TextUtils.equals((CharSequence)DailyJobService2.class.getName(), (CharSequence)dailyJob.getService().getClassName())) {
                jobScheduler.cancel(jobId);
                DCSUtils.LOG.i((Object)(jobId + " have scheduled"));
                JobInfo.Builder builder = new JobInfo.Builder(jobId, new ComponentName(context.getPackageName(), DailyJobService2.class.getName()));
                builder.setRequiredNetworkType(0);
                builder.setPeriodic(intervalMillis, JobInfo.getMinFlexMillis());
                builder.setPersisted(true);
                jobScheduler.schedule(builder.build());
            }
        } else {
            DCSUtils.LOG.i((Object)(jobId + " have scheduled"));
            JobInfo.Builder builder = new JobInfo.Builder(jobId, new ComponentName(context.getPackageName(), jobId == -1024 ? DailyJobService.class.getName() : DailyJobService2.class.getName()));
            builder.setRequiredNetworkType(0);
            builder.setPeriodic(intervalMillis, JobInfo.getMinFlexMillis());
            builder.setPersisted(true);
            jobScheduler.schedule(builder.build());
        }
    }

    private void cancelOldJobService(Context context, int jobId) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        JobInfo dailyJob = jobScheduler.getPendingJob(jobId);
        if (dailyJob != null && dailyJob.getId() == jobId && TextUtils.equals((CharSequence)DailyJobService.class.getName(), (CharSequence)dailyJob.getService().getClassName())) {
            jobScheduler.cancel(jobId);
            DCSUtils.LOG.i((Object)(jobId + " have cancelled"));
        }
    }
}

