/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice;

import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Context;
import com.transsion.dataservice.DCSModule;
import com.transsion.dataservice.SubJob;
import com.transsion.dataservice.SubJobHolder;
import com.transsion.dataservice.provider.DCSConfigManager;
import com.transsion.dataservice.track.CrashInfoSubJob;
import com.transsion.dataservice.track.DataUsageSubJob;
import com.transsion.dataservice.track.DeviceActiveSubJob;
import com.transsion.dataservice.track.DeviceUsageSubJob;
import com.transsion.dataservice.track.FirstBootInfoSubJob;
import com.transsion.dataservice.track.GeneralSheetSubJob;
import com.transsion.dataservice.track.IAppListSubJob;
import com.transsion.dataservice.track.NAppListSubJob;
import com.transsion.dataservice.track.NetDurationSubJob;
import com.transsion.dataservice.track.UsageStatesSubJob;
import com.transsion.dataservice.util.DCSUtils;
import com.transsion.dataservice.util.ThreadUtils;
import java.util.ArrayList;
import java.util.List;

public class DailyJobService
extends JobService
implements SubJobHolder {
    private JobParameters mJobParams;
    private final List<SubJob> mSubJobList = new ArrayList<SubJob>();

    public void onCreate() {
        super.onCreate();
        DCSUtils.LOG.i((Object)"onCreate DailyJobService");
    }

    public void onDestroy() {
        super.onDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onStartJob(JobParameters jobParameters) {
        DCSUtils.LOG.i((Object)("onStart DailyJobService jobId = " + jobParameters.getJobId()));
        this.mJobParams = jobParameters;
        Context context = this.getApplicationContext();
        DCSConfigManager configManager = DCSConfigManager.getInstance(context);
        ArrayList<SubJob> trackSubJobList = new ArrayList<SubJob>();
        if (DCSModule.getInstance().isUserExperienceEnable()) {
            if (this.mJobParams.getJobId() == -1024) {
                trackSubJobList.add(new GeneralSheetSubJob(this, context));
                trackSubJobList.add(new DeviceUsageSubJob(this, context));
            } else {
                trackSubJobList.add(new FirstBootInfoSubJob(this, context));
                trackSubJobList.add(new DeviceActiveSubJob(this, context));
                trackSubJobList.add(new CrashInfoSubJob(this, context));
                trackSubJobList.add(new NetDurationSubJob(this, context));
                trackSubJobList.add(new DataUsageSubJob(this, context));
                trackSubJobList.add(new UsageStatesSubJob(this, context));
                trackSubJobList.add(new IAppListSubJob(this, context, configManager.getPeriod("iapp_list", 86400000L)));
                trackSubJobList.add(new NAppListSubJob(this, context, configManager.getPeriod("napp_list", 604800000L)));
            }
        }
        if (trackSubJobList.size() > 0) {
            Object object = this.mSubJobList;
            synchronized (object) {
                this.mSubJobList.clear();
                this.mSubJobList.addAll(trackSubJobList);
            }
            object = trackSubJobList.iterator();
            while (object.hasNext()) {
                SubJob s;
                final SubJob subJob = s = (SubJob)object.next();
                ThreadUtils.postOnBackgroundThread(new Runnable(){

                    @Override
                    public void run() {
                        subJob.startIfNeeded();
                    }
                });
            }
        }
        return true;
    }

    public boolean onStopJob(JobParameters jobParameters) {
        DCSUtils.LOG.i((Object)("onStop DailyJobService jobId = " + jobParameters.getJobId()));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubJobFinished(SubJob subJob, boolean success) {
        List<SubJob> list = this.mSubJobList;
        synchronized (list) {
            this.mSubJobList.remove(subJob);
            DCSUtils.LOG.i((Object)("onSubJobFinished remove " + subJob));
            if (this.mSubJobList.size() == 0) {
                DCSUtils.LOG.i((Object)"jobFinished cause no running subjob ");
                this.jobFinished(this.mJobParams, false);
            }
        }
    }
}

