/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.provider;

import com.transsion.dataservice.util.DCSUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DCSDataManager {
    private static final DCSDataManager sInstance = new DCSDataManager();
    private final Map<String, String> mDeviceData = new ConcurrentHashMap<String, String>();

    private DCSDataManager() {
    }

    public static DCSDataManager getInstance() {
        return sInstance;
    }

    public void set(String key, String value) {
        if (key != null && value != null) {
            this.mDeviceData.put(key, value);
        }
    }

    public String get(String propKey) {
        if (this.mDeviceData.containsKey(propKey)) {
            return this.mDeviceData.get(propKey);
        }
        String propValue = "";
        switch (propKey) {
            case "iid": {
                propValue = DCSUtils.getIMEI(0);
                break;
            }
            case "iid2": {
                propValue = DCSUtils.getIMEI(1);
                break;
            }
            case "oneid": {
                propValue = this.mDeviceData.get(propKey);
            }
        }
        if (propValue != null && propValue.length() > 0) {
            this.mDeviceData.put(propKey, propValue);
        }
        return propValue;
    }
}

