/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.athena.data.TrackData;
import com.transsion.dataservice.provider.DCSConfigManager;
import com.transsion.dataservice.provider.DCSDataManager;
import com.transsion.dataservice.util.DCSUtils;
import com.transsion.ga.AthenaAnalytics;
import com.transsion.gslb.GslbSdk;
import org.json.JSONObject;

public class DCSProvider
extends ContentProvider {
    private static final String AUTHORITY = "com.transsion.dataservice.provider";
    private WorkerHandler mWorkerHandler;
    private static final UriMatcher sUriMatcher = new UriMatcher(-1);
    private static final int URI_CODE_APP_AUTHORIZE = 1;
    private static final int URI_CODE_BIND_APPID = 2;
    private static final int URI_CODE_RECORD_TRACK = 3;
    private static final int URI_CODE_DEVICE_PROPERTY = 4;
    private static final int URI_CODE_GSLB = 5;
    private static final String BLANK_DOMAIN = "blank";

    public boolean onCreate() {
        this.mWorkerHandler = new WorkerHandler(Looper.getMainLooper());
        return true;
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        int uriCode = sUriMatcher.match(uri);
        DCSUtils.LOG.i((Object)("DCSProvider query uri = " + uri));
        int authority = 0;
        try {
            authority = DCSConfigManager.getInstance(this.getContext()).authorize(this.getCallingPackage());
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        switch (uriCode) {
            case 1: {
                try {
                    if (authority == 1) {
                        MatrixCursor cursor = new MatrixCursor(new String[]{"result"}, 1);
                        cursor.addRow((Object[])new String[]{"OK"});
                        return cursor;
                    }
                }
                catch (Exception e) {
                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
            }
            case 4: {
                try {
                    String propValue;
                    MatrixCursor cursor = new MatrixCursor(new String[]{"result"}, 1);
                    if (authority == 0) {
                        cursor.addRow((Object[])new String[]{"UNKNOWN"});
                        return cursor;
                    }
                    if (authority == 1 && selectionArgs != null && selectionArgs.length == 1 && (propValue = DCSDataManager.getInstance().get(selectionArgs[0])) != null && propValue.length() > 0) {
                        Object[] values = new String[]{propValue};
                        cursor.addRow(values);
                        return cursor;
                    }
                }
                catch (Exception e) {
                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
                break;
            }
            case 5: {
                try {
                    if (selectionArgs != null) {
                        MatrixCursor cursor = new MatrixCursor(selectionArgs, 1);
                        if (GslbSdk.isInitSuccess((String)"all.com")) {
                            Object[] values = new String[selectionArgs.length];
                            for (int i = 0; i < selectionArgs.length; ++i) {
                                values[i] = GslbSdk.getDomain((String)selectionArgs[i], (boolean)true);
                            }
                            cursor.addRow(values);
                        }
                        return cursor;
                    }
                    break;
                }
                catch (Exception e) {
                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
            }
        }
        return null;
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues contentValues) {
        int uriCode = sUriMatcher.match(uri);
        int authority = 0;
        try {
            authority = DCSConfigManager.getInstance(this.getContext()).authorize2(this.getCallingPackage());
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        if (authority != 1) {
            DCSUtils.LOG.d((Object)("DCSProvider insert failed " + this.getCallingPackage()));
            return null;
        }
        switch (uriCode) {
            case 2: {
                if (contentValues == null) break;
                try {
                    Message message = this.mWorkerHandler.obtainMessage(400);
                    message.arg1 = contentValues.getAsInteger("appId");
                    message.obj = contentValues.getAsString("baseInfo");
                    message.sendToTarget();
                }
                catch (Exception e) {
                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
                break;
            }
            case 3: {
                if (contentValues == null) break;
                try {
                    Message message = this.mWorkerHandler.obtainMessage(302);
                    message.obj = contentValues.getAsString("trackObject");
                    message.sendToTarget();
                }
                catch (Exception e) {
                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
                break;
            }
            case 4: {
                break;
            }
        }
        return null;
    }

    public int bulkInsert(@NonNull Uri uri, @NonNull ContentValues[] values) {
        return 0;
    }

    public int delete(@NonNull Uri uri, @Nullable String s, @Nullable String[] strings) {
        return 0;
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues contentValues, @Nullable String s, @Nullable String[] strings) {
        return 0;
    }

    static {
        sUriMatcher.addURI(AUTHORITY, "authorize", 1);
        sUriMatcher.addURI(AUTHORITY, "bind", 2);
        sUriMatcher.addURI(AUTHORITY, "track", 3);
        sUriMatcher.addURI(AUTHORITY, "property", 4);
        sUriMatcher.addURI(AUTHORITY, "gslb", 5);
    }

    private static class WorkerHandler
    extends Handler {
        private WorkerHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 302: {
                    try {
                        String trackObject = (String)message.obj;
                        if (TextUtils.isEmpty((CharSequence)trackObject)) break;
                        JSONObject trackObjectJs = new JSONObject(trackObject);
                        long tid = trackObjectJs.getLong("tid");
                        String eventName = trackObjectJs.getString("event");
                        TrackData trackData = new TrackData(trackObjectJs.getInt("type"), trackObjectJs.getString("_eparam"));
                        AthenaAnalytics.getInstance((long)tid).track(eventName, trackData, tid);
                    }
                    catch (Exception e) {
                        DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                    }
                    break;
                }
                case 400: {
                    AthenaAnalytics.getInstance((int)9999).bindLiteAppId(message.arg1, (String)message.obj);
                    break;
                }
            }
        }
    }
}

