/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.track;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.DropBoxManager;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.athenacust.AthenaCust;
import com.transsion.dataservice.DCSModule;
import com.transsion.dataservice.PeriodicSubJob;
import com.transsion.dataservice.SubJobHolder;
import com.transsion.dataservice.util.DCSUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CrashInfoSubJob
extends PeriodicSubJob {
    public static final String EVENT_CRASH = "app_crash";
    public static final long PERIOD_OF_CRASH_INFO_TRACK = 86400000L;
    private static final String DROPBOX_TAG_SYSTEM_APP_CRASH = "system_app_crash";
    private static final String DROPBOX_TAG_DATA_APP_CRASH = "data_app_crash";
    private static final String[] TRACKER_TAG_LIST = new String[]{"data_app_crash", "system_app_crash"};
    private static final String KEY_LAST_CRASH_TIME = "last_crash_time";
    private final Pattern mPackagePattern = Pattern.compile("Package:\\s(\\S+)\\s(\\S+)\\s(\\S+)");

    public CrashInfoSubJob(SubJobHolder holder, Context context) {
        super(holder, context, 86400000L, 0L, "crash");
    }

    public CrashInfoSubJob(SubJobHolder holder, Context context, long period) {
        super(holder, context, period, 0L, "crash");
    }

    @Override
    public void doJob() {
        DCSUtils.LOG.i((Object)"------- CrashInfoSubJob doJob -------");
        long currentTimeMillis = System.currentTimeMillis();
        SharedPreferences setting = DCSModule.getInstance().getSharedPreferences();
        DropBoxManager dropBoxManager = (DropBoxManager)this.mContext.getSystemService("dropbox");
        if (dropBoxManager == null) {
            this.finish(true);
            return;
        }
        LocalDate currentDate = Instant.ofEpochMilli(currentTimeMillis).atZone(ZoneId.systemDefault()).toLocalDate();
        long lastTrackTime = setting.getLong(KEY_LAST_CRASH_TIME, 0L);
        if (lastTrackTime == 0L || currentTimeMillis <= lastTrackTime) {
            LocalDateTime startDateTime = LocalDateTime.of(currentDate.minusDays(1L), LocalTime.MIN);
            long startTime = startDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            try {
                this.readCrashLogForDropBox(dropBoxManager, startTime, startTime + 86400000L - 1L);
            }
            catch (Exception e) {
                DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            }
        } else {
            LocalDate lastLocalDate;
            DCSUtils.LOG.d((Object)("track crash last time = " + DCSUtils.transferMillisToDate(lastTrackTime) + ",current = " + DCSUtils.transferMillisToDate(currentTimeMillis)));
            if (currentTimeMillis - lastTrackTime >= 604800000L) {
                lastTrackTime = currentTimeMillis - 604800000L;
            }
            LocalDate localDate = lastLocalDate = Instant.ofEpochMilli(lastTrackTime).atZone(ZoneId.systemDefault()).toLocalDate();
            while (localDate.isBefore(currentDate)) {
                LocalDateTime startDateTime = LocalDateTime.of(localDate, LocalTime.MIN);
                long startTime = startDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                try {
                    this.readCrashLogForDropBox(dropBoxManager, startTime, startTime + 86400000L - 1L);
                }
                catch (Exception e) {
                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
                localDate = localDate.plusDays(1L);
            }
        }
        setting.edit().putLong(KEY_LAST_CRASH_TIME, currentTimeMillis).apply();
        this.finish(true);
    }

    private void readCrashLogForDropBox(DropBoxManager dropBoxManager, long startTime, long endTime) {
        DCSUtils.LOG.i((Object)("track crash time = " + DCSUtils.transferMillisToDate(startTime)));
        HashMap<String, AppCrashCnt> appCrashMap = new HashMap<String, AppCrashCnt>();
        try {
            block4: for (String tag : TRACKER_TAG_LIST) {
                DropBoxManager.Entry entry;
                long time = startTime;
                while ((entry = dropBoxManager.getNextEntry(tag, time)) != null) {
                    time = entry.getTimeMillis();
                    if (time >= endTime) {
                        DCSUtils.LOG.d((Object)("track crash break time = " + time));
                        entry.close();
                        continue block4;
                    }
                    String crashLog = entry.getText(1024);
                    if (TextUtils.isEmpty((CharSequence)crashLog)) {
                        entry.close();
                        continue;
                    }
                    for (String line : crashLog.split("\n")) {
                        String vn;
                        if (!line.startsWith("Package:")) continue;
                        DCSUtils.LOG.d((Object)("track crash line = " + line));
                        Matcher matcher = this.mPackagePattern.matcher(line);
                        if (!matcher.find()) break;
                        String pkg = matcher.group(1);
                        String vc = matcher.group(2);
                        if (vc != null) {
                            vc = vc.replace("v", "");
                        }
                        if ((vn = matcher.group(3)) != null) {
                            vn = vn.replace("(", "").replace(")", "");
                        }
                        if (TextUtils.isEmpty((CharSequence)pkg)) break;
                        AppCrashCnt appCrashCnt = (AppCrashCnt)appCrashMap.get(pkg);
                        if (appCrashCnt != null) {
                            ++appCrashCnt.cnt;
                            break;
                        }
                        appCrashCnt = new AppCrashCnt(pkg, vn, vc, 1);
                        appCrashCnt.isSystem = DROPBOX_TAG_SYSTEM_APP_CRASH.equals(tag);
                        appCrashMap.put(pkg, appCrashCnt);
                        break;
                    }
                    entry.close();
                }
            }
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        DCSUtils.LOG.d((Object)("track crash count = " + appCrashMap.size()));
        PackageManager packageManager = this.mContext.getPackageManager();
        for (AppCrashCnt appCrashCnt : appCrashMap.values()) {
            Bundle eparam = new Bundle();
            eparam.putString("pkg", appCrashCnt.pkg);
            eparam.putString("vn", appCrashCnt.vn);
            eparam.putString("vc", appCrashCnt.vc);
            eparam.putInt("is_system", appCrashCnt.isSystem ? 1 : 0);
            try {
                String installerPkg = packageManager.getInstallerPackageName(appCrashCnt.pkg);
                eparam.putString("ch", installerPkg != null ? installerPkg : "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            eparam.putInt("cnt", appCrashCnt.cnt);
            eparam.putString("start_date", DCSUtils.transferMillisToDate("yyyy-MM-dd", startTime));
            new AthenaCust(EVENT_CRASH, 9999).trackCommon(eparam, null).submit();
        }
    }

    private class AppCrashCnt {
        String pkg;
        String vn;
        String vc;
        int cnt;
        boolean isSystem;

        private AppCrashCnt(String pkg, String vn, String vc, int cnt) {
            this.pkg = pkg;
            this.vn = vn;
            this.vc = vc;
            this.cnt = cnt;
        }
    }
}

