/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.track;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.athenacust.AthenaCust;
import com.transsion.dataservice.SubJob;
import com.transsion.dataservice.SubJobHolder;
import com.transsion.dataservice.provider.DCSConfigManager;
import com.transsion.dataservice.provider.DCSDataManager;
import com.transsion.dataservice.util.DCSUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public class GeneralSheetSubJob
extends SubJob {
    private static final String EVENT_TSID_CHANGE = "tsid_change";
    private static final String EVENT_TSID_BUILD = "tsid_build";
    private boolean isAppStart = true;

    public GeneralSheetSubJob(SubJobHolder holder, Context context) {
        super(holder, context);
    }

    @Override
    public void doJob() {
        DCSUtils.LOG.d((Object)"------- GeneralSheetSubJob doJob -------");
        DCSConfigManager.getInstance(this.mContext).updateWhiteList();
        this.buildOneIdIfNeeded();
        this.finish(true);
    }

    private void buildOneIdIfNeeded() {
        block14: {
            try {
                String oneid = DCSDataManager.getInstance().get("oneid");
                if (oneid != null && oneid.length() > 0) {
                    return;
                }
                int level = 0;
                String rawString = null;
                String hardware = DCSUtils.get(this.mContext, "ro.hardware");
                String chipId = DCSUtils.getCpuId(this.mContext, hardware);
                if (chipId != null && chipId.length() > 0) {
                    level = 0;
                    rawString = chipId;
                } else {
                    TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getApplicationContext().getSystemService("phone");
                    int phoneCount = Math.min(telephonyManager.getPhoneCount(), 2);
                    if (phoneCount > 0) {
                        ArrayList<String> imeis = new ArrayList<String>(phoneCount);
                        for (int i = 0; i < phoneCount; ++i) {
                            String imei = DCSUtils.getIMEI(i, false);
                            if (imei == null || imei.length() <= 0) continue;
                            imeis.add(imei);
                        }
                        if (phoneCount == imeis.size()) {
                            Collections.sort(imeis);
                            level = 1;
                            rawString = hardware + (String)imeis.get(0) + (phoneCount > 1 ? (String)imeis.get(1) : "");
                        }
                        if (!this.isAppStart) {
                            level = 2;
                            rawString = hardware + Build.MODEL + DCSUtils.getSerialNumber(false);
                            rawString = rawString.replace(" ", "").toLowerCase();
                        }
                    } else {
                        level = 2;
                        rawString = hardware + Build.MODEL + DCSUtils.getSerialNumber(false);
                        rawString = rawString.replace(" ", "").toLowerCase();
                    }
                    this.isAppStart = false;
                }
                DCSUtils.LOG.d((Object)("level = " + level + ", rawString = " + rawString));
                if (rawString == null) break block14;
                String encryptOneId = DCSUtils.shaEncrypt(rawString);
                File transFile = new File(this.mContext.getFilesDir(), ".transsion_id");
                String bufString = DCSUtils.readFile(transFile);
                if (TextUtils.isEmpty((CharSequence)bufString)) {
                    this.writeAndNotifyOneId(transFile, level, encryptOneId);
                    Bundle bundle = new Bundle();
                    bundle.putString("cid", encryptOneId);
                    bundle.putInt("cl", level);
                    bundle.putString("ver", "2.0.0.3");
                    new AthenaCust(EVENT_TSID_BUILD, 9999).trackCommon(bundle, null).submit();
                    break block14;
                }
                try {
                    String[] strings = bufString.split("-");
                    int preLevel = Integer.parseInt(strings[0]);
                    String preEncryptOneId = strings[1];
                    if (level < preLevel || level == preLevel && !TextUtils.equals((CharSequence)encryptOneId, (CharSequence)preEncryptOneId)) {
                        this.writeAndNotifyOneId(transFile, level, encryptOneId);
                        Bundle bundle = new Bundle();
                        bundle.putString("pid", preEncryptOneId);
                        bundle.putInt("pl", preLevel);
                        bundle.putString("cid", encryptOneId);
                        bundle.putInt("cl", level);
                        bundle.putString("ver", "2.0.0.3");
                        new AthenaCust(EVENT_TSID_CHANGE, 9999).trackCommon(bundle, null).submit();
                        break block14;
                    }
                    this.writeAndNotifyOneId(null, preLevel, preEncryptOneId);
                }
                catch (Exception e) {
                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                    this.writeAndNotifyOneId(transFile, level, encryptOneId);
                    Bundle bundle = new Bundle();
                    bundle.putString("cid", encryptOneId);
                    bundle.putInt("cl", level);
                    bundle.putString("ver", "2.0.0.3");
                    new AthenaCust(EVENT_TSID_BUILD, 9999).trackCommon(bundle, null).submit();
                }
            }
            catch (Exception e) {
                DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            }
        }
    }

    private void writeAndNotifyOneId(File file, int level, String encryptOneId) {
        if (file != null) {
            DCSUtils.writeFile(file, level + "-" + encryptOneId);
        }
        DCSDataManager.getInstance().set("oneid", encryptOneId);
        Uri uri = Uri.parse((String)"content://com.transsion.dataservice.provider/property");
        this.mContext.getContentResolver().notifyChange(uri, null);
    }
}

