/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.core.CoreUtil;
import com.transsion.core.log.ObjectLogUtils;
import com.transsion.core.utils.EncoderUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class DCSUtils {
    public static ObjectLogUtils LOG = new ObjectLogUtils.Builder().setGlobalTag("Athena_DCS").setLogHeadSwitch(true).setBorderSwitch(false).create();
    public static final long SECOND_IN_MILLIS = 1000L;
    public static final long MIN_IN_MILLIS = 60000L;
    public static final long HOUR_IN_MILLIS = 3600000L;
    public static final long DAY_IN_MILLIS = 86400000L;
    public static final long WEEK_IN_MILLIS = 604800000L;

    public static String transferMillisToDate(String dateFormat, long millsec) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, Locale.ENGLISH);
        Date date = new Date(millsec);
        return sdf.format(date);
    }

    public static String transferMillisToDate(long millsec) {
        return DCSUtils.transferMillisToDate("yyyy-MM-dd HH:mm:ss", millsec);
    }

    public static int transferMillisToMinute(long millsec) {
        return (int)(millsec / 1000L / 60L);
    }

    public static String toHexString(byte[] bytes) {
        StringBuffer md5str = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            int digital = bytes[i];
            if (digital < 0) {
                digital += 256;
            }
            if (digital < 16) {
                md5str.append("0");
            }
            md5str.append(Integer.toHexString(digital));
        }
        return md5str.toString().toUpperCase(Locale.getDefault());
    }

    public static String shaEncrypt(String strSrc) {
        MessageDigest md = null;
        String strDes = null;
        byte[] bt = strSrc.getBytes();
        try {
            md = MessageDigest.getInstance("SHA-256");
            md.update(bt);
            strDes = DCSUtils.bytes2Hex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        return strDes;
    }

    public static String bytes2Hex(byte[] bts) {
        String des = "";
        String tmp = null;
        for (int i = 0; i < bts.length; ++i) {
            tmp = Integer.toHexString(bts[i] & 0xFF);
            if (tmp.length() == 1) {
                des = des + "0";
            }
            des = des + tmp;
        }
        return des;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCpuName() {
        str1 = "/proc/cpuinfo";
        str2 = "";
        localBufferedReader = null;
        fr = null;
        try {
            fr = new FileReader(str1);
            localBufferedReader = new BufferedReader(fr);
            while ((str2 = localBufferedReader.readLine()) != null) {
                if (!str2.contains("Hardware")) continue;
                var4_4 = str2.split(":")[1];
                ** GOTO lbl27
            }
            ** GOTO lbl-1000
        }
        catch (IOException e) {
            try {
                DCSUtils.LOG.e("getCpuName error", new Object[]{e});
            }
            catch (Throwable var6_9) {
                try {
                    if (fr != null) {
                        fr.close();
                    }
                    if (localBufferedReader == null) throw var6_9;
                    localBufferedReader.close();
                    throw var6_9;
                }
                catch (IOException e) {
                    DCSUtils.LOG.e("getCpuName IOException", new Object[]{e});
                }
                throw var6_9;
            }
lbl27:
            // 1 sources

            try {
                if (fr != null) {
                    fr.close();
                }
                if (localBufferedReader == null) return var4_4;
                localBufferedReader.close();
                return var4_4;
            }
            catch (IOException e) {
                DCSUtils.LOG.e("getCpuName IOException", new Object[]{e});
            }
            return var4_4;
lbl-1000:
            // 1 sources

            {
                localBufferedReader.close();
            }
            try {
                if (fr != null) {
                    fr.close();
                }
                if (localBufferedReader == null) return null;
                localBufferedReader.close();
                return null;
            }
            catch (IOException e) {
                DCSUtils.LOG.e("getCpuName IOException", new Object[]{e});
                return null;
            }
            try {
                if (fr != null) {
                    fr.close();
                }
                if (localBufferedReader == null) return null;
                localBufferedReader.close();
                return null;
            }
            catch (IOException e) {
                DCSUtils.LOG.e("getCpuName IOException", new Object[]{e});
                return null;
            }
        }
    }

    public static long timeRemainingToday() {
        LocalTime midnight = LocalTime.MIDNIGHT;
        LocalDate today = LocalDate.now();
        LocalDateTime todayMidnight = LocalDateTime.of(today, midnight);
        LocalDateTime tomorrowMidnight = todayMidnight.plusDays(1L);
        long remaining = TimeUnit.NANOSECONDS.toMillis(Duration.between(LocalDateTime.now(), tomorrowMidnight).toNanos());
        return remaining;
    }

    public static String getTotalRAM(Context context) {
        try {
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
            manager.getMemoryInfo(info);
            return DCSUtils.formatFileSize(info.totalMem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    public static String formatFileSize(long size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if (size >= gb) {
            return String.format(Locale.ENGLISH, "%.1f GB", Float.valueOf((float)size / (float)gb));
        }
        if (size >= mb) {
            float f = (float)size / (float)mb;
            return String.format(Locale.ENGLISH, f > 100.0f ? "%.0f MB" : "%.1f MB", Float.valueOf(f));
        }
        if (size >= kb) {
            float f = (float)size / (float)kb;
            return String.format(Locale.ENGLISH, f > 100.0f ? "%.0f KB" : "%.1f KB", Float.valueOf(f));
        }
        return String.format(Locale.ENGLISH, "%d B", size);
    }

    public static long roundStorageSize(long size) {
        long val = 1L;
        long pow = 1L;
        while (val * pow < size) {
            if ((val <<= 1) <= 512L) continue;
            val = 1L;
            pow *= 1000L;
        }
        return val * pow;
    }

    public static String getTotalROM(Context context) {
        try {
            long totalBytes = DCSUtils.roundStorageSize(Environment.getDataDirectory().getTotalSpace() + Environment.getRootDirectory().getTotalSpace());
            return DCSUtils.formatFileSize(totalBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    public static String getBatteryCapacity(Context context) {
        double batteryCapacity = 0.0;
        String POWER_PROFILE_CLASS = "com.android.internal.os.PowerProfile";
        try {
            Object powerProfile = Class.forName("com.android.internal.os.PowerProfile").getConstructor(Context.class).newInstance(context);
            batteryCapacity = (Double)Class.forName("com.android.internal.os.PowerProfile").getMethod("getBatteryCapacity", new Class[0]).invoke(powerProfile, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(batteryCapacity + " mAh");
    }

    public static String getIMSI(int subId) {
        try {
            Context context = CoreUtil.getContext();
            TelephonyManager manager = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
            Method method = manager.getClass().getMethod("getSubscriberId", Integer.TYPE);
            String imsi = (String)method.invoke((Object)manager, subId);
            if (!TextUtils.isEmpty((CharSequence)imsi)) {
                return EncoderUtil.EncoderByAlgorithm((String)imsi);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getIMEI(int slotId) {
        return DCSUtils.getIMEI(slotId, true);
    }

    public static String getIMEI(int slotId, boolean encode) {
        try {
            Context context = CoreUtil.getContext();
            TelephonyManager manager = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
            Method method = manager.getClass().getMethod("getImei", Integer.TYPE);
            String imei = (String)method.invoke((Object)manager, slotId);
            if (TextUtils.isEmpty((CharSequence)imei)) {
                method = manager.getClass().getMethod("getDeviceId", Integer.TYPE);
                imei = (String)method.invoke((Object)manager, slotId);
            }
            if ("unknown".equalsIgnoreCase(imei)) {
                imei = "";
            }
            return TextUtils.isEmpty((CharSequence)imei) ? "" : (encode ? EncoderUtil.EncoderByAlgorithm((String)imei) : imei);
        }
        catch (Exception e) {
            LOG.e((Object)Log.getStackTraceString((Throwable)e));
            return "";
        }
    }

    public static String getOSVersion() {
        String osVersion = "";
        try {
            Class<?> cls = Class.forName("android.os.SystemProperties");
            Method method = cls.getMethod("get", String.class, String.class);
            osVersion = (String)method.invoke(null, "ro.tranos.version", "");
            if (TextUtils.isEmpty((CharSequence)osVersion)) {
                osVersion = (String)method.invoke(null, "ro.os_product.version", "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return osVersion;
    }

    public static String getCpuId(Context context, String hardware) {
        String ret = "";
        try {
            int cpuType = hardware.startsWith("mt") ? 1 : 2;
            Class<?> cls_activityManager = Class.forName("com.transsion.app.ActivityManager");
            Method instance = cls_activityManager.getMethod("instance", new Class[0]);
            Object activityManager = instance.invoke(null, new Object[0]);
            Method getCpuId = cls_activityManager.getMethod("getCpuId", Context.class, Integer.TYPE);
            ret = (String)getCpuId.invoke(activityManager, context, cpuType);
        }
        catch (Exception e) {
            String chipID = DCSUtils.readMtkChipID();
            return TextUtils.isEmpty((CharSequence)chipID) ? ret : hardware + chipID;
        }
        return ret;
    }

    public static String readMtkChipID() {
        StringBuilder builder = new StringBuilder();
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File("proc/rid"));
            byte[] re = new byte[1];
            while (in.read(re) != -1) {
                builder.append(DCSUtils.parseByte2HexStr(re));
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return builder.toString();
    }

    public static String parseByte2HexStr(byte[] buf) {
        if (buf == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static String getSerialNumber() {
        return DCSUtils.getSerialNumber(true);
    }

    public static String getSerialNumber(boolean encode) {
        String serialno = "";
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                serialno = Build.getSerial();
            }
            catch (Exception e) {
                serialno = "";
            }
        } else {
            serialno = Build.SERIAL;
        }
        try {
            if (TextUtils.isEmpty((CharSequence)serialno) || "unknown".equalsIgnoreCase(serialno)) {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method get = c.getMethod("get", String.class);
                serialno = (String)get.invoke(c, "ro.serialno");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ("unknown".equalsIgnoreCase(serialno)) {
            serialno = "";
        }
        return TextUtils.isEmpty((CharSequence)serialno) ? "" : (encode ? EncoderUtil.EncoderByAlgorithm((String)serialno) : serialno);
    }

    public static NetworkType getNetworkType(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (cm == null) {
            return NetworkType.NETWORK_NONE;
        }
        try {
            NetworkInfo.State state;
            NetworkInfo networkInfo = cm.getNetworkInfo(9);
            if (networkInfo != null && ((state = networkInfo.getState()) == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
                return NetworkType.NETWORK_ETHERNET;
            }
            networkInfo = cm.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isAvailable()) {
                if (networkInfo.getType() == 1) {
                    return NetworkType.NETWORK_WIFI;
                }
                if (networkInfo.getType() == 0) {
                    switch (networkInfo.getSubtype()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: 
                        case 16: {
                            return NetworkType.NETWORK_2G;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: 
                        case 17: {
                            return NetworkType.NETWORK_3G;
                        }
                        case 13: 
                        case 18: {
                            return NetworkType.NETWORK_4G;
                        }
                        case 20: {
                            return NetworkType.NETWORK_5G;
                        }
                    }
                    String subtypeName = networkInfo.getSubtypeName();
                    if (subtypeName.equalsIgnoreCase("TD-SCDMA") || subtypeName.equalsIgnoreCase("WCDMA") || subtypeName.equalsIgnoreCase("CDMA2000")) {
                        return NetworkType.NETWORK_3G;
                    }
                    return NetworkType.NETWORK_UNKNOWN;
                }
                return NetworkType.NETWORK_UNKNOWN;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return NetworkType.NETWORK_NONE;
    }

    public static String get(Context context, String key) throws IllegalArgumentException {
        String ret = "";
        try {
            ClassLoader cl = context.getClassLoader();
            Class<?> SystemProperties = cl.loadClass("android.os.SystemProperties");
            Class[] paramTypes = new Class[]{String.class};
            Method get = SystemProperties.getMethod("get", paramTypes);
            Object[] params = new Object[]{new String(key)};
            ret = (String)get.invoke(SystemProperties, params);
        }
        catch (IllegalArgumentException iAE) {
            throw iAE;
        }
        catch (Exception e) {
            ret = "";
        }
        return ret;
    }

    public static Long getLong(Context context, String key, long def) throws IllegalArgumentException {
        Long ret = def;
        try {
            ClassLoader cl = context.getClassLoader();
            Class<?> SystemProperties = cl.loadClass("android.os.SystemProperties");
            Class[] paramTypes = new Class[]{String.class, Long.TYPE};
            Method getLong = SystemProperties.getMethod("getLong", paramTypes);
            Object[] params = new Object[]{new String(key), new Long(def)};
            ret = (Long)getLong.invoke(SystemProperties, params);
        }
        catch (IllegalArgumentException iAE) {
            throw iAE;
        }
        catch (Exception e) {
            ret = def;
        }
        return ret;
    }

    public static boolean isSystemApp(String pkgName, PackageManager pm) {
        try {
            ApplicationInfo ai = pm.getApplicationInfo(pkgName, 8192);
            if ((ai.flags & 1) != 0) {
                return true;
            }
            String sourceDir = ai.sourceDir;
            return sourceDir != null && sourceDir.startsWith("/system/");
        }
        catch (PackageManager.NameNotFoundException e) {
            LOG.e("isSystemApp not found", new Object[]{e});
            return false;
        }
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeFileFromIS(File file, InputStream is, boolean append) {
        BufferedOutputStream os = null;
        int bufferSize = 10240;
        try {
            int len;
            os = new BufferedOutputStream(new FileOutputStream(file, append), bufferSize);
            byte[] data = new byte[bufferSize];
            while ((len = is.read(data)) != -1) {
                ((OutputStream)os).write(data, 0, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean moveFile(File srcFile, File destFile) {
        if (srcFile == null || destFile == null) {
            return false;
        }
        if (srcFile.equals(destFile)) {
            return false;
        }
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        try {
            return DCSUtils.writeFileFromIS(destFile, new FileInputStream(srcFile), true) && DCSUtils.deleteFile(srcFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) {
        FileInputStream fis = null;
        try {
            byte[] buffer;
            int len;
            if (file.exists() && (len = (fis = new FileInputStream(file)).read(buffer = new byte[128])) > 0) {
                String string = new String(buffer, 0, len, "UTF-8");
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String data) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(data.getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum NetworkType {
        NETWORK_NONE,
        NETWORK_WIFI,
        NETWORK_2G,
        NETWORK_3G,
        NETWORK_4G,
        NETWORK_5G,
        NETWORK_ETHERNET,
        NETWORK_UNKNOWN;

    }
}

