/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Bundle;
import android.os.SystemClock;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.athena.data.TrackData;
import com.transsion.athenacust.AthenaCust;
import com.transsion.dataservice.DCSModule;
import com.transsion.dataservice.util.DCSUtils;
import com.transsion.dataservice.util.DeviceStateUtils;
import com.transsion.ga.AthenaAnalytics;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class DCSReceiver
extends BroadcastReceiver {
    private static final String ACTION_SIM_STATE_CHANGED = "android.intent.action.SIM_STATE_CHANGED";
    private DCSUtils.NetworkType mLastNetworkType = DCSUtils.NetworkType.NETWORK_NONE;
    private long mLastConnectTime;
    private int mLastChargeState = 0;
    private long mLastChargeStartTime = 0L;
    private List<AppSnapshot> mAppSnapshotList = new ArrayList<AppSnapshot>();
    private int mLastHSPlugState = 0;
    private long mLastHSPlugStartTime = 0L;

    public DCSReceiver(Context context) {
        this.updateAppSnapshots(context);
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            AudioDeviceInfo[] deviceInfos = audioManager.getDevices(2);
            if (deviceInfos != null) {
                for (AudioDeviceInfo deviceInfo : deviceInfos) {
                    int type = deviceInfo.getType();
                    if (type != 3 && type != 4) continue;
                    this.mLastHSPlugState = 1;
                    this.mLastHSPlugStartTime = SystemClock.elapsedRealtime();
                }
            }
        }
        catch (Exception e) {
            DCSUtils.LOG.d((Object)Log.getStackTraceString((Throwable)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        DCSUtils.LOG.i((Object)("DCSReceiver onReceive action = " + action));
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
            DCSUtils.NetworkType networkType = DCSUtils.getNetworkType(context);
            long currentTimeMillis = System.currentTimeMillis();
            if (networkType != DCSUtils.NetworkType.NETWORK_NONE) {
                if (this.mLastNetworkType != DCSUtils.NetworkType.NETWORK_NONE && this.mLastNetworkType != networkType) {
                    if (currentTimeMillis < this.mLastConnectTime || currentTimeMillis - this.mLastConnectTime >= 604800000L) {
                        this.mLastNetworkType = networkType;
                        this.mLastConnectTime = currentTimeMillis;
                        return;
                    }
                    Bundle eparam = new Bundle();
                    eparam.putInt("net", this.mLastNetworkType.ordinal());
                    eparam.putString("start_hour", DCSUtils.transferMillisToDate("yyyy-MM-dd HH:mm", this.mLastConnectTime));
                    eparam.putLong("duration", currentTimeMillis - this.mLastConnectTime);
                    new AthenaCust("net_duration", 9999).trackCommon(eparam, null).submit();
                }
                this.mLastNetworkType = networkType;
                this.mLastConnectTime = currentTimeMillis;
                return;
            } else {
                if (this.mLastNetworkType == DCSUtils.NetworkType.NETWORK_NONE || this.mLastConnectTime == 0L) return;
                if (currentTimeMillis < this.mLastConnectTime || currentTimeMillis - this.mLastConnectTime >= 604800000L) {
                    this.mLastNetworkType = networkType;
                    this.mLastConnectTime = 0L;
                    return;
                }
                Bundle eparam = new Bundle();
                eparam.putInt("net", this.mLastNetworkType.ordinal());
                eparam.putString("start_hour", DCSUtils.transferMillisToDate("yyyy-MM-dd HH:mm", this.mLastConnectTime));
                eparam.putLong("duration", currentTimeMillis - this.mLastConnectTime);
                new AthenaCust("net_duration", 9999).trackCommon(eparam, null).submit();
                this.mLastNetworkType = networkType;
                this.mLastConnectTime = 0L;
            }
            return;
        }
        if ("android.intent.action.SCREEN_ON".equals(action)) {
            DeviceStateUtils.getInstance().recordScreenOn();
            return;
        }
        if ("android.intent.action.SCREEN_OFF".equals(action)) {
            DeviceStateUtils.getInstance().recordScreenOff();
            return;
        }
        if ("android.intent.action.BATTERY_CHANGED".equals(action)) {
            int status = intent.getIntExtra("status", 1);
            if (status == this.mLastChargeState) {
                return;
            }
            if (status == 2) {
                this.mLastChargeState = status;
                this.mLastChargeStartTime = SystemClock.elapsedRealtime();
                Bundle eparam = new Bundle();
                eparam.putInt("type", 1);
                int chargeType = 0;
                int plugged = intent.getIntExtra("plugged", 0);
                DCSUtils.LOG.d((Object)("status = " + status + ", plugged = " + plugged));
                switch (plugged) {
                    case 1: {
                        chargeType = 1;
                        break;
                    }
                    case 2: {
                        chargeType = 2;
                        break;
                    }
                    case 4: {
                        chargeType = 3;
                    }
                }
                eparam.putInt("ig", chargeType);
                int level = intent.getIntExtra("level", -1);
                int scale = intent.getIntExtra("scale", -1);
                int battery = level * 100 / scale;
                eparam.putString("ll", battery + "%");
                new AthenaCust("charge", 9999).trackCommon(eparam, null).submit();
                return;
            } else {
                if (this.mLastChargeState != 2 || this.mLastChargeStartTime == 0L) return;
                this.mLastChargeState = status;
                Bundle eparam = new Bundle();
                eparam.putInt("type", 2);
                int level = intent.getIntExtra("level", -1);
                int scale = intent.getIntExtra("scale", -1);
                int battery = level * 100 / scale;
                eparam.putString("ll", battery + "%");
                eparam.putLong("duration", SystemClock.elapsedRealtime() - this.mLastChargeStartTime);
                new AthenaCust("charge", 9999).trackCommon(eparam, null).submit();
            }
            return;
        }
        if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
            if (intent.getData() != null) {
                String pkgName = intent.getData().getSchemeSpecificPart();
                boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                if (replacing) {
                    return;
                }
                Bundle eparam = new Bundle();
                eparam.putString("pkg", pkgName);
                try {
                    PackageManager packageManager = context.getApplicationContext().getPackageManager();
                    PackageInfo packageInfo = packageManager.getPackageInfo(pkgName, 1);
                    eparam.putString("vn", packageInfo.versionName);
                    eparam.putString("vc", String.valueOf(packageInfo.versionCode));
                    String installerPkg = packageManager.getInstallerPackageName(pkgName);
                    eparam.putString("ch", installerPkg != null ? installerPkg : "");
                    eparam.putInt("is_system", DCSUtils.isSystemApp(pkgName, packageManager) ? 1 : 0);
                }
                catch (Exception e) {
                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
                new AthenaCust("install", 9999).trackCommon(eparam, null).submit();
            }
            this.updateAppSnapshots(context);
            return;
        }
        if ("android.intent.action.PACKAGE_FULLY_REMOVED".equals(action)) {
            if (intent.getData() == null) return;
            String pkgName = intent.getData().getSchemeSpecificPart();
            Bundle eparam = new Bundle();
            eparam.putString("pkg", pkgName);
            try {
                eparam.putString("vn", "");
                eparam.putString("vc", "");
                eparam.putString("ch", "");
                for (AppSnapshot appSnapshot : this.mAppSnapshotList) {
                    if (!TextUtils.equals((CharSequence)pkgName, (CharSequence)appSnapshot.packageName)) continue;
                    eparam.putString("vn", appSnapshot.versionName);
                    eparam.putString("vc", appSnapshot.versionCode);
                    eparam.putString("ch", appSnapshot.installer);
                    break;
                }
            }
            catch (Exception e) {
                DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            }
            eparam.putInt("is_system", 0);
            new AthenaCust("uninstall", 9999).trackCommon(eparam, null).submit();
            return;
        }
        if ("android.intent.action.PACKAGE_REPLACED".equals(action)) {
            if (intent.getData() != null) {
                String pkgName = intent.getData().getSchemeSpecificPart();
                Bundle eparam = new Bundle();
                eparam.putString("pkg", pkgName);
                try {
                    eparam.putString("pvn", "");
                    eparam.putString("pvc", "");
                    for (AppSnapshot appSnapshot : this.mAppSnapshotList) {
                        if (!TextUtils.equals((CharSequence)pkgName, (CharSequence)appSnapshot.packageName)) continue;
                        eparam.putString("pvn", appSnapshot.versionName);
                        eparam.putString("pvc", appSnapshot.versionCode);
                        break;
                    }
                    PackageManager packageManager = context.getApplicationContext().getPackageManager();
                    PackageInfo packageInfo = packageManager.getPackageInfo(pkgName, 1);
                    eparam.putString("cvn", packageInfo.versionName);
                    eparam.putString("cvc", String.valueOf(packageInfo.versionCode));
                    String installerPkg = packageManager.getInstallerPackageName(pkgName);
                    eparam.putString("ch", installerPkg != null ? installerPkg : "");
                }
                catch (Exception e) {
                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
                new AthenaCust("update", 9999).trackCommon(eparam, null).submit();
            }
            this.updateAppSnapshots(context);
            return;
        }
        if (ACTION_SIM_STATE_CHANGED.equals(action)) {
            try {
                SharedPreferences setting = DCSModule.getInstance().getSharedPreferences();
                if (!setting.getBoolean("track_first_boot_info_done", false)) {
                    return;
                }
                if (!"LOADED".equals(intent.getStringExtra("ss"))) return;
                int phone = intent.getIntExtra("phone", 0);
                SubscriptionManager subscriptionManager = (SubscriptionManager)context.getSystemService("telephony_subscription_service");
                List subscriptionInfos = subscriptionManager.getActiveSubscriptionInfoList();
                if (subscriptionInfos == null || subscriptionInfos.size() <= 0) return;
                for (SubscriptionInfo subscriptionInfo : subscriptionInfos) {
                    String key;
                    if (phone != subscriptionInfo.getSimSlotIndex()) continue;
                    String string = key = phone == 0 ? "track_first_boot_sim1" : "track_first_boot_sim2";
                    String imsi = DCSUtils.getIMSI(subscriptionInfo.getSubscriptionId());
                    if (TextUtils.isEmpty((CharSequence)imsi) || TextUtils.equals((CharSequence)imsi, (CharSequence)setting.getString(key, ""))) continue;
                    Bundle eparam = new Bundle();
                    eparam.putInt("yys", phone + 1);
                    if (subscriptionInfo.getMccString() != null && subscriptionInfo.getMncString() != null) {
                        eparam.putString("mcc", subscriptionInfo.getMccString());
                        eparam.putString("mnc", subscriptionInfo.getMncString());
                    } else {
                        try {
                            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                            Method method = TelephonyManager.class.getMethod("getSimOperatorNumeric", Integer.class);
                            String simOperator = (String)method.invoke((Object)telephonyManager, subscriptionInfo.getSubscriptionId());
                            if (!TextUtils.isEmpty((CharSequence)simOperator) && simOperator.length() > 3) {
                                eparam.putString("mcc", simOperator.substring(0, 3));
                                eparam.putString("mnc", simOperator.substring(3));
                            }
                        }
                        catch (Exception e) {
                            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                        }
                    }
                    if (eparam.containsKey("mcc") && eparam.containsKey("mnc")) {
                        new AthenaCust("operator", 9999).trackCommon(eparam, null).submit();
                    } else {
                        TrackData trackData = new TrackData().add("en", "operator", 2).add("cnt", 1, 1);
                        AthenaAnalytics.getInstance((int)9999).track("data_discard", trackData, 9999);
                    }
                    setting.edit().putString(key, imsi).apply();
                }
                return;
            }
            catch (Exception e) {
                DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                return;
            }
        }
        if ("android.bluetooth.device.action.BOND_STATE_CHANGED".equals(action)) {
            try {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                int state = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", -1);
                if (state != 12 || device == null) return;
                String major = "UNKNOWN";
                switch (device.getBluetoothClass().getMajorDeviceClass()) {
                    case 0: {
                        major = "MISC";
                        break;
                    }
                    case 256: {
                        major = "COMPUTER";
                        break;
                    }
                    case 512: {
                        major = "PHONE";
                        break;
                    }
                    case 768: {
                        major = "NETWORKING";
                        break;
                    }
                    case 1024: {
                        major = "AUDIO_VIDEO";
                        break;
                    }
                    case 1280: {
                        major = "PERIPHERAL";
                        break;
                    }
                    case 1536: {
                        major = "IMAGING";
                        break;
                    }
                    case 1792: {
                        major = "WEARABLE";
                        break;
                    }
                    case 2048: {
                        major = "TOY";
                        break;
                    }
                    case 2304: {
                        major = "HEALTH";
                        break;
                    }
                    case 7936: {
                        major = "UNCATEGORIZED";
                    }
                }
                BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
                if (TextUtils.isEmpty((CharSequence)device.getAddress()) || adapter == null) {
                    TrackData trackData = new TrackData().add("en", "bluetooth", 2).add("cnt", 1, 1);
                    AthenaAnalytics.getInstance((int)9999).track("data_discard", trackData, 9999);
                    return;
                }
                String hexString = Integer.toHexString(device.getBluetoothClass().getDeviceClass());
                if (!hexString.startsWith("0x")) {
                    hexString = (hexString.length() % 2 == 0 ? "0x" : "0x0") + hexString;
                }
                Bundle eparam = new Bundle();
                eparam.putString("wldz", device.getAddress());
                eparam.putString("lylx", adapter.getAddress());
                eparam.putString("type", major);
                eparam.putString("cod", hexString);
                new AthenaCust("bluetooth", 9999).trackCommon(eparam, null).submit();
                return;
            }
            catch (Exception e) {
                DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            }
            return;
        }
        if ("android.intent.action.HEADSET_PLUG".equals(action)) {
            if (!intent.hasExtra("state")) return;
            int state = intent.getIntExtra("state", 0);
            if (state == 0) {
                if (this.mLastHSPlugState != 1) return;
                long duration = SystemClock.elapsedRealtime() - this.mLastHSPlugStartTime;
                if (duration >= 3000L) {
                    Bundle eparam = new Bundle();
                    eparam.putLong("dur", duration);
                    new AthenaCust("earphone", 9999).trackCommon(eparam, null).submit();
                }
                this.mLastHSPlugState = 0;
                return;
            } else {
                if (state != 1) return;
                this.mLastHSPlugState = 1;
                this.mLastHSPlugStartTime = SystemClock.elapsedRealtime();
            }
            return;
        } else {
            Bundle eparam;
            if (!"android.intent.action.ACTION_SHUTDOWN".equals(action)) return;
            if (this.mLastHSPlugState == 1) {
                long duration = SystemClock.elapsedRealtime() - this.mLastHSPlugStartTime;
                if (duration >= 3000L) {
                    eparam = new Bundle();
                    eparam.putLong("dur", duration);
                    new AthenaCust("earphone", 9999).trackCommon(eparam, null).submit();
                }
                this.mLastHSPlugState = 0;
            }
            if (this.mLastNetworkType == DCSUtils.NetworkType.NETWORK_NONE || this.mLastConnectTime == 0L) return;
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis < this.mLastConnectTime || currentTimeMillis - this.mLastConnectTime >= 604800000L) {
                return;
            }
            eparam = new Bundle();
            eparam.putInt("net", this.mLastNetworkType.ordinal());
            eparam.putString("start_hour", DCSUtils.transferMillisToDate("yyyy-MM-dd HH:mm", this.mLastConnectTime));
            eparam.putLong("duration", currentTimeMillis - this.mLastConnectTime);
            new AthenaCust("net_duration", 9999).trackCommon(eparam, null).submit();
            this.mLastNetworkType = DCSUtils.NetworkType.NETWORK_NONE;
            this.mLastConnectTime = 0L;
        }
    }

    private void updateAppSnapshots(Context context) {
        try {
            this.mAppSnapshotList.clear();
            PackageManager pm = context.getPackageManager();
            List packages = pm.getInstalledPackages(0);
            for (PackageInfo pi : packages) {
                if (DCSUtils.isSystemApp(pi.packageName, pm)) continue;
                String installer = pm.getInstallerPackageName(pi.packageName);
                if (installer == null) {
                    installer = "";
                }
                this.mAppSnapshotList.add(new AppSnapshot(pi.packageName, pi.versionName, String.valueOf(pi.versionCode), installer));
            }
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
    }

    private class AppSnapshot {
        String packageName;
        String versionName;
        String versionCode;
        String installer;

        AppSnapshot(String packageName, String versionName, String versionCode, String installer) {
            this.packageName = packageName;
            this.versionName = versionName;
            this.versionCode = versionCode;
            this.installer = installer;
        }
    }
}

