/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.binder;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.transsion.dataservice.provider.DCSConfigManager;
import com.transsion.dataservice.provider.DCSDataManager;
import com.transsion.dataservice.util.DCSUtils;
import java.io.File;

public class DCService
extends Service {
    private static final int MSG_GET_PROP = 100;
    private Context mContext;
    private HandlerThread mHandlerThread;
    private Messenger mMessenger;

    public void onCreate() {
        this.mContext = this.getApplicationContext();
        this.mHandlerThread = new HandlerThread("DCS");
        this.mHandlerThread.start();
        this.mMessenger = new Messenger((Handler)new IOHandler(this.mHandlerThread.getLooper()));
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.mMessenger.getBinder();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quitSafely();
        }
    }

    private class IOHandler
    extends Handler {
        private IOHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            if (msg.what == 100) {
                String value = null;
                try {
                    String bufString;
                    String key = msg.getData().getString("key");
                    String packageName = DCService.this.mContext.getPackageManager().getNameForUid(msg.sendingUid);
                    int authority = DCSConfigManager.getInstance(DCService.this.mContext).authorize(packageName);
                    DCSUtils.LOG.d((Object)("packageName = " + packageName + " authority = " + authority + " key = " + key));
                    if (authority == 1 && TextUtils.isEmpty((CharSequence)(value = DCSDataManager.getInstance().get(key))) && "oneid".equals(key) && !TextUtils.isEmpty((CharSequence)(bufString = DCSUtils.readFile(new File(DCService.this.mContext.getFilesDir(), ".transsion_id"))))) {
                        value = bufString.split("-")[1];
                    }
                    Message msgTo = new Message();
                    msgTo.what = 100;
                    Bundle data = new Bundle();
                    data.putString(key, value);
                    msgTo.setData(data);
                    msg.replyTo.send(msgTo);
                }
                catch (Exception e) {
                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
            }
        }
    }
}

