/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.provider;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.dataservice.DCSModule;
import com.transsion.dataservice.http.HttpUtils;
import com.transsion.dataservice.util.DCSUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class DCSConfigManager {
    private static final String KEY_DCS_APP_LIST = "dcs_app_list";
    private static final String KEY_DCS_APP_LIST2 = "dcs_app_list2";
    private static DCSConfigManager sInstance;
    private final Context mContext;
    private long mVersion;
    private long mPullDuration;
    private long mNextPullTime;
    private final List<String> mAuthorizePkgs = new CopyOnWriteArrayList<String>();
    private final Map<String, Long> mPeriodMap = new ConcurrentHashMap<String, Long>();
    private long mVersion2;
    private long mPullDuration2;
    private long mNextPullTime2;
    private final List<String> mAuthorizePkgs2 = new CopyOnWriteArrayList<String>();

    public static DCSConfigManager getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new DCSConfigManager(context);
        }
        return sInstance;
    }

    private DCSConfigManager(Context context) {
        String localConfig2;
        this.mContext = context;
        SharedPreferences setting = DCSModule.getInstance().getSharedPreferences();
        String localConfig = setting.getString(KEY_DCS_APP_LIST, "");
        if (!TextUtils.isEmpty((CharSequence)localConfig)) {
            this.updateServerConfig(localConfig, context);
        }
        if (TextUtils.isEmpty((CharSequence)(localConfig2 = setting.getString(KEY_DCS_APP_LIST2, "")))) {
            this.mAuthorizePkgs2.add("com.android.settings");
            this.mAuthorizePkgs2.add("com.android.systemui");
            this.mAuthorizePkgs2.add("com.transsion.calculator");
        } else {
            this.updateServerConfig2(localConfig2, context);
        }
    }

    public int authorize(String pkgName) {
        if (this.mAuthorizePkgs.contains(pkgName)) {
            return 1;
        }
        return this.mVersion == 0L ? 0 : 2;
    }

    public int authorize2(String pkgName) {
        if (this.mAuthorizePkgs2.contains(pkgName)) {
            return 1;
        }
        return this.mVersion2 == 0L ? 0 : 2;
    }

    private boolean isExpired() {
        if (this.mNextPullTime == 0L || this.mPullDuration == 0L) {
            return true;
        }
        return Math.abs(System.currentTimeMillis() - this.mNextPullTime) >= this.mPullDuration;
    }

    private boolean isExpired2() {
        if (this.mNextPullTime2 == 0L || this.mPullDuration2 == 0L) {
            return true;
        }
        return Math.abs(System.currentTimeMillis() - this.mNextPullTime2) >= this.mPullDuration2;
    }

    public long getPeriod(String key, long defValue) {
        Long period = this.mPeriodMap.get(key);
        return period != null ? period : defValue;
    }

    private void updateServerConfig(String serverConfig, Context context) {
        try {
            DCSUtils.LOG.d((Object)("serverConfig = " + serverConfig));
            if (TextUtils.isEmpty((CharSequence)serverConfig)) {
                return;
            }
            if ("{}".equals(serverConfig)) {
                SharedPreferences setting = DCSModule.getInstance().getSharedPreferences();
                String localConfig = setting.getString(KEY_DCS_APP_LIST, "");
                if (!TextUtils.isEmpty((CharSequence)localConfig)) {
                    this.mNextPullTime = System.currentTimeMillis() + this.mPullDuration;
                    JSONObject jsonObject = new JSONObject(localConfig);
                    jsonObject.put("npt", this.mNextPullTime);
                    setting.edit().putString(KEY_DCS_APP_LIST, jsonObject.toString()).apply();
                }
                return;
            }
            JSONObject jsonObject = new JSONObject(serverConfig);
            if (jsonObject.has("data")) {
                this.mAuthorizePkgs.clear();
                JSONArray pkgJArray = jsonObject.getJSONArray("data");
                for (int i = 0; i < pkgJArray.length(); ++i) {
                    this.mAuthorizePkgs.add(pkgJArray.getString(i));
                }
            }
            if (jsonObject.has("period")) {
                JSONObject periodJs = jsonObject.getJSONObject("period");
                Iterator iterator = periodJs.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    this.mPeriodMap.put(key, (long)periodJs.optInt(key) * 3600000L);
                }
            }
            this.mVersion = jsonObject.optLong("ver");
            this.mPullDuration = (long)jsonObject.optInt("pd") * 3600000L;
            if (jsonObject.has("npt")) {
                this.mNextPullTime = jsonObject.optLong("npt");
            } else {
                this.mNextPullTime = System.currentTimeMillis() + this.mPullDuration;
                jsonObject.put("npt", this.mNextPullTime);
                SharedPreferences setting = DCSModule.getInstance().getSharedPreferences();
                setting.edit().putString(KEY_DCS_APP_LIST, jsonObject.toString()).apply();
            }
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
    }

    private void updateServerConfig2(String serverConfig, Context context) {
        try {
            DCSUtils.LOG.d((Object)("serverConfig = " + serverConfig));
            if (TextUtils.isEmpty((CharSequence)serverConfig)) {
                return;
            }
            if ("{}".equals(serverConfig)) {
                SharedPreferences setting = context.getSharedPreferences("shared_preference_of_dcs", 0);
                String localConfig = setting.getString(KEY_DCS_APP_LIST2, "");
                if (!TextUtils.isEmpty((CharSequence)localConfig)) {
                    this.mNextPullTime2 = System.currentTimeMillis() + this.mPullDuration2;
                    JSONObject jsonObject = new JSONObject(localConfig);
                    jsonObject.put("npt", this.mNextPullTime2);
                    setting.edit().putString(KEY_DCS_APP_LIST2, jsonObject.toString()).apply();
                }
                return;
            }
            JSONObject jsonObject = new JSONObject(serverConfig);
            if (jsonObject.has("data")) {
                this.mAuthorizePkgs2.clear();
                JSONArray pkgJArray = jsonObject.getJSONArray("data");
                for (int i = 0; i < pkgJArray.length(); ++i) {
                    this.mAuthorizePkgs2.add(pkgJArray.getString(i));
                }
            }
            if (jsonObject.has("period")) {
                JSONObject periodJs = jsonObject.getJSONObject("period");
                Iterator iterator = periodJs.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    this.mPeriodMap.put(key, (long)periodJs.optInt(key) * 3600000L);
                }
            }
            this.mVersion2 = jsonObject.optLong("ver");
            this.mPullDuration2 = (long)jsonObject.optInt("pd") * 3600000L;
            if (jsonObject.has("npt")) {
                this.mNextPullTime2 = jsonObject.optLong("npt");
            } else {
                this.mNextPullTime2 = System.currentTimeMillis() + this.mPullDuration2;
                jsonObject.put("npt", this.mNextPullTime2);
                SharedPreferences setting = context.getSharedPreferences("shared_preference_of_dcs", 0);
                setting.edit().putString(KEY_DCS_APP_LIST2, jsonObject.toString()).apply();
            }
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
    }

    public void updateWhiteList() {
        String response;
        String url;
        boolean isTestMode;
        if (this.isExpired()) {
            isTestMode = DCSModule.getInstance().isTestMode();
            url = isTestMode ? "https://ds-test.shalltry.com/logconf/v1/tsidlist" : "https://ds.shalltry.com/logconf/v1/tsidlist";
            try {
                response = HttpUtils.doPost(url, "", this.mVersion);
                this.updateServerConfig(response, this.mContext);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.isExpired2()) {
            isTestMode = DCSModule.getInstance().isTestMode();
            url = isTestMode ? "https://ds-test.shalltry.com/logconf/v1/secret" : "https://ds.shalltry.com/logconf/v1/secret";
            try {
                response = HttpUtils.doPost(url, "", this.mVersion2);
                this.updateServerConfig2(response, this.mContext);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

