/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.track;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import com.transsion.athenacust.AthenaCust;
import com.transsion.dataservice.PeriodicSubJob;
import com.transsion.dataservice.SubJobHolder;
import com.transsion.dataservice.util.DCSUtils;
import java.util.ArrayList;
import java.util.List;

public class NAppListSubJob
extends PeriodicSubJob {
    public static final String EVENT_NAPP = "napp_list";
    public static final long PERIOD_OF_APP_LIST = 604800000L;

    public NAppListSubJob(SubJobHolder holder, Context context) {
        super(holder, context, 604800000L, "napplist");
    }

    public NAppListSubJob(SubJobHolder holder, Context context, long period) {
        super(holder, context, period, "napplist");
    }

    @Override
    public void doJob() {
        DCSUtils.LOG.d((Object)"------- NAppListSubJob doJob -------");
        PackageManager pm = this.mContext.getPackageManager();
        ArrayList<Bundle> eparam = new ArrayList<Bundle>();
        Bundle ext = null;
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        List packageInfos = pm.queryIntentActivities(intent, 0);
        ArrayList<String> iconAppList = new ArrayList<String>();
        for (int i = 0; i < packageInfos.size(); ++i) {
            iconAppList.add(((ResolveInfo)packageInfos.get((int)i)).activityInfo.packageName);
        }
        List apps = pm.getInstalledApplications(8704);
        for (int i = 0; i < apps.size(); ++i) {
            String packageName = ((ApplicationInfo)apps.get((int)i)).packageName;
            if (iconAppList.contains(packageName)) continue;
            PackageInfo pi = null;
            try {
                pi = pm.getPackageInfo(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            Bundle bundle = new Bundle();
            bundle.putString("pkg", packageName);
            bundle.putString("vn", pi != null ? pi.versionName : "0");
            bundle.putString("vc", pi != null ? String.valueOf(pi.versionCode) : "0");
            try {
                String installerPkg = pm.getInstallerPackageName(packageName);
                bundle.putString("ch", installerPkg != null ? installerPkg : "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            bundle.putInt("is_system", DCSUtils.isSystemApp(packageName, pm) ? 1 : 0);
            eparam.add(bundle);
        }
        if (eparam.size() <= 3000) {
            new AthenaCust(EVENT_NAPP, 9999).trackCommon(eparam, ext).submit();
        }
        this.finish(true);
    }
}

