/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.util;

import android.support.annotation.NonNull;
import com.transsion.dataservice.util.DCSUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DeviceStateUtils {
    private static DeviceStateUtils sDeviceStateUtils;
    private long mLastScreenOnTime;
    private List<ScreenOnOff> mScreenOnOffList = new CopyOnWriteArrayList<ScreenOnOff>();

    private DeviceStateUtils() {
        this.mLastScreenOnTime = System.currentTimeMillis();
    }

    public static DeviceStateUtils getInstance() {
        if (sDeviceStateUtils == null) {
            sDeviceStateUtils = new DeviceStateUtils();
        }
        return sDeviceStateUtils;
    }

    public void recordScreenOn() {
        this.mLastScreenOnTime = System.currentTimeMillis();
    }

    public void recordScreenOff() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis <= this.mLastScreenOnTime || currentTimeMillis - this.mLastScreenOnTime > 86400000L) {
            DCSUtils.LOG.d((Object)("screenOn = " + DCSUtils.transferMillisToDate(this.mLastScreenOnTime) + ",screenOff = " + DCSUtils.transferMillisToDate(currentTimeMillis)));
            this.mScreenOnOffList.clear();
            this.mLastScreenOnTime = 0L;
        } else {
            this.mScreenOnOffList.add(new ScreenOnOff(this.mLastScreenOnTime, currentTimeMillis));
            this.mLastScreenOnTime = 0L;
        }
    }

    public List<ScreenOnOff> queryScreenOnOff(long startTime, long endTime) {
        if (this.mLastScreenOnTime > 0L && this.mLastScreenOnTime < endTime) {
            long currentTimeMillis = System.currentTimeMillis();
            this.mScreenOnOffList.add(new ScreenOnOff(this.mLastScreenOnTime, currentTimeMillis));
            this.mLastScreenOnTime = currentTimeMillis;
        }
        if (this.mScreenOnOffList.size() == 0) {
            return null;
        }
        ArrayList<ScreenOnOff> screenOnOffs = new ArrayList<ScreenOnOff>();
        for (ScreenOnOff screenOnOff : this.mScreenOnOffList) {
            if (screenOnOff.on <= startTime && screenOnOff.off >= endTime) {
                screenOnOffs.add(screenOnOff);
                break;
            }
            if ((screenOnOff.on < startTime || screenOnOff.on >= endTime) && (screenOnOff.off <= startTime || screenOnOff.off > endTime)) continue;
            screenOnOffs.add(screenOnOff);
        }
        return screenOnOffs;
    }

    public void trimScreenOnOff(long expireTime) {
        if (this.mScreenOnOffList.size() == 0) {
            return;
        }
        DCSUtils.LOG.d((Object)("before trim screenOnOff size = " + this.mScreenOnOffList.size()));
        for (ScreenOnOff screenOnOff : this.mScreenOnOffList) {
            if (screenOnOff.off > expireTime) continue;
            this.mScreenOnOffList.remove(screenOnOff);
        }
        DCSUtils.LOG.d((Object)("after trim screenOnOff size = " + this.mScreenOnOffList.size()));
    }

    public static class ScreenOnOff {
        public long on;
        public long off;

        ScreenOnOff(long on, long off) {
            this.on = on;
            this.off = off;
        }

        @NonNull
        public String toString() {
            return DCSUtils.transferMillisToDate(this.on) + "-" + DCSUtils.transferMillisToDate(this.off);
        }
    }
}

