/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Bundle;
import android.os.SystemClock;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.athena.data.TrackData;
import com.transsion.athenacust.AthenaCust;
import com.transsion.dataservice.DCSModule;
import com.transsion.dataservice.util.DCSUtils;
import com.transsion.dataservice.util.DeviceStateUtils;
import com.transsion.dataservice.util.ThreadUtils;
import com.transsion.ga.AthenaAnalytics;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class DCSReceiver
extends BroadcastReceiver {
    private static final String ACTION_SIM_STATE_CHANGED = "android.intent.action.SIM_STATE_CHANGED";
    private DCSUtils.NetworkType mLastNetworkType = DCSUtils.NetworkType.NETWORK_NONE;
    private long mLastConnectTime;
    private int mLastChargeState = 0;
    private long mLastChargeStartTime = 0L;
    private final List<AppSnapshot> mAppSnapshotList = new ArrayList<AppSnapshot>();
    private int mLastHSPlugState = 0;
    private long mLastHSPlugStartTime = 0L;
    private boolean mChargeDone = false;

    public DCSReceiver(final Context context) {
        ThreadUtils.postOnBackgroundThread(new Runnable(){

            @Override
            public void run() {
                DCSReceiver.this.updateAppSnapshots(context);
                try {
                    AudioManager audioManager = (AudioManager)context.getSystemService("audio");
                    AudioDeviceInfo[] deviceInfos = audioManager.getDevices(2);
                    if (deviceInfos != null) {
                        for (AudioDeviceInfo deviceInfo : deviceInfos) {
                            int type = deviceInfo.getType();
                            if (type != 3 && type != 4) continue;
                            DCSReceiver.this.mLastHSPlugState = 1;
                            DCSReceiver.this.mLastHSPlugStartTime = SystemClock.elapsedRealtime();
                        }
                    }
                }
                catch (Exception e) {
                    DCSUtils.LOG.d((Object)Log.getStackTraceString((Throwable)e));
                }
            }
        });
    }

    public void onReceive(final Context context, final Intent intent) {
        ThreadUtils.postOnBackgroundThread(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                String action = intent.getAction();
                DCSUtils.LOG.i((Object)("DCSReceiver onReceive action = " + action));
                if ("android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
                    DCSUtils.NetworkType networkType = DCSUtils.getNetworkType(context);
                    long currentTimeMillis = System.currentTimeMillis();
                    if (networkType != DCSUtils.NetworkType.NETWORK_NONE) {
                        if (DCSReceiver.this.mLastNetworkType != DCSUtils.NetworkType.NETWORK_NONE && DCSReceiver.this.mLastNetworkType != networkType) {
                            if (currentTimeMillis < DCSReceiver.this.mLastConnectTime || currentTimeMillis - DCSReceiver.this.mLastConnectTime >= 604800000L) {
                                DCSReceiver.this.mLastNetworkType = networkType;
                                DCSReceiver.this.mLastConnectTime = currentTimeMillis;
                                return;
                            }
                            Bundle eparam = new Bundle();
                            eparam.putInt("net", DCSReceiver.this.mLastNetworkType.ordinal());
                            eparam.putString("start_hour", DCSUtils.transferMillisToDate("yyyy-MM-dd HH:mm", DCSReceiver.this.mLastConnectTime));
                            eparam.putLong("duration", currentTimeMillis - DCSReceiver.this.mLastConnectTime);
                            new AthenaCust("net_duration", 9999).trackCommon(eparam, null).submit();
                        }
                        DCSReceiver.this.mLastNetworkType = networkType;
                        DCSReceiver.this.mLastConnectTime = currentTimeMillis;
                        return;
                    } else {
                        if (DCSReceiver.this.mLastNetworkType == DCSUtils.NetworkType.NETWORK_NONE || DCSReceiver.this.mLastConnectTime == 0L) return;
                        if (currentTimeMillis < DCSReceiver.this.mLastConnectTime || currentTimeMillis - DCSReceiver.this.mLastConnectTime >= 604800000L) {
                            DCSReceiver.this.mLastNetworkType = networkType;
                            DCSReceiver.this.mLastConnectTime = 0L;
                            return;
                        }
                        Bundle eparam = new Bundle();
                        eparam.putInt("net", DCSReceiver.this.mLastNetworkType.ordinal());
                        eparam.putString("start_hour", DCSUtils.transferMillisToDate("yyyy-MM-dd HH:mm", DCSReceiver.this.mLastConnectTime));
                        eparam.putLong("duration", currentTimeMillis - DCSReceiver.this.mLastConnectTime);
                        new AthenaCust("net_duration", 9999).trackCommon(eparam, null).submit();
                        DCSReceiver.this.mLastNetworkType = networkType;
                        DCSReceiver.this.mLastConnectTime = 0L;
                    }
                    return;
                }
                if ("android.intent.action.SCREEN_ON".equals(action)) {
                    DeviceStateUtils.getInstance().recordScreenOn();
                    return;
                }
                if ("android.intent.action.SCREEN_OFF".equals(action)) {
                    DeviceStateUtils.getInstance().recordScreenOff();
                    return;
                }
                if ("android.intent.action.BATTERY_CHANGED".equals(action)) {
                    int status = intent.getIntExtra("status", 1);
                    float temperature = (float)intent.getIntExtra("temperature", 0) / 10.0f;
                    int level = intent.getIntExtra("level", -1);
                    int scale = intent.getIntExtra("scale", -1);
                    int chargeType = 0;
                    int plugged = intent.getIntExtra("plugged", 0);
                    switch (plugged) {
                        case 1: {
                            chargeType = 1;
                            break;
                        }
                        case 2: {
                            chargeType = 2;
                            break;
                        }
                        case 4: {
                            chargeType = 3;
                        }
                    }
                    if (level < scale && DCSReceiver.this.mChargeDone) {
                        DCSReceiver.this.mChargeDone = false;
                    }
                    if (!(DCSReceiver.this.mChargeDone || level < scale || status != 2 && status != 5)) {
                        DCSReceiver.this.mChargeDone = true;
                        Bundle eparam = new Bundle();
                        eparam.putInt("ll", level);
                        eparam.putFloat("temp", temperature);
                        eparam.putInt("ig", chargeType);
                        eparam.putInt("type", 3);
                        new AthenaCust("charge", 9999).trackCommon(eparam, null).submit();
                        return;
                    }
                    if (status == DCSReceiver.this.mLastChargeState) {
                        return;
                    }
                    DCSUtils.LOG.d((Object)("action = " + action + " status = " + status));
                    if (status == 2) {
                        DCSReceiver.this.mLastChargeState = status;
                        DCSReceiver.this.mLastChargeStartTime = SystemClock.elapsedRealtime();
                        DCSUtils.LOG.d((Object)("status = " + status + ", plugged = " + plugged));
                        Bundle eparam = new Bundle();
                        eparam.putFloat("temp", temperature);
                        eparam.putInt("type", 1);
                        eparam.putInt("ig", chargeType);
                        int battery = level * 100 / scale;
                        eparam.putString("ll", battery + "%");
                        new AthenaCust("charge", 9999).trackCommon(eparam, null).submit();
                        return;
                    } else {
                        if (DCSReceiver.this.mLastChargeState != 2 || DCSReceiver.this.mLastChargeStartTime == 0L) return;
                        DCSReceiver.this.mLastChargeState = status;
                        Bundle eparam = new Bundle();
                        eparam.putFloat("temp", temperature);
                        eparam.putInt("type", 2);
                        int battery = level * 100 / scale;
                        eparam.putString("ll", battery + "%");
                        eparam.putLong("duration", SystemClock.elapsedRealtime() - DCSReceiver.this.mLastChargeStartTime);
                        new AthenaCust("charge", 9999).trackCommon(eparam, null).submit();
                    }
                    return;
                }
                if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
                    if (intent.getData() != null) {
                        String pkgName = intent.getData().getSchemeSpecificPart();
                        boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                        if (replacing) {
                            return;
                        }
                        Bundle eparam = new Bundle();
                        eparam.putString("pkg", pkgName);
                        try {
                            PackageManager packageManager = context.getApplicationContext().getPackageManager();
                            PackageInfo packageInfo = packageManager.getPackageInfo(pkgName, 1);
                            eparam.putString("vn", packageInfo.versionName);
                            eparam.putString("vc", String.valueOf(packageInfo.versionCode));
                            String installerPkg = packageManager.getInstallerPackageName(pkgName);
                            eparam.putString("ch", installerPkg != null ? installerPkg : "");
                            eparam.putInt("is_system", DCSUtils.isSystemApp(pkgName, packageManager) ? 1 : 0);
                        }
                        catch (Exception e) {
                            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                        }
                        new AthenaCust("install", 9999).trackCommon(eparam, null).submit();
                    }
                    DCSReceiver.this.updateAppSnapshots(context);
                    return;
                }
                if ("android.intent.action.PACKAGE_FULLY_REMOVED".equals(action)) {
                    if (intent.getData() == null) return;
                    String pkgName = intent.getData().getSchemeSpecificPart();
                    Bundle eparam = new Bundle();
                    eparam.putString("pkg", pkgName);
                    try {
                        eparam.putString("vn", "");
                        eparam.putString("vc", "");
                        eparam.putString("ch", "");
                        for (AppSnapshot appSnapshot : DCSReceiver.this.mAppSnapshotList) {
                            if (!TextUtils.equals((CharSequence)pkgName, (CharSequence)appSnapshot.packageName)) continue;
                            eparam.putString("vn", appSnapshot.versionName);
                            eparam.putString("vc", appSnapshot.versionCode);
                            eparam.putString("ch", appSnapshot.installer);
                            break;
                        }
                    }
                    catch (Exception e) {
                        DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                    }
                    eparam.putInt("is_system", 0);
                    new AthenaCust("uninstall", 9999).trackCommon(eparam, null).submit();
                    return;
                }
                if ("android.intent.action.PACKAGE_REPLACED".equals(action)) {
                    if (intent.getData() != null) {
                        String pkgName = intent.getData().getSchemeSpecificPart();
                        Bundle eparam = new Bundle();
                        eparam.putString("pkg", pkgName);
                        try {
                            eparam.putString("pvn", "");
                            eparam.putString("pvc", "");
                            for (AppSnapshot appSnapshot : DCSReceiver.this.mAppSnapshotList) {
                                if (!TextUtils.equals((CharSequence)pkgName, (CharSequence)appSnapshot.packageName)) continue;
                                eparam.putString("pvn", appSnapshot.versionName);
                                eparam.putString("pvc", appSnapshot.versionCode);
                                break;
                            }
                            PackageManager packageManager = context.getApplicationContext().getPackageManager();
                            PackageInfo packageInfo = packageManager.getPackageInfo(pkgName, 1);
                            eparam.putString("cvn", packageInfo.versionName);
                            eparam.putString("cvc", String.valueOf(packageInfo.versionCode));
                            String installerPkg = packageManager.getInstallerPackageName(pkgName);
                            eparam.putString("ch", installerPkg != null ? installerPkg : "");
                        }
                        catch (Exception e) {
                            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                        }
                        new AthenaCust("update", 9999).trackCommon(eparam, null).submit();
                    }
                    DCSReceiver.this.updateAppSnapshots(context);
                    return;
                }
                if (DCSReceiver.ACTION_SIM_STATE_CHANGED.equals(action)) {
                    try {
                        SharedPreferences setting = DCSModule.getInstance().getSharedPreferences();
                        if (!setting.getBoolean("track_first_boot_info_done", false)) {
                            return;
                        }
                        if (!"LOADED".equals(intent.getStringExtra("ss"))) return;
                        int phone = intent.getIntExtra("phone", 0);
                        SubscriptionManager subscriptionManager = (SubscriptionManager)context.getSystemService("telephony_subscription_service");
                        List subscriptionInfos = subscriptionManager.getActiveSubscriptionInfoList();
                        if (subscriptionInfos == null || subscriptionInfos.size() <= 0) return;
                        for (SubscriptionInfo subscriptionInfo : subscriptionInfos) {
                            String key;
                            if (phone != subscriptionInfo.getSimSlotIndex()) continue;
                            String string = key = phone == 0 ? "track_first_boot_sim1" : "track_first_boot_sim2";
                            String imsi = DCSUtils.getIMSI(subscriptionInfo.getSubscriptionId());
                            if (TextUtils.isEmpty((CharSequence)imsi) || TextUtils.equals((CharSequence)imsi, (CharSequence)setting.getString(key, ""))) continue;
                            Bundle eparam = new Bundle();
                            eparam.putInt("yys", phone + 1);
                            if (subscriptionInfo.getMccString() != null && subscriptionInfo.getMncString() != null) {
                                eparam.putString("mcc", subscriptionInfo.getMccString());
                                eparam.putString("mnc", subscriptionInfo.getMncString());
                            } else {
                                try {
                                    TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                                    Method method = TelephonyManager.class.getMethod("getSimOperatorNumeric", Integer.class);
                                    String simOperator = (String)method.invoke((Object)telephonyManager, subscriptionInfo.getSubscriptionId());
                                    if (!TextUtils.isEmpty((CharSequence)simOperator) && simOperator.length() > 3) {
                                        eparam.putString("mcc", simOperator.substring(0, 3));
                                        eparam.putString("mnc", simOperator.substring(3));
                                    }
                                }
                                catch (Exception e) {
                                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                                }
                            }
                            if (eparam.containsKey("mcc") && eparam.containsKey("mnc")) {
                                new AthenaCust("operator", 9999).trackCommon(eparam, null).submit();
                            } else {
                                TrackData trackData = new TrackData().add("en", "operator", 2).add("cnt", 1, 1);
                                AthenaAnalytics.getInstance((int)9999).track("data_discard", trackData, 9999);
                            }
                            setting.edit().putString(key, imsi).apply();
                        }
                        return;
                    }
                    catch (Exception e) {
                        DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                        return;
                    }
                }
                if ("android.bluetooth.device.action.BOND_STATE_CHANGED".equals(action)) {
                    try {
                        BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                        int state = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", -1);
                        if (state != 12 || device == null) return;
                        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
                        if (TextUtils.isEmpty((CharSequence)device.getAddress()) || adapter == null) {
                            TrackData trackData = new TrackData().add("en", "bluetooth", 2).add("cnt", 1, 1);
                            AthenaAnalytics.getInstance((int)9999).track("data_discard", trackData, 9999);
                            return;
                        }
                        String hexString = Integer.toHexString(device.getBluetoothClass().getDeviceClass());
                        if (!hexString.startsWith("0x")) {
                            hexString = (hexString.length() % 2 == 0 ? "0x" : "0x0") + hexString;
                        }
                        Bundle eparam = new Bundle();
                        eparam.putString("wldz", device.getAddress());
                        eparam.putString("lylx", adapter.getAddress());
                        eparam.putString("name", device.getName() == null ? "" : device.getName());
                        eparam.putString("type", DCSReceiver.this.getDeviceMajor(device));
                        eparam.putString("cod", hexString);
                        new AthenaCust("bluetooth", 9999).trackCommon(eparam, null).submit();
                        return;
                    }
                    catch (Exception e) {
                        DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                    }
                    return;
                }
                if ("android.bluetooth.device.action.ACL_CONNECTED".equals(action)) {
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    DCSReceiver.this.trackBluetoothConnecting(device);
                    return;
                } else if ("android.bluetooth.device.action.ACL_DISCONNECTED".equals(action)) {
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    DCSReceiver.this.trackBluetoothDisconnecting(device);
                    return;
                } else if ("android.intent.action.HEADSET_PLUG".equals(action)) {
                    if (!intent.hasExtra("state")) return;
                    int state = intent.getIntExtra("state", 0);
                    if (state == 0) {
                        if (DCSReceiver.this.mLastHSPlugState != 1) return;
                        long duration = SystemClock.elapsedRealtime() - DCSReceiver.this.mLastHSPlugStartTime;
                        if (duration >= 3000L) {
                            Bundle eparam = new Bundle();
                            eparam.putLong("dur", duration);
                            new AthenaCust("earphone", 9999).trackCommon(eparam, null).submit();
                        }
                        DCSReceiver.this.mLastHSPlugState = 0;
                        return;
                    } else {
                        if (state != 1) return;
                        DCSReceiver.this.mLastHSPlugState = 1;
                        DCSReceiver.this.mLastHSPlugStartTime = SystemClock.elapsedRealtime();
                    }
                    return;
                } else {
                    Bundle eparam;
                    if (!"android.intent.action.ACTION_SHUTDOWN".equals(action)) return;
                    if (DCSReceiver.this.mLastHSPlugState == 1) {
                        long duration = SystemClock.elapsedRealtime() - DCSReceiver.this.mLastHSPlugStartTime;
                        if (duration >= 3000L) {
                            eparam = new Bundle();
                            eparam.putLong("dur", duration);
                            new AthenaCust("earphone", 9999).trackCommon(eparam, null).submit();
                        }
                        DCSReceiver.this.mLastHSPlugState = 0;
                    }
                    if (DCSReceiver.this.mLastNetworkType == DCSUtils.NetworkType.NETWORK_NONE || DCSReceiver.this.mLastConnectTime == 0L) return;
                    long currentTimeMillis = System.currentTimeMillis();
                    if (currentTimeMillis < DCSReceiver.this.mLastConnectTime || currentTimeMillis - DCSReceiver.this.mLastConnectTime >= 604800000L) {
                        return;
                    }
                    eparam = new Bundle();
                    eparam.putInt("net", DCSReceiver.this.mLastNetworkType.ordinal());
                    eparam.putString("start_hour", DCSUtils.transferMillisToDate("yyyy-MM-dd HH:mm", DCSReceiver.this.mLastConnectTime));
                    eparam.putLong("duration", currentTimeMillis - DCSReceiver.this.mLastConnectTime);
                    new AthenaCust("net_duration", 9999).trackCommon(eparam, null).submit();
                    DCSReceiver.this.mLastNetworkType = DCSUtils.NetworkType.NETWORK_NONE;
                    DCSReceiver.this.mLastConnectTime = 0L;
                }
            }
        });
    }

    private String getDeviceMajor(BluetoothDevice device) {
        String major = "UNKNOWN";
        switch (device.getBluetoothClass().getMajorDeviceClass()) {
            case 0: {
                major = "MISC";
                break;
            }
            case 256: {
                major = "COMPUTER";
                break;
            }
            case 512: {
                major = "PHONE";
                break;
            }
            case 768: {
                major = "NETWORKING";
                break;
            }
            case 1024: {
                major = "AUDIO_VIDEO";
                break;
            }
            case 1280: {
                major = "PERIPHERAL";
                break;
            }
            case 1536: {
                major = "IMAGING";
                break;
            }
            case 1792: {
                major = "WEARABLE";
                break;
            }
            case 2048: {
                major = "TOY";
                break;
            }
            case 2304: {
                major = "HEALTH";
                break;
            }
            case 7936: {
                major = "UNCATEGORIZED";
            }
        }
        return major;
    }

    private void trackBluetoothDisconnecting(BluetoothDevice device) {
        try {
            if (device == null) {
                return;
            }
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (TextUtils.isEmpty((CharSequence)device.getAddress()) || adapter == null) {
                TrackData trackData = new TrackData().add("en", "unbluetooth", 2).add("cnt", 1, 1);
                AthenaAnalytics.getInstance((int)9999).track("data_discard", trackData, 9999);
            } else {
                String hexString = Integer.toHexString(device.getBluetoothClass().getDeviceClass());
                if (!hexString.startsWith("0x")) {
                    hexString = (hexString.length() % 2 == 0 ? "0x" : "0x0") + hexString;
                }
                Bundle eparam = new Bundle();
                eparam.putString("wldz", device.getAddress());
                eparam.putString("lylx", adapter.getAddress());
                eparam.putString("name", device.getName() == null ? "" : device.getName());
                eparam.putString("type", this.getDeviceMajor(device));
                eparam.putString("cod", hexString);
                SharedPreferences sp = DCSModule.getInstance().getSharedPreferences();
                long connectingStartTime = sp.getLong(device.getAddress(), 0L);
                if (connectingStartTime > 0L) {
                    eparam.putLong("time", System.currentTimeMillis() - connectingStartTime);
                    sp.edit().putLong(device.getAddress(), 0L).apply();
                }
                eparam.putInt("cnct", 0);
                new AthenaCust("unbluetooth", 9999).trackCommon(eparam, null).submit();
            }
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
    }

    private void trackBluetoothConnecting(BluetoothDevice device) {
        try {
            if (device == null) {
                return;
            }
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (TextUtils.isEmpty((CharSequence)device.getAddress()) || adapter == null) {
                TrackData trackData = new TrackData().add("en", "unbluetooth", 2).add("cnt", 1, 1);
                AthenaAnalytics.getInstance((int)9999).track("data_discard", trackData, 9999);
            } else {
                String hexString = Integer.toHexString(device.getBluetoothClass().getDeviceClass());
                if (!hexString.startsWith("0x")) {
                    hexString = (hexString.length() % 2 == 0 ? "0x" : "0x0") + hexString;
                }
                Bundle eparam = new Bundle();
                eparam.putString("wldz", device.getAddress());
                eparam.putString("lylx", adapter.getAddress());
                eparam.putString("name", device.getName() == null ? "" : device.getName());
                eparam.putString("type", this.getDeviceMajor(device));
                eparam.putString("cod", hexString);
                eparam.putInt("cnct", 1);
                new AthenaCust("unbluetooth", 9999).trackCommon(eparam, null).submit();
                SharedPreferences sp = DCSModule.getInstance().getSharedPreferences();
                sp.edit().putLong(device.getAddress(), System.currentTimeMillis()).apply();
            }
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
    }

    private void updateAppSnapshots(Context context) {
        try {
            this.mAppSnapshotList.clear();
            PackageManager pm = context.getPackageManager();
            List packages = pm.getInstalledPackages(0);
            for (PackageInfo pi : packages) {
                if (DCSUtils.isSystemApp(pi.packageName, pm)) continue;
                String installer = pm.getInstallerPackageName(pi.packageName);
                if (installer == null) {
                    installer = "";
                }
                this.mAppSnapshotList.add(new AppSnapshot(pi.packageName, pi.versionName, String.valueOf(pi.versionCode), installer));
            }
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
    }

    private static class AppSnapshot {
        String packageName;
        String versionName;
        String versionCode;
        String installer;

        AppSnapshot(String packageName, String versionName, String versionCode, String installer) {
            this.packageName = packageName;
            this.versionName = versionName;
            this.versionCode = versionCode;
            this.installer = installer;
        }
    }
}

