/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.track;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import com.transsion.athena.data.TrackData;
import com.transsion.athenacust.AthenaCust;
import com.transsion.dataservice.DCSModule;
import com.transsion.dataservice.SubJob;
import com.transsion.dataservice.SubJobHolder;
import com.transsion.dataservice.util.DCSUtils;
import com.transsion.dataservice.util.DeviceStateUtils;
import com.transsion.ga.AthenaAnalytics;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.List;

public class DeviceUsageSubJob
extends SubJob {
    private static final String KEY_DEVICE_USAGE_LAST_TIME = "last_device_usage_time";

    public DeviceUsageSubJob(SubJobHolder holder, Context context) {
        super(holder, context);
    }

    @Override
    public void doJob() {
        DCSUtils.LOG.i((Object)"------- DeviceUsageSubJob doJob -------");
        LocalDateTime endDate = LocalDateTime.of(LocalDate.now(), LocalTime.of(LocalTime.now().getHour(), 0, 0, 0));
        LocalDateTime startDate = endDate.minusHours(1L);
        long startTime = startDate.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        if (this.mContext != null) {
            this.finish(true);
            return;
        }
        SharedPreferences setting = DCSModule.getInstance().getSharedPreferences();
        long lastTrackTime = setting.getLong(KEY_DEVICE_USAGE_LAST_TIME, 0L);
        if (startTime == lastTrackTime) {
            this.finish(true);
            return;
        }
        if (startTime - lastTrackTime == 0x6DDD00L) {
            this.queryDeviceUsage(startTime - 3600000L, startTime);
            this.queryDeviceUsage(startTime, startTime + 3600000L);
        } else {
            this.queryDeviceUsage(startTime, startTime + 3600000L);
        }
        setting.edit().putLong(KEY_DEVICE_USAGE_LAST_TIME, startTime).apply();
        this.finish(true);
    }

    private void queryDeviceUsage(long startTime, long endTime) {
        try {
            List<DeviceStateUtils.ScreenOnOff> screenOnOffList = DeviceStateUtils.getInstance().queryScreenOnOff(startTime, endTime);
            if (screenOnOffList != null && screenOnOffList.size() > 0) {
                long duration = 0L;
                int count = 0;
                StringBuilder msgBuilder = new StringBuilder();
                for (DeviceStateUtils.ScreenOnOff screenOnOff : screenOnOffList) {
                    if (screenOnOff.on <= startTime && screenOnOff.off >= endTime) {
                        duration += 3600000L;
                        msgBuilder.append(screenOnOff.toString()).append("#");
                        break;
                    }
                    if (screenOnOff.on >= startTime && screenOnOff.off <= endTime) {
                        duration += screenOnOff.off - screenOnOff.on;
                        ++count;
                        msgBuilder.append(screenOnOff.toString()).append("#");
                        continue;
                    }
                    if (screenOnOff.off > startTime && screenOnOff.off <= endTime) {
                        duration += screenOnOff.off - startTime;
                        ++count;
                        msgBuilder.append(screenOnOff.toString()).append("#");
                        continue;
                    }
                    if (screenOnOff.on < startTime || screenOnOff.on >= endTime) continue;
                    duration += endTime - screenOnOff.on;
                    msgBuilder.append(screenOnOff.toString()).append("#");
                }
                if (duration == 3600000L && count == 1) {
                    count = 0;
                } else if (duration > 3600000L) {
                    duration = 3600000L;
                    count = 0;
                    TrackData trackData = new TrackData().add("en", "device_duration").add("msg", msgBuilder.toString());
                    AthenaAnalytics.getInstance((int)9999).track("data_discard", trackData, 9999);
                }
                Bundle eparam = new Bundle();
                eparam.putString("start_hour", DCSUtils.transferMillisToDate("yyyy-MM-dd HH:mm", startTime));
                eparam.putLong("duration", duration);
                eparam.putInt("cnt", count);
                eparam.putString("sn", DCSUtils.getSerialNumber());
                new AthenaCust("device_duration", 9999).trackCommon(eparam, null).submit();
            }
            DeviceStateUtils.getInstance().trimScreenOnOff(startTime);
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
    }
}

