/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.track;

import android.app.usage.NetworkStats;
import android.app.usage.NetworkStatsManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import com.transsion.athenacust.AthenaCust;
import com.transsion.dataservice.DCSModule;
import com.transsion.dataservice.PeriodicSubJob;
import com.transsion.dataservice.SubJobHolder;
import com.transsion.dataservice.util.DCSUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import org.json.JSONArray;
import org.json.JSONObject;

public class NetDurationSubJob
extends PeriodicSubJob {
    public static final String EVENT_NET = "net_size";
    public static final long PERIOD_OF_NET_DURATION = 86400000L;
    public static final String KEY_LAST_NET_DURATION_TIME = "last_net_duration_time";

    public NetDurationSubJob(SubJobHolder holder, Context context) {
        super(holder, context, 86400000L, "net_duration");
    }

    public NetDurationSubJob(SubJobHolder holder, Context context, long period) {
        super(holder, context, period, "net_duration");
    }

    @Override
    public void doJob() {
        DCSUtils.LOG.d((Object)"------- NetDurationSubJob doJob -------");
        if (this.mContext == null) {
            this.finish(true);
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        SharedPreferences setting = DCSModule.getInstance().getSharedPreferences();
        NetworkStatsManager networkStatsManager = (NetworkStatsManager)this.mContext.getSystemService("netstats");
        if (networkStatsManager == null) {
            this.finish(true);
            return;
        }
        LocalDate currentDate = Instant.ofEpochMilli(currentTimeMillis).atZone(ZoneId.systemDefault()).toLocalDate();
        long lastTrackTime = setting.getLong(KEY_LAST_NET_DURATION_TIME, 0L);
        if (lastTrackTime == 0L || currentTimeMillis <= lastTrackTime) {
            LocalDateTime startDateTime = LocalDateTime.of(currentDate.minusDays(1L), LocalTime.MIN);
            long startTime = startDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            try {
                this.queryNetworkStats(networkStatsManager, startTime, startTime + 86400000L - 1L);
            }
            catch (Exception e) {
                DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            }
        } else {
            LocalDate lastLocalDate;
            DCSUtils.LOG.d((Object)("track net duration last time = " + DCSUtils.transferMillisToDate(lastTrackTime) + ",current = " + DCSUtils.transferMillisToDate(currentTimeMillis)));
            if (currentTimeMillis - lastTrackTime >= 604800000L) {
                lastTrackTime = currentTimeMillis - 604800000L;
            }
            LocalDate localDate = lastLocalDate = Instant.ofEpochMilli(lastTrackTime).atZone(ZoneId.systemDefault()).toLocalDate();
            while (localDate.isBefore(currentDate)) {
                LocalDateTime startDateTime = LocalDateTime.of(localDate, LocalTime.MIN);
                long startTime = startDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                try {
                    this.queryNetworkStats(networkStatsManager, startTime, startTime + 86400000L - 1L);
                }
                catch (Exception e) {
                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
                localDate = localDate.plusDays(1L);
            }
        }
        setting.edit().putLong(KEY_LAST_NET_DURATION_TIME, currentTimeMillis).apply();
        this.finish(true);
    }

    private void queryNetworkStats(NetworkStatsManager networkStatsManager, long startTime, long endTime) throws Exception {
        DCSUtils.LOG.i((Object)("track net duration time = " + DCSUtils.transferMillisToDate(startTime)));
        int[] networkTypes = new int[]{1, 0};
        for (int i = 0; i < networkTypes.length; ++i) {
            long byteSize;
            NetworkStats.Bucket bucket = networkStatsManager.querySummaryForDevice(networkTypes[i], null, startTime, endTime);
            if (bucket == null || (byteSize = bucket.getRxBytes() + bucket.getTxBytes()) <= 1024L) continue;
            Bundle eparam = new Bundle();
            eparam.putLong("size", byteSize / 1024L);
            eparam.putInt("net", i + 1);
            eparam.putString("start_date", DCSUtils.transferMillisToDate("yyyy-MM-dd", startTime));
            JSONArray hoursJArray = new JSONArray();
            for (int hour = 0; hour < 24; ++hour) {
                long subStartTime = startTime + (long)hour * 3600000L;
                bucket = networkStatsManager.querySummaryForDevice(networkTypes[i], null, subStartTime, subStartTime + 3600000L - 1L);
                if (bucket == null || (byteSize = bucket.getRxBytes() + bucket.getTxBytes()) <= 1024L) continue;
                hoursJArray.put((Object)new JSONObject().put("_hour", hour > 9 ? Integer.valueOf(hour) : "0" + hour).put("_size", byteSize / 1024L));
            }
            eparam.putString("hours", hoursJArray.toString());
            new AthenaCust(EVENT_NET, 9999).trackCommon(eparam, null).submit();
        }
    }
}

