/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.track;

import android.app.usage.UsageEvents;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.athenacust.AthenaCust;
import com.transsion.dataservice.DCSModule;
import com.transsion.dataservice.SubJob;
import com.transsion.dataservice.SubJobHolder;
import com.transsion.dataservice.util.DCSUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class UsageStatesSubJob
extends SubJob {
    private static final String KEY_USAGE_STATS_LAST_TIME = "last_usage_stats_time";
    private static final String PREFIX_ORIGIN_NOTIFICATION = "noti-";
    private static final int EVENT_LAUNCH_ACTIVITY = 1000;

    public UsageStatesSubJob(SubJobHolder holder, Context context) {
        super(holder, context);
    }

    @Override
    public void doJob() {
        DCSUtils.LOG.d((Object)"------- UsageStatesSubJob doJob -------");
        LocalDateTime nDateTime = LocalDateTime.of(LocalDate.now(), LocalTime.of(LocalTime.now().getHour(), 0, 0, 0));
        long tStartTime = nDateTime.minusHours(2L).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        if (this.mContext == null) {
            this.finish(true);
            return;
        }
        SharedPreferences setting = DCSModule.getInstance().getSharedPreferences();
        long lastTrackTime = setting.getLong(KEY_USAGE_STATS_LAST_TIME, 0L);
        if (tStartTime == lastTrackTime) {
            this.finish(true);
            return;
        }
        UsageStatsManager usageStatsManager = (UsageStatsManager)this.mContext.getSystemService("usagestats");
        if (usageStatsManager == null) {
            this.finish(true);
            return;
        }
        if (lastTrackTime == 0L || tStartTime < lastTrackTime) {
            try {
                DCSUtils.LOG.d((Object)("track app_use start time = " + DCSUtils.transferMillisToDate(tStartTime)));
                this.queryUsageStats(usageStatsManager, tStartTime, tStartTime + 3600000L);
            }
            catch (Exception e) {
                DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            }
        } else {
            for (long pStartTime = lastTrackTime + 3600000L; pStartTime <= tStartTime; pStartTime += 3600000L) {
                try {
                    DCSUtils.LOG.d((Object)("track app_use start time = " + DCSUtils.transferMillisToDate(pStartTime)));
                    this.queryUsageStats(usageStatsManager, pStartTime, pStartTime + 3600000L);
                    continue;
                }
                catch (Exception e) {
                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
            }
        }
        setting.edit().putLong(KEY_USAGE_STATS_LAST_TIME, tStartTime).apply();
        this.finish(true);
    }

    /*
     * Unable to fully structure code
     */
    private void queryUsageStats(UsageStatsManager usageStatsManager, long tStartTime, long tEndTime) {
        qStartTime = tStartTime - 0x6DDD00L;
        qEndTime = tStartTime + 0x6DDD00L;
        appUsageMap = new HashMap<String, ArrayList<AppUsageEvent>>();
        appUsDuMap = new HashMap<String, ArrayList<E>>();
        packageManager = this.mContext.getPackageManager();
        usageEvents = usageStatsManager.queryEvents(qStartTime, qEndTime);
        event = new UsageEvents.Event();
        lastForegroundPkg = null;
        lastBackgroundPkg = null;
        lastOriginPkg = null;
        screenOffOn = false;
        appUsageEvents = null;
        block10: while (usageEvents.getNextEvent(event)) {
            packageName = event.getPackageName();
            timestamp = event.getTimeStamp();
            switch (event.getEventType()) {
                case 1000: {
                    lastOriginPkg = event.getPackageName();
                    ** GOTO lbl67
                }
                case 15: {
                    screenOffOn = true;
                    lastBackgroundPkg = null;
                    ** GOTO lbl67
                }
                case 1: {
                    appUsageEvents = (ArrayList<AppUsageEvent>)appUsageMap.get(packageName);
                    if (appUsageEvents == null) {
                        appUsageEvents = new ArrayList<AppUsageEvent>();
                        appUsageMap.put(packageName, appUsageEvents);
                    }
                    lastForegroundPkg = packageName;
                    appUsageEvents.add(new AppUsageEvent(event));
                    ** GOTO lbl67
                }
                case 2: {
                    appUsageEvents = (List)appUsageMap.get(packageName);
                    if (appUsageEvents != null && appUsageEvents.size() > 0) {
                        appUsageEvent = (AppUsageEvent)appUsageEvents.get(appUsageEvents.size() - 1);
                        if (appUsageEvent.eventType == 1) {
                            duration = timestamp - appUsageEvent.timestamp;
                            usDuList = (ArrayList<UsDu>)appUsDuMap.get(packageName);
                            if (usDuList == null) {
                                usDuList = new ArrayList<UsDu>();
                                usDuList.add(new UsDu(appUsageEvent.timestamp, timestamp, duration, screenOffOn != false ? 0 : 1, this.getOriginPackage(lastOriginPkg), this.getOriginType(lastOriginPkg)));
                                appUsDuMap.put(packageName, usDuList);
                            } else if (TextUtils.equals((CharSequence)lastBackgroundPkg, (CharSequence)packageName) && TextUtils.equals((CharSequence)lastForegroundPkg, (CharSequence)packageName)) {
                                usDuSize = usDuList.size();
                                if (usDuSize > 0) {
                                    usDu = (UsDu)usDuList.get(usDuSize - 1);
                                    usDu.ue = timestamp;
                                    usDu.du += duration;
                                } else {
                                    usDuList.add(new UsDu(appUsageEvent.timestamp, timestamp, duration, screenOffOn != false ? 0 : 1, this.getOriginPackage(lastOriginPkg), this.getOriginType(lastOriginPkg)));
                                }
                            } else {
                                usDuList.add(new UsDu(appUsageEvent.timestamp, timestamp, duration, screenOffOn != false ? 0 : 1, this.getOriginPackage(lastOriginPkg), this.getOriginType(lastOriginPkg)));
                            }
                            if (lastBackgroundPkg != null && !lastBackgroundPkg.equals(packageName) && appUsageEvent.timestamp <= tStartTime && (tmpUsDuList = (List)appUsDuMap.get(lastBackgroundPkg)) != null) {
                                tmpUsDuList.clear();
                            }
                        }
                        lastBackgroundPkg = packageName;
                        appUsageEvents.add(new AppUsageEvent(event));
                    }
                    screenOffOn = false;
                    if (timestamp > tEndTime) break block10;
                }
lbl67:
                // 5 sources

                default: {
                    continue block10;
                }
            }
        }
        for (Map.Entry<K, V> usDuEntry : appUsDuMap.entrySet()) {
            packageName = (String)usDuEntry.getKey();
            usduJArray = new JSONArray();
            try {
                for (UsDu usDu : (List)usDuEntry.getValue()) {
                    if (usDu.du > 86400000L || usDu.ue <= tStartTime || usDu.ue > tEndTime) continue;
                    usduJArray.put((Object)new JSONObject().put("_us", (Object)DCSUtils.transferMillisToDate("yyyy-MM-dd HH:mm:ss", usDu.us)).put("_du", usDu.du).put("_origin", (Object)usDu.origin).put("_re", usDu.re).put("_cnt", usDu.cnt));
                }
            }
            catch (Exception e) {
                DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            }
            if (usduJArray.length() == 0 || usduJArray.length() >= 3000) continue;
            eparam = new Bundle();
            eparam.putString("pkg", packageName);
            try {
                pi = packageManager.getPackageInfo(packageName, 0);
                eparam.putString("vn", pi != null ? pi.versionName : "0");
                eparam.putString("vc", pi != null ? String.valueOf(pi.versionCode) : "0");
                installerPkg = packageManager.getInstallerPackageName(packageName);
                eparam.putString("ch", installerPkg != null ? installerPkg : "");
                eparam.putInt("is_system", DCSUtils.isSystemApp(packageName, packageManager) != false ? 1 : 0);
            }
            catch (Exception var25_29) {
                // empty catch block
            }
            eparam.putString("uselist", usduJArray.toString());
            eparam.putString("start_hour", DCSUtils.transferMillisToDate("yyyy-MM-dd HH:mm", tStartTime));
            new AthenaCust("app_use", 9999).trackCommon(eparam, null).submit();
        }
    }

    private int getOriginType(String origin) {
        if (origin != null && origin.startsWith(PREFIX_ORIGIN_NOTIFICATION)) {
            return 1;
        }
        return 0;
    }

    private String getOriginPackage(String origin) {
        if (origin != null) {
            String[] s = origin.split("-");
            return s[s.length - 1];
        }
        return origin;
    }

    private class UsDu {
        long us;
        long ue;
        long du;
        int cnt;
        String origin;
        int re;

        private UsDu(long us, long ue, long du, int cnt, String origin, int re) {
            this.us = us;
            this.ue = ue;
            this.du = du;
            this.cnt = cnt;
            this.origin = origin;
            this.re = re;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("us = ").append(DCSUtils.transferMillisToDate("HH:mm:ss", this.us)).append(",").append("ue = ").append(DCSUtils.transferMillisToDate("HH:mm:ss", this.ue)).append(",").append("du = ").append(this.du).append(",").append("cnt = ").append(this.cnt);
            return builder.toString();
        }
    }

    private class AppUsageEvent {
        String pkgName;
        long timestamp;
        int eventType;

        private AppUsageEvent(UsageEvents.Event event) {
            this.pkgName = event.getPackageName();
            this.timestamp = event.getTimeStamp();
            this.eventType = event.getEventType();
        }
    }
}

