/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.infra.gateway.core;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.transsion.infra.gateway.core.bean.GatewayResponse;
import com.transsion.infra.gateway.core.bean.GatewaySignKey;
import com.transsion.infra.gateway.core.bean.RequestBean;
import com.transsion.infra.gateway.core.bean.TimeBean;
import com.transsion.infra.gateway.core.sercurity.Crypto;
import com.transsion.infra.gateway.core.sercurity.HttpSigner;
import com.transsion.infra.gateway.core.utils.ContextUtils;
import com.transsion.infra.gateway.core.utils.GatewayCoreUtils;
import com.transsion.infra.gateway.core.utils.SafeStringUtils;
import com.transsion.json.Tson;

public class GatewaySignManager {
    public static void init(Context context) {
        ContextUtils.init(context);
    }

    public static String doSign(RequestBean requestBean) {
        GatewayCoreUtils.L.d("requestBean" + requestBean.toString());
        return HttpSigner.doSign(requestBean);
    }

    public static boolean needRetryForTimeIssue(int code, String response, GatewaySignKey key) {
        if (code == 200 || TextUtils.isEmpty((CharSequence)response)) {
            return false;
        }
        try {
            GatewayCoreUtils.L.d("response" + response);
            GatewayResponse gatewayResponse = (GatewayResponse)Tson.fromJson((String)response, GatewayResponse.class);
            String errorMsg = "GW.4410";
            if (errorMsg.equals(gatewayResponse.errorCode)) {
                GatewayCoreUtils.L.d("verify sign failed, retrying update time");
                String msg = gatewayResponse.errorMsg;
                if (Build.VERSION.SDK_INT >= 19) {
                    TimeBean time = (TimeBean)Tson.fromJson((String)Crypto.decrypt(msg, key.getKey()), TimeBean.class);
                    if (time.time > 0L) {
                        SafeStringUtils.getInstance(ContextUtils.getContext()).saveLong("time_offset", time.time - System.currentTimeMillis());
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            GatewayCoreUtils.L.e(e);
        }
        return false;
    }
}

