/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.infra.gateway.core.sercurity;

import android.util.Base64;
import com.transsion.infra.gateway.core.sercurity.SignAlgorithm;
import com.transsion.infra.gateway.core.sercurity.Signer;
import com.transsion.infra.gateway.core.utils.GatewayCoreUtils;
import java.nio.charset.Charset;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class BasicSigner
extends Signer {
    private final String secret;

    public BasicSigner(String secret) {
        this.secret = secret;
    }

    @Override
    public String sign(SignAlgorithm algo, String content) {
        try {
            Mac hmac = Mac.getInstance(algo.name());
            hmac.init(new SecretKeySpec(Base64.decode((String)this.secret, (int)2), algo.name()));
            byte[] md5Result = hmac.doFinal(content.getBytes(Charset.forName("UTF-8")));
            return Base64.encodeToString((byte[])md5Result, (int)2);
        }
        catch (Exception e) {
            e.printStackTrace();
            GatewayCoreUtils.L.e(e);
            return "";
        }
    }
}

