/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.infra.gateway.core.sercurity;

import android.text.TextUtils;
import com.transsion.infra.gateway.core.bean.RequestBean;
import com.transsion.infra.gateway.core.sercurity.BasicSigner;
import com.transsion.infra.gateway.core.sercurity.SignAlgorithm;
import com.transsion.infra.gateway.core.sercurity.Signer;
import com.transsion.infra.gateway.core.utils.ContextUtils;
import com.transsion.infra.gateway.core.utils.EncoderUtil;
import com.transsion.infra.gateway.core.utils.GatewayCoreUtils;
import com.transsion.infra.gateway.core.utils.SafeStringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class HttpSigner {
    private final Signer signer;

    public HttpSigner(Signer signer) {
        this.signer = signer;
    }

    public static String doSign(RequestBean requestBean) {
        if (requestBean == null) {
            GatewayCoreUtils.L.d("request bean is null");
            return null;
        }
        if (requestBean.getMethod() == null) {
            GatewayCoreUtils.L.d("request method is null");
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)requestBean.getUrl())) {
            GatewayCoreUtils.L.d("request url is null");
            return null;
        }
        if (requestBean.getKey() == null) {
            GatewayCoreUtils.L.d("request key is null");
            return null;
        }
        if (requestBean.getKey().getKey() == null) {
            GatewayCoreUtils.L.d("request key is null");
            return null;
        }
        long offset = SafeStringUtils.getInstance(ContextUtils.getContext()).getLong("time_offset");
        long timeStamp = System.currentTimeMillis() + offset;
        String secret = requestBean.getKey().getKey();
        BasicSigner basicSigner = new BasicSigner(secret);
        HttpSigner httpSigner = new HttpSigner(basicSigner);
        String sign = httpSigner.sign(requestBean.getMethod(), requestBean.getAccept(), requestBean.getContentType(), requestBean.getUrl(), requestBean.getBody(), timeStamp, requestBean.getKey().getAlgorithm());
        String signString = timeStamp + "|" + requestBean.getKey().getKeyVersion() + "|" + sign;
        GatewayCoreUtils.L.d("x-tr-signature: " + signString);
        return signString;
    }

    public String sign(String method, String accept, String contentType, String url, String body, long timeStamp, SignAlgorithm algorithm) {
        String content = this.generateContent(method, accept, contentType, url, body, timeStamp);
        return this.signer.sign(algorithm, content);
    }

    private String generateContent(String method, String accept, String contentType, String url, String body, long timeStamp) {
        long contentLength;
        String md5;
        StringBuilder stringBuilder;
        block5: {
            stringBuilder = new StringBuilder();
            md5 = "";
            contentLength = 0L;
            if (!TextUtils.isEmpty((CharSequence)body)) {
                try {
                    contentLength = body.length();
                    long timenow = System.currentTimeMillis();
                    if (body.length() > 102400) {
                        md5 = EncoderUtil.md5(body.substring(0, 102400));
                        break block5;
                    }
                    md5 = EncoderUtil.md5(body);
                }
                catch (Exception e) {
                    GatewayCoreUtils.L.e("generateContent exception" + e.toString());
                }
            } else {
                GatewayCoreUtils.L.d("request body is null");
            }
        }
        stringBuilder.append(method.toUpperCase()).append("\n").append(accept == null ? "" : accept).append("\n").append(contentType == null ? "" : contentType).append("\n").append(contentLength == 0L ? "" : Long.valueOf(contentLength)).append("\n").append(timeStamp).append("\n").append(TextUtils.isEmpty((CharSequence)md5) ? "" : md5).append("\n").append(this.buildPathAndParameters(url));
        GatewayCoreUtils.L.d(stringBuilder.toString());
        return stringBuilder.toString();
    }

    private String splitQuery(String queryString) {
        String[] pairs;
        HashMap<String, String> queryPairs = new HashMap<String, String>();
        for (String pair : pairs = queryString.split("&")) {
            int idx = pair.indexOf("=");
            try {
                queryPairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.formatUrlMap(queryPairs);
    }

    private String formatUrlMap(Map<String, String> paraMap) {
        String buff;
        try {
            ArrayList<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(paraMap.entrySet());
            Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            StringBuilder buf = new StringBuilder();
            for (Map.Entry entry : infoIds) {
                if ("".equals(entry.getKey())) continue;
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                buf.append(key).append("=").append(val);
                buf.append("&");
            }
            if (buf.length() > 0) {
                buf.deleteCharAt(buf.length() - 1);
            }
            buff = buf.toString();
        }
        catch (Exception e) {
            return null;
        }
        return buff;
    }

    private String buildPathAndParameters(String url) {
        String formatedUrl;
        URI uri;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return "";
        }
        stringBuilder.append(uri.getPath());
        if (!TextUtils.isEmpty((CharSequence)uri.getQuery()) && !TextUtils.isEmpty((CharSequence)(formatedUrl = this.splitQuery(uri.getQuery())))) {
            stringBuilder.append("?").append(formatedUrl);
        }
        return stringBuilder.toString();
    }
}

